/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.la;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ToDoubleBiFunction;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.Output;
import org.tribuo.math.la.DenseMatrix;
import org.tribuo.math.la.DenseSparseMatrix;
import org.tribuo.math.la.Matrix;
import org.tribuo.math.la.SGDVector;
import org.tribuo.math.la.SparseVector;
import org.tribuo.math.la.Tensor;
import org.tribuo.math.la.VectorIterator;
import org.tribuo.math.la.VectorTuple;
import org.tribuo.math.util.VectorNormalizer;
import org.tribuo.util.Util;

public class DenseVector
implements SGDVector {
    private static final long serialVersionUID = 1L;
    private final int[] shape;
    protected final double[] elements;

    public DenseVector(int size) {
        this(size, 0.0);
    }

    public DenseVector(int size, double value) {
        this.elements = new double[size];
        Arrays.fill(this.elements, value);
        this.shape = new int[]{size};
    }

    protected DenseVector(double[] values) {
        this.elements = values;
        this.shape = new int[]{this.elements.length};
    }

    protected DenseVector(DenseVector other) {
        this(other.toArray());
    }

    public static DenseVector createDenseVector(double[] values) {
        return new DenseVector(Arrays.copyOf(values, values.length));
    }

    public static <T extends Output<T>> DenseVector createDenseVector(Example<T> example, ImmutableFeatureMap featureInfo, boolean addBias) {
        int numFeatures = addBias ? featureInfo.size() + 1 : featureInfo.size();
        double[] values = new double[numFeatures];
        boolean found = false;
        for (Feature f : example) {
            int index = featureInfo.getID(f.getName());
            if (index == -1) continue;
            values[index] = f.getValue();
            found = true;
            if (!Double.isNaN(values[index])) continue;
            throw new IllegalArgumentException("Example contained a NaN feature, " + f.toString());
        }
        if (!found) {
            throw new IllegalArgumentException("No features in this example were found in the feature map. Example - " + example.toString());
        }
        if (addBias) {
            values[numFeatures - 1] = 1.0;
        }
        return new DenseVector(values);
    }

    @Override
    public double[] toArray() {
        return Arrays.copyOf(this.elements, this.elements.length);
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public Tensor reshape(int[] newShape) {
        int sum = Tensor.shapeSum(newShape);
        if (sum != this.elements.length) {
            throw new IllegalArgumentException("Invalid shape " + Arrays.toString(newShape) + ", expected something with " + this.elements.length + " elements.");
        }
        if (newShape.length == 2) {
            DenseMatrix matrix = new DenseMatrix(newShape[0], newShape[1]);
            for (int a = 0; a < this.size(); ++a) {
                int i = a % newShape[0];
                int j = a / newShape[0];
                matrix.set(i, j, this.get(a));
            }
            return matrix;
        }
        if (newShape.length == 1) {
            return new DenseVector(this);
        }
        throw new IllegalArgumentException("Only supports 1 or 2 dimensional tensors.");
    }

    @Override
    public DenseVector copy() {
        return new DenseVector(this.toArray());
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public int numActiveElements() {
        return this.elements.length;
    }

    @Override
    public double reduce(double initialValue, DoubleUnaryOperator op, DoubleBinaryOperator reduction) {
        double output = initialValue;
        for (int i = 0; i < this.elements.length; ++i) {
            double transformed = op.applyAsDouble(this.get(i));
            output = reduction.applyAsDouble(transformed, output);
        }
        return output;
    }

    public boolean equals(Object other) {
        if (other instanceof SGDVector) {
            SGDVector otherVector = (SGDVector)other;
            if (this.elements.length == otherVector.size()) {
                VectorIterator ourItr = this.iterator();
                Iterator otherItr = ((SGDVector)other).iterator();
                while (ourItr.hasNext() && otherItr.hasNext()) {
                    VectorTuple otherTuple;
                    VectorTuple ourTuple = (VectorTuple)ourItr.next();
                    if (ourTuple.equals(otherTuple = (VectorTuple)otherItr.next())) continue;
                    return false;
                }
                return !ourItr.hasNext() && !otherItr.hasNext();
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    @Override
    public DenseVector add(SGDVector other) {
        if (other.size() != this.elements.length) {
            throw new IllegalArgumentException("Can't add two vectors of different dimension, this = " + this.elements.length + ", other = " + other.size());
        }
        double[] newValues = this.toArray();
        for (VectorTuple tuple : other) {
            int n = tuple.index;
            newValues[n] = newValues[n] + tuple.value;
        }
        return new DenseVector(newValues);
    }

    @Override
    public DenseVector subtract(SGDVector other) {
        if (other.size() != this.elements.length) {
            throw new IllegalArgumentException("Can't subtract two vectors of different dimension, this = " + this.elements.length + ", other = " + other.size());
        }
        double[] newValues = this.toArray();
        for (VectorTuple tuple : other) {
            int n = tuple.index;
            newValues[n] = newValues[n] - tuple.value;
        }
        return new DenseVector(newValues);
    }

    @Override
    public void intersectAndAddInPlace(Tensor other, DoubleUnaryOperator f) {
        if (other instanceof SGDVector) {
            SGDVector otherVec = (SGDVector)other;
            if (otherVec.size() != this.elements.length) {
                throw new IllegalArgumentException("Can't intersect two vectors of different dimension, this = " + this.elements.length + ", other = " + otherVec.size());
            }
            if (otherVec instanceof DenseVector) {
                for (int i = 0; i < this.elements.length; ++i) {
                    int n = i;
                    this.elements[n] = this.elements[n] + f.applyAsDouble(otherVec.get(i));
                }
            } else {
                for (VectorTuple tuple : otherVec) {
                    int n = tuple.index;
                    this.elements[n] = this.elements[n] + f.applyAsDouble(tuple.value);
                }
            }
        } else {
            throw new IllegalArgumentException("Adding a non-Vector to a Vector");
        }
    }

    @Override
    public void hadamardProductInPlace(Tensor other, DoubleUnaryOperator f) {
        if (other instanceof SGDVector) {
            SGDVector otherVec = (SGDVector)other;
            if (otherVec.size() != this.elements.length) {
                throw new IllegalArgumentException("Can't hadamard product two vectors of different dimension, this = " + this.elements.length + ", other = " + otherVec.size());
            }
            if (otherVec instanceof DenseVector) {
                for (int i = 0; i < this.elements.length; ++i) {
                    int n = i;
                    this.elements[n] = this.elements[n] * f.applyAsDouble(otherVec.get(i));
                }
            } else {
                for (VectorTuple tuple : otherVec) {
                    int n = tuple.index;
                    this.elements[n] = this.elements[n] * f.applyAsDouble(tuple.value);
                }
            }
        } else {
            throw new IllegalArgumentException("Scaling a Vector by a non-Vector");
        }
    }

    @Override
    public void foreachInPlace(DoubleUnaryOperator f) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = f.applyAsDouble(this.elements[i]);
        }
    }

    @Override
    public void foreachIndexedInPlace(ToDoubleBiFunction<Integer, Double> f) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = f.applyAsDouble(i, this.elements[i]);
        }
    }

    @Override
    public DenseVector scale(double coefficient) {
        DenseVector output = this.copy();
        output.scaleInPlace(coefficient);
        return output;
    }

    @Override
    public void add(int index, double value) {
        int n = index;
        this.elements[n] = this.elements[n] + value;
    }

    @Override
    public double dot(SGDVector other) {
        if (other.size() != this.elements.length) {
            throw new IllegalArgumentException("Can't dot two vectors of different dimension, this = " + this.elements.length + ", other = " + other.size());
        }
        double score = 0.0;
        if (other instanceof DenseVector) {
            for (int i = 0; i < this.elements.length; ++i) {
                score += this.get(i) * other.get(i);
            }
        } else {
            for (VectorTuple tuple : other) {
                score += this.get(tuple.index) * tuple.value;
            }
        }
        return score;
    }

    @Override
    public Matrix outer(SGDVector other) {
        if (other instanceof DenseVector) {
            DenseVector otherVec = (DenseVector)other;
            double[][] output = new double[this.elements.length][];
            for (int i = 0; i < this.elements.length; ++i) {
                DenseVector tmp = otherVec.scale(this.get(i));
                output[i] = tmp.elements;
            }
            return new DenseMatrix(output);
        }
        if (other instanceof SparseVector) {
            SparseVector otherVec = (SparseVector)other;
            SparseVector[] output = new SparseVector[this.elements.length];
            for (int i = 0; i < this.elements.length; ++i) {
                output[i] = otherVec.scale(this.get(i));
            }
            return new DenseSparseMatrix(output);
        }
        throw new IllegalArgumentException("Invalid vector subclass " + other.getClass().getCanonicalName() + " for input");
    }

    @Override
    public double sum() {
        double sum = 0.0;
        for (int i = 0; i < this.elements.length; ++i) {
            sum += this.get(i);
        }
        return sum;
    }

    public double sum(DoubleUnaryOperator f) {
        double sum = 0.0;
        for (int i = 0; i < this.elements.length; ++i) {
            sum += f.applyAsDouble(this.get(i));
        }
        return sum;
    }

    @Override
    public double twoNorm() {
        double sum = 0.0;
        for (int i = 0; i < this.elements.length; ++i) {
            double value = this.get(i);
            sum += value * value;
        }
        return Math.sqrt(sum);
    }

    @Override
    public double oneNorm() {
        double sum = 0.0;
        for (int i = 0; i < this.elements.length; ++i) {
            sum += Math.abs(this.get(i));
        }
        return sum;
    }

    @Override
    public double get(int index) {
        return this.elements[index];
    }

    @Override
    public void set(int index, double value) {
        this.elements[index] = value;
    }

    public void setElements(DenseVector other) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = other.get(i);
        }
    }

    public void fill(double value) {
        Arrays.fill(this.elements, value);
    }

    @Override
    public int indexOfMax() {
        int index = 0;
        double value = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.elements.length; ++i) {
            double tmp = this.get(i);
            if (!(tmp > value)) continue;
            index = i;
            value = tmp;
        }
        return index;
    }

    @Override
    public double maxValue() {
        double value = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.elements.length; ++i) {
            double tmp = this.get(i);
            if (!(tmp > value)) continue;
            value = tmp;
        }
        return value;
    }

    @Override
    public double minValue() {
        double value = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.elements.length; ++i) {
            double tmp = this.get(i);
            if (!(tmp < value)) continue;
            value = tmp;
        }
        return value;
    }

    @Override
    public void normalize(VectorNormalizer normalizer) {
        normalizer.normalizeInPlace(this.elements);
    }

    public void expNormalize(double total) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = Math.exp(this.elements[i] - total);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DenseVector(size=");
        buffer.append(this.elements.length);
        buffer.append(",values=[");
        for (int i = 0; i < this.elements.length; ++i) {
            buffer.append(this.get(i));
            buffer.append(",");
        }
        buffer.setCharAt(buffer.length() - 1, ']');
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public double variance(double mean) {
        double variance = 0.0;
        for (int i = 0; i < this.elements.length; ++i) {
            double value = this.get(i) - mean;
            variance += value * value;
        }
        return variance;
    }

    public VectorIterator iterator() {
        return new DenseVectorIterator(this);
    }

    public SparseVector sparsify() {
        return this.sparsify(1.0E-12);
    }

    public SparseVector sparsify(double tolerance) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < this.elements.length; ++i) {
            double value = this.get(i);
            if (!(Math.abs(value) > tolerance)) continue;
            indices.add(i);
            values.add(value);
        }
        return new SparseVector(this.elements.length, Util.toPrimitiveInt(indices), Util.toPrimitiveDouble(values));
    }

    @Override
    public double euclideanDistance(SGDVector other) {
        if (other.size() != this.elements.length) {
            throw new IllegalArgumentException("Can't measure distance of two vectors of different lengths, this = " + this.elements.length + ", other = " + other.size());
        }
        if (other instanceof DenseVector) {
            double score = 0.0;
            for (int i = 0; i < this.elements.length; ++i) {
                double tmp = this.get(i) - other.get(i);
                score += tmp * tmp;
            }
            return Math.sqrt(score);
        }
        if (other instanceof SparseVector) {
            double value;
            double score = 0.0;
            int i = 0;
            Iterator otherItr = other.iterator();
            while (i < this.elements.length && otherItr.hasNext()) {
                VectorTuple otherTuple = (VectorTuple)otherItr.next();
                while (i < this.elements.length && i < otherTuple.index) {
                    value = this.get(i);
                    score += value * value;
                    ++i;
                }
                if (i != otherTuple.index) continue;
                double tmp = this.get(i) - otherTuple.value;
                score += tmp * tmp;
                ++i;
            }
            while (i < this.elements.length) {
                value = this.get(i);
                score += value * value;
                ++i;
            }
            return Math.sqrt(score);
        }
        throw new IllegalArgumentException("Unknown vector subclass " + other.getClass().getCanonicalName() + " for input");
    }

    @Override
    public double l1Distance(SGDVector other) {
        if (other.size() != this.elements.length) {
            throw new IllegalArgumentException("Can't measure distance of two vectors of different lengths, this = " + this.elements.length + ", other = " + other.size());
        }
        if (other instanceof DenseVector) {
            double score = 0.0;
            for (int i = 0; i < this.elements.length; ++i) {
                score += Math.abs(this.get(i) - other.get(i));
            }
            return score;
        }
        if (other instanceof SparseVector) {
            double score = 0.0;
            int i = 0;
            Iterator otherItr = other.iterator();
            while (i < this.elements.length && otherItr.hasNext()) {
                VectorTuple otherTuple = (VectorTuple)otherItr.next();
                while (i < this.elements.length && i < otherTuple.index) {
                    score += Math.abs(this.get(i));
                    ++i;
                }
                if (i != otherTuple.index) continue;
                score += Math.abs(this.get(i) - otherTuple.value);
                ++i;
            }
            while (i < this.elements.length) {
                score += Math.abs(this.get(i));
                ++i;
            }
            return score;
        }
        throw new IllegalArgumentException("Unknown vector subclass " + other.getClass().getCanonicalName() + " for input");
    }

    private static class DenseVectorIterator
    implements VectorIterator {
        private final DenseVector vector;
        private final VectorTuple tuple;
        private int index;

        public DenseVectorIterator(DenseVector vector) {
            this.vector = vector;
            this.tuple = new VectorTuple();
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.vector.elements.length;
        }

        @Override
        public VectorTuple next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Off the end of the iterator.");
            }
            this.tuple.index = this.index;
            this.tuple.value = this.vector.elements[this.index];
            ++this.index;
            return this.tuple;
        }

        @Override
        public VectorTuple getReference() {
            return this.tuple;
        }
    }
}

