/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.slf4j.Logger;

public class ChainingSignatureTrustEngine
implements SignatureTrustEngine {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingSignatureTrustEngine.class);
    @Nonnull
    private List<SignatureTrustEngine> engines;

    public ChainingSignatureTrustEngine(@Nonnull @ParameterName(name="chain") List<SignatureTrustEngine> chain) {
        this.engines = CollectionSupport.copyToList((Collection)Constraint.isNotNull(chain, "SignatureTrustEngine list cannot be null"));
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<SignatureTrustEngine> getChain() {
        return this.engines;
    }

    @Override
    @Nullable
    public KeyInfoCredentialResolver getKeyInfoResolver() {
        return null;
    }

    @Override
    public boolean validate(@Nonnull Signature token, @Nullable CriteriaSet trustBasisCriteria) throws SecurityException {
        for (SignatureTrustEngine engine : this.engines) {
            if (!engine.validate(token, trustBasisCriteria)) continue;
            this.log.debug("Signature was trusted by chain member: {}", (Object)engine.getClass().getName());
            return true;
        }
        return false;
    }

    @Override
    public boolean validate(@Nonnull byte[] signature, @Nonnull byte[] content, @Nonnull String algorithmURI, @Nullable CriteriaSet trustBasisCriteria, @Nullable Credential candidateCredential) throws SecurityException {
        for (SignatureTrustEngine engine : this.engines) {
            if (!engine.validate(signature, content, algorithmURI, trustBasisCriteria, candidateCredential)) continue;
            this.log.debug("Signature was trusted by chain member: {}", (Object)engine.getClass().getName());
            return true;
        }
        return false;
    }
}

