/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.common.TEdge;
import org.eclipse.elk.core.math.ElkRectangle;

public final class Utils {
    private Utils() {
    }

    public static double overlap(ElkRectangle r1, ElkRectangle r2) {
        double horizontalOverlap = Math.min(Math.abs(r1.x - (r2.x + r2.width)), Math.abs(r1.x + r1.width - r2.x));
        double verticalOverlap = Math.min(Math.abs(r1.y - (r2.y + r2.height)), Math.abs(r1.y + r1.height - r2.y));
        double horizontalCenterDistance = Math.abs(r1.x + r1.width / 2.0 - (r2.x + r2.width / 2.0));
        if (horizontalCenterDistance > r1.width / 2.0 + r2.width / 2.0) {
            return 1.0;
        }
        double verticalCenterDistance = Math.abs(r1.y + r1.height / 2.0 - (r2.y + r2.height / 2.0));
        if (verticalCenterDistance > r1.height / 2.0 + r2.height / 2.0) {
            return 1.0;
        }
        if (horizontalCenterDistance == 0.0 && verticalCenterDistance == 0.0) {
            return 0.0;
        }
        if (horizontalCenterDistance == 0.0) {
            return verticalOverlap / verticalCenterDistance + 1.0;
        }
        if (verticalCenterDistance == 0.0) {
            return horizontalOverlap / horizontalCenterDistance + 1.0;
        }
        return Math.min(horizontalOverlap / horizontalCenterDistance, verticalOverlap / verticalCenterDistance) + 1.0;
    }

    public static List<TEdge> getRectEdges(ElkRectangle r) {
        ArrayList<TEdge> rectEdegs = Lists.newArrayList();
        rectEdegs.add(new TEdge(r.getTopLeft(), r.getTopRight()));
        rectEdegs.add(new TEdge(r.getTopLeft(), r.getBottomLeft()));
        rectEdegs.add(new TEdge(r.getBottomRight(), r.getTopRight()));
        rectEdegs.add(new TEdge(r.getBottomRight(), r.getBottomLeft()));
        return rectEdegs;
    }
}

