﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/docdb-elastic/DocDBElastic_EXPORTS.h>
#include <aws/docdb-elastic/model/ClusterSnapshot.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DocDBElastic {
namespace Model {
class CreateClusterSnapshotResult {
 public:
  AWS_DOCDBELASTIC_API CreateClusterSnapshotResult() = default;
  AWS_DOCDBELASTIC_API CreateClusterSnapshotResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DOCDBELASTIC_API CreateClusterSnapshotResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Returns information about the new elastic cluster snapshot.</p>
   */
  inline const ClusterSnapshot& GetSnapshot() const { return m_snapshot; }
  template <typename SnapshotT = ClusterSnapshot>
  void SetSnapshot(SnapshotT&& value) {
    m_snapshotHasBeenSet = true;
    m_snapshot = std::forward<SnapshotT>(value);
  }
  template <typename SnapshotT = ClusterSnapshot>
  CreateClusterSnapshotResult& WithSnapshot(SnapshotT&& value) {
    SetSnapshot(std::forward<SnapshotT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateClusterSnapshotResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ClusterSnapshot m_snapshot;

  Aws::String m_requestId;
  bool m_snapshotHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DocDBElastic
}  // namespace Aws
