/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.ui.config;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.ui.views.CubridOIDSearchDialog;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class CubridOIDHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBNNode node = NavigatorUtils.getSelectedNode((ISelection)selection);
        if (node instanceof DBNDataSource) {
            DBNDataSource dataSourceNode = (DBNDataSource)node;
            DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSourceNode.getDataSourceContainer();
            DBPDataSource dataSource = descriptor.getDataSource();
            CubridDataSource cubrid = (CubridDataSource)dataSource;
            try {
                JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBPDataSource)cubrid, (String)"GetSession");
                CubridOIDSearchDialog dialog = new CubridOIDSearchDialog(activeShell, session);
                dialog.open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

