/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.DOMCharacterException;
import io.sf.carte.doc.DOMNullCharacterException;
import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.PseudoCondition;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.PseudoConditionImpl;
import org.w3c.dom.DOMException;

public class ParseHelper {
    public static final byte ERR_UNEXPECTED_CHAR = 4;
    public static final byte ERR_WRONG_VALUE = 5;
    public static final byte ERR_UNMATCHED_PARENTHESIS = 6;
    public static final byte ERR_INVALID_IDENTIFIER = 7;
    public static final byte ERR_UNEXPECTED_TOKEN = 9;
    public static final byte ERR_UNKNOWN_NAMESPACE = 15;
    public static final byte ERR_EXPR_SYNTAX = 32;
    public static final byte ERR_RULE_SYNTAX = 33;
    public static final byte ERR_UNEXPECTED_EOF = 10;
    public static final byte ERR_IO = 11;
    public static final byte ERR_UNSUPPORTED = 127;
    public static final byte WARN_DUPLICATE_SELECTOR = -1;
    public static final byte WARN_IDENT_COMPAT = -2;
    public static final byte WARN_PROGID_HACK = -3;
    public static final byte WARN_PROPERTY_NAME = -4;
    public static final byte WARN_VALUE = -5;
    public static final byte WARN_UNEXPECTED_EOF = -6;

    public static String unescapeStringValue(String value) {
        return ParseHelper.unescapeStringValue(value, true, true);
    }

    public static String unescapeStringValue(String value, boolean unescapeControl, boolean replaceNull) throws DOMNullCharacterException {
        int cp;
        int iCP = value.indexOf(92);
        if (iCP == -1) {
            return value;
        }
        int len = value.length();
        StringBuilder buf = new StringBuilder(len);
        if (iCP > 0) {
            ParseHelper.appendString(buf, value, 0, iCP);
        }
        int i = ++iCP;
        while (i < len) {
            int digit;
            if (i - iCP > 5) {
                ParseHelper.appendCodePoint(buf, value, iCP, i, unescapeControl, true);
                iCP = value.indexOf(92, i);
                if (iCP == -1) {
                    ParseHelper.appendString(buf, value, i, len);
                    break;
                }
                ParseHelper.appendString(buf, value, i, iCP);
                i = ++iCP;
                if (i == len) break;
            }
            if ((digit = Character.digit((char)(cp = value.charAt(i)), 16)) == -1) {
                int istart;
                if (i != iCP) {
                    if (!ParseHelper.appendCodePoint(buf, value, iCP, i, unescapeControl, replaceNull) || cp == 32) {
                        // empty if block
                    }
                    istart = ++i;
                } else {
                    istart = i + 1;
                }
                iCP = value.indexOf(92, istart);
                if (iCP == -1) {
                    ParseHelper.appendString(buf, value, i, len);
                    break;
                }
                ParseHelper.appendString(buf, value, i, iCP);
                if ((i = ++iCP) != len) continue;
                break;
            }
            ++i;
        }
        if (iCP != -1 && len != iCP) {
            cp = Character.digit(value.charAt(iCP), 16);
            if (cp == -1) {
                ParseHelper.appendString(buf, value, iCP, len);
            } else {
                ParseHelper.appendCodePoint(buf, value, iCP, len, unescapeControl, replaceNull);
            }
        }
        return buf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean appendCodePoint(StringBuilder buf, String value, int idx, int endIdx, boolean unescapeControl, boolean replaceNull) throws DOMNullCharacterException {
        if (idx + 1 == endIdx) {
            char cp = value.charAt(idx);
            int digit = Character.digit(cp, 16);
            if (digit == -1) {
                buf.append(cp);
                return false;
            }
            if (digit == 0 && !replaceNull) throw new DOMNullCharacterException(idx);
            if (ParseHelper.appendCodePoint(buf, digit, unescapeControl)) {
                return true;
            }
        } else {
            try {
                int cp = Integer.parseInt(value.substring(idx, endIdx), 16);
                if (ParseHelper.appendCodePoint(buf, cp, unescapeControl)) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ParseHelper.appendString(buf, value, idx - 1, endIdx);
        return false;
    }

    private static boolean appendCodePoint(StringBuilder buf, int cp, boolean unescapeControl) {
        int type = Character.getType(cp);
        switch (type) {
            case 0: 
            case 18: {
                return false;
            }
            case 15: {
                if (cp == 0) {
                    buf.append('\ufffd');
                    break;
                }
                if (!unescapeControl) {
                    return false;
                }
            }
            default: {
                buf.appendCodePoint(cp);
            }
        }
        return true;
    }

    private static void appendString(StringBuilder buf, CharSequence value, int idx, int endIdx) {
        int prelen = buf.length();
        CharSequence seq = value.subSequence(idx, endIdx);
        buf.append(seq);
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) != '\n') continue;
            buf.setCharAt(prelen + i, '\ufffd');
        }
    }

    public static String escape(String text) {
        return ParseHelper.escape(text, true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String escape(String text, boolean preserveHexEscapes, boolean escapeSurrogates) {
        int len = text.length();
        if (len == 0) {
            return text;
        }
        int i = 0;
        StringBuilder buf = null;
        boolean noesc = true;
        char c = text.charAt(0);
        if (c == '-') {
            if (len == 1) {
                return "\\-";
            }
            int cp = text.codePointAt(1);
            if (cp != 45 && !ParseHelper.isNameStartCharOrEsc((char)cp)) {
                buf = ParseHelper.createStringBuilder(len);
                i = text.offsetByCodePoints(1, 1);
                if (escapeSurrogates && i > 2 || Character.isISOControl(cp)) {
                    buf.append('-').append('\\').append(Integer.toHexString(cp));
                    if (cp < 1048575 && ParseHelper.needsSpace(text, i, len)) {
                        buf.append(' ');
                    }
                } else {
                    buf.append("\\-").appendCodePoint(cp);
                }
                if (i == len) {
                    return buf.toString();
                }
                noesc = false;
            } else {
                i = 1;
            }
            c = text.charAt(i);
        }
        if (c >= '0' && c <= '9') {
            if (noesc) {
                buf = ParseHelper.createStringBuilder(len);
                noesc = false;
                if (i == 1) {
                    buf.append("\\-").append(c);
                } else {
                    buf.append("\\3").append(c).append(' ');
                }
            } else {
                buf.append(c);
            }
            ++i;
        }
        boolean preservingHex = false;
        while (i < len) {
            block44: {
                int cp;
                block45: {
                    block46: {
                        block43: {
                            cp = text.codePointAt(i);
                            if (!(cp >= 48 && cp <= 57 || cp >= 65 && cp <= 90 || cp >= 97 && cp <= 122 || cp == 45) && cp != 95) break block43;
                            if (preservingHex && !ParseHelper.isHexCodePoint(cp)) {
                                preservingHex = false;
                            }
                            if (!noesc) {
                                buf.append((char)cp);
                            }
                            break block44;
                        }
                        if (cp <= 122) break block45;
                        preservingHex = false;
                        if (cp >= 127) break block46;
                        if (noesc) {
                            noesc = false;
                            buf = new StringBuilder(len + 1);
                            buf.append(text.subSequence(0, i));
                        }
                        buf.append('\\').append((char)cp);
                        break block44;
                    }
                    if (cp <= 159 || cp == 160 || cp == 173 || cp == 65533) {
                        if (noesc) {
                            noesc = false;
                            buf = ParseHelper.createStringBuilder(len);
                            buf.append(text.subSequence(0, i));
                        }
                        buf.append('\\').append(Integer.toHexString(cp));
                        if (ParseHelper.needsSpace(text, i + 1, len)) {
                            buf.append(' ');
                        }
                        break block44;
                    } else {
                        int newIdx = text.offsetByCodePoints(i, 1);
                        if (newIdx == i + 1) {
                            if (!noesc) {
                                buf.append((char)cp);
                            }
                        } else if (!escapeSurrogates) {
                            if (!noesc) {
                                buf.appendCodePoint(cp);
                            }
                        } else {
                            if (noesc) {
                                noesc = false;
                                buf = ParseHelper.createStringBuilder(len);
                                buf.append(text.subSequence(0, i));
                            }
                            buf.append('\\').append(Integer.toHexString(cp));
                            if (cp < 1048575 && ParseHelper.needsSpace(text, newIdx, len)) {
                                buf.append(' ');
                            }
                        }
                        i = newIdx;
                        continue;
                    }
                }
                if (cp <= 31 || cp == 32) {
                    if (noesc) {
                        noesc = false;
                        buf = ParseHelper.createStringBuilder(len);
                        buf.append(text.subSequence(0, i));
                    }
                    if (cp == 32) {
                        if (!preservingHex) {
                            buf.append('\\');
                        }
                        buf.append(' ');
                    } else {
                        buf.append('\\').append(Integer.toHexString(cp));
                        if (ParseHelper.needsSpace(text, i + 1, len)) {
                            buf.append(' ');
                        }
                    }
                    preservingHex = false;
                } else if (preserveHexEscapes && cp == 92 && i != len - 1 && ParseHelper.isHexCodePoint(text.codePointAt(i + 1))) {
                    preservingHex = true;
                    if (!noesc) {
                        buf.append('\\');
                    }
                } else {
                    preservingHex = false;
                    if (noesc) {
                        noesc = false;
                        buf = new StringBuilder(len + 1);
                        buf.append(text.subSequence(0, i));
                    }
                    buf.append('\\').append((char)cp);
                }
            }
            ++i;
        }
        if (noesc) {
            return text;
        }
        return buf.toString();
    }

    private static StringBuilder createStringBuilder(int len) {
        return new StringBuilder(len + 24);
    }

    private static boolean needsSpace(CharSequence text, int i, int len) {
        char c;
        return i >= len || (c = text.charAt(i)) == ' ' || ParseHelper.isASCIILetterOrDigitCodePoint(c);
    }

    public static String safeEscape(String text) {
        return ParseHelper.safeEscape(text, false);
    }

    public static String safeEscape(String text, boolean escapeSurrogates) {
        return ParseHelper.safeEscape(text, escapeSurrogates, false);
    }

    static String safeEscape(String text, boolean escapeSurrogates, boolean escapeHighChars) {
        int cp;
        int len = text.length();
        if (len == 0) {
            return text;
        }
        int i = 0;
        StringBuilder buf = null;
        boolean noesc = true;
        char c = text.charAt(0);
        if (c == '-') {
            if (len == 1) {
                return "\\-";
            }
            cp = text.codePointAt(1);
            if (cp != 45 && !ParseHelper.isNameStartCharOrEsc((char)cp)) {
                i = text.offsetByCodePoints(1, 1);
                buf = ParseHelper.createStringBuilder(len);
                if (escapeHighChars && cp >= 128 || Character.isISOControl(cp) || escapeSurrogates && i > 2) {
                    buf.append('-').append('\\').append(Integer.toHexString(cp));
                    if (cp < 1048575 && ParseHelper.needsSpace(text, i, len)) {
                        buf.append(' ');
                    }
                } else {
                    buf.append("\\-").appendCodePoint(cp);
                }
                if (i == len) {
                    return buf.toString();
                }
                noesc = false;
            } else {
                i = 1;
            }
            c = text.charAt(i);
        }
        if (c >= '0' && c <= '9') {
            if (noesc) {
                buf = ParseHelper.createStringBuilder(len);
                noesc = false;
                if (i == 1) {
                    buf.append("\\-").append(c);
                } else {
                    buf.append("\\3").append(c).append(' ');
                }
            } else {
                buf.append(c);
            }
            ++i;
        }
        while (i < len) {
            cp = text.codePointAt(i);
            if (cp >= 48 && cp <= 57 || cp >= 65 && cp <= 90 || cp >= 97 && cp <= 122 || cp == 45 || cp == 95) {
                if (!noesc) {
                    buf.append((char)cp);
                }
            } else {
                if (cp >= 127) {
                    int newIdx = text.offsetByCodePoints(i, 1);
                    if (cp >= 127 && cp <= 159 || cp == 160 || cp == 173 || cp == 65533 || escapeHighChars) {
                        if (noesc) {
                            noesc = false;
                            buf = new StringBuilder(len + 24);
                            buf.append(text.subSequence(0, i));
                        }
                        buf.append('\\').append(Integer.toHexString(cp));
                        if (cp < 1048575 && ParseHelper.needsSpace(text, newIdx, len)) {
                            buf.append(' ');
                        }
                        i = newIdx;
                        continue;
                    }
                    if (newIdx == ++i) {
                        if (noesc) continue;
                        buf.append((char)cp);
                        continue;
                    }
                    if (!escapeSurrogates) {
                        if (!noesc) {
                            buf.appendCodePoint(cp);
                        }
                    } else {
                        if (noesc) {
                            noesc = false;
                            buf = new StringBuilder(len + 24);
                            buf.append(text.subSequence(0, i - 1));
                        }
                        buf.append('\\').append(Integer.toHexString(cp));
                        if (cp < 1048575 && ParseHelper.needsSpace(text, newIdx, len)) {
                            buf.append(' ');
                        }
                    }
                    i = newIdx;
                    continue;
                }
                if (cp <= 31 || cp == 32) {
                    if (noesc) {
                        noesc = false;
                        buf = new StringBuilder(len + 24);
                        buf.append(text.subSequence(0, i));
                    }
                    if (cp != 32) {
                        buf.append('\\').append(Integer.toHexString(cp)).append(' ');
                    } else {
                        buf.append('\\').append(' ');
                    }
                } else if (cp == 92 && i != len - 1 && ParseHelper.isPrivateOrUnassignedEscape(text, i + 1)) {
                    if (!noesc) {
                        buf.append('\\');
                    }
                } else {
                    if (noesc) {
                        noesc = false;
                        buf = new StringBuilder(len + 24);
                        buf.append(text.subSequence(0, i));
                    }
                    buf.append('\\').append((char)cp);
                }
            }
            ++i;
        }
        if (noesc) {
            return text;
        }
        return buf.toString();
    }

    private static boolean isPrivateOrUnassignedEscape(String text, int idx) {
        char c = text.charAt(idx);
        if (!ParseHelper.isHexCodePoint(c)) {
            return false;
        }
        int endIdx = text.length();
        endIdx = Math.min(endIdx, idx + 6);
        for (int i = idx + 1; i < endIdx; ++i) {
            c = text.charAt(i);
            if (ParseHelper.isHexCodePoint(c)) continue;
            if (c == ' ') {
                int cp = Integer.parseInt(text.substring(idx, i), 16);
                return ParseHelper.isPrivateOrUnassignedCodePoint(cp);
            }
            return false;
        }
        int cp = Integer.parseInt(text.substring(idx, endIdx), 16);
        return ParseHelper.isPrivateOrUnassignedCodePoint(cp);
    }

    private static boolean isPrivateOrUnassignedCodePoint(int cp) {
        int type = Character.getType(cp);
        return type == 0 || type == 18;
    }

    public static String escapeString(String text, char quoteChar) {
        return ParseHelper.escapeString(text, quoteChar, false);
    }

    public static String escapeString(String text, char quoteChar, boolean endOfString) {
        int len = text.length();
        if (len == 0) {
            return text;
        }
        int i = 0;
        StringBuilder buf = null;
        boolean noesc = true;
        while (i < len) {
            int cp = text.codePointAt(i);
            int type = Character.getType(cp);
            if (type == 15 || type == 16 || cp >= 10240 && (type == 24 || type == 28)) {
                if (noesc) {
                    noesc = false;
                    buf = new StringBuilder(len + 16);
                    buf.append(text.subSequence(0, i));
                }
                buf.append('\\').append(Integer.toHexString(cp));
                i = text.offsetByCodePoints(i, 1);
                if (endOfString && i == len) continue;
                buf.append(' ');
                continue;
            }
            if (cp == 92) {
                if (i != len - 1 && ParseHelper.isPrivateOrUnassignedEscape(text, i + 1)) {
                    if (!noesc) {
                        buf.append('\\');
                    }
                } else {
                    if (noesc) {
                        noesc = false;
                        buf = new StringBuilder(len + 16);
                        buf.append(text.subSequence(0, i));
                    }
                    buf.append("\\\\");
                }
            } else if (cp == quoteChar) {
                if (noesc) {
                    noesc = false;
                    buf = new StringBuilder(len + 16);
                    buf.append(text.subSequence(0, i));
                }
                buf.append('\\').append(quoteChar);
            } else {
                int newIdx = text.offsetByCodePoints(i, 1);
                if (newIdx == ++i) {
                    if (noesc) continue;
                    buf.append((char)cp);
                    continue;
                }
                if (!noesc) {
                    buf.appendCodePoint(cp);
                }
                i = newIdx;
                continue;
            }
            ++i;
        }
        if (noesc) {
            return text;
        }
        return buf.toString();
    }

    public static String quote(String text, char quote) {
        boolean hasSingleQuotes;
        int len = text.length();
        boolean useDQ = true;
        boolean hasDoubleQuotes = text.indexOf(34) != -1;
        boolean bl = hasSingleQuotes = text.indexOf(39) != -1;
        if (hasSingleQuotes) {
            if (hasDoubleQuotes) {
                int sqc = 0;
                int dqc = 0;
                for (int i = 0; i < len; ++i) {
                    char c = text.charAt(i);
                    if (c == '\'') {
                        ++sqc;
                        continue;
                    }
                    if (c != '\"') continue;
                    ++dqc;
                }
                if (sqc > dqc) {
                    quote = (char)34;
                } else {
                    quote = (char)39;
                    useDQ = false;
                }
                StringBuilder buf = new StringBuilder(len + 8);
                for (int i = 0; i < len; ++i) {
                    char c = text.charAt(i);
                    if (c == quote) {
                        buf.append('\\');
                    }
                    buf.append(c);
                }
                text = buf.toString();
            }
        } else if (hasDoubleQuotes) {
            useDQ = false;
        }
        StringBuilder buf = new StringBuilder(len + 2);
        if (hasSingleQuotes || hasDoubleQuotes) {
            if (useDQ) {
                buf.append('\"');
                ParseHelper.appendAndEscape(buf, text, len);
                buf.append('\"');
            } else {
                buf.append('\'');
                ParseHelper.appendAndEscape(buf, text, len);
                buf.append('\'');
            }
        } else {
            buf.append(quote);
            ParseHelper.appendAndEscape(buf, text, len);
            buf.append(quote);
        }
        return buf.toString();
    }

    private static void appendAndEscape(StringBuilder buf, String css, int len) {
        boolean escapeLast = false;
        if (len != 0 && css.charAt(len - 1) == '\\') {
            int count = 1;
            for (int i = len - 2; i >= 0 && css.charAt(i) == '\\'; --i) {
                ++count;
            }
            escapeLast = !(count & true);
        }
        buf.append(css);
        if (escapeLast) {
            buf.append('\\');
        }
    }

    public static CharSequence escapeCssChars(CharSequence strval) {
        int len = strval.length();
        if (len == 0) {
            return strval;
        }
        return ParseHelper.escapeCssChars(strval, 0, null);
    }

    public static CharSequence escapeCssCharsAndFirstChar(CharSequence strval) {
        StringBuilder buf;
        boolean noesc;
        int len = strval.length();
        if (len == 0) {
            return strval;
        }
        int i = 0;
        char cp = strval.charAt(0);
        boolean bl = noesc = cp < '0' || cp > '9';
        if (noesc) {
            buf = null;
        } else {
            buf = new StringBuilder(len + 24);
            if (i == 1) {
                buf.append(strval.charAt(0));
            }
            buf.append("\\3").append(cp).append(' ');
            ++i;
        }
        return ParseHelper.escapeCssChars(strval, i, buf);
    }

    private static CharSequence escapeCssChars(CharSequence strval, int startIndex, StringBuilder buf) {
        char c;
        boolean noesc;
        int len = strval.length();
        boolean bl = noesc = buf == null;
        if (startIndex == 0 && (c = strval.charAt(0)) == '-') {
            if (len == 1) {
                return "-";
            }
            c = strval.charAt(1);
            if (c >= '0' && c <= '9') {
                if (noesc) {
                    noesc = false;
                    buf = new StringBuilder(len + 20);
                }
                buf.append("\\-").append(c);
                startIndex = 2;
            } else {
                startIndex = 1;
            }
        }
        for (int i = startIndex; i < len; ++i) {
            char cp = strval.charAt(i);
            if (cp >= '!' && cp <= ')' || cp == '*' || cp == '+' || cp == ',' || cp == '.' || cp == '/' || cp >= ':' && cp <= '?' || cp == '@' || cp == '[' || cp == ']' || cp == '^' || cp == '`' || cp >= '{' && cp <= '~') {
                if (noesc) {
                    noesc = false;
                    buf = new StringBuilder(len + 20);
                    buf.append(strval.subSequence(0, i));
                }
                buf.append('\\').append(cp);
                continue;
            }
            if (noesc) continue;
            buf.append(cp);
        }
        if (noesc) {
            return strval;
        }
        return buf;
    }

    public static CharSequence escapeAllBackslash(CharSequence strval) {
        boolean noesc = true;
        int lenm1 = strval.length() - 1;
        StringBuilder buf = null;
        for (int i = 0; i <= lenm1; ++i) {
            char cp = strval.charAt(i);
            if (cp == '\\') {
                if (noesc) {
                    noesc = false;
                    buf = new StringBuilder(lenm1 + 6);
                    buf.append(strval.subSequence(0, i));
                }
                buf.append('\\').append('\\');
                continue;
            }
            if (noesc) continue;
            buf.append(cp);
        }
        if (noesc) {
            return strval;
        }
        return buf;
    }

    public static CharSequence escapeBackslash(CharSequence strval) {
        boolean noesc = true;
        int lenm1 = strval.length() - 1;
        StringBuilder buf = null;
        for (int i = 0; i <= lenm1; ++i) {
            char cp = strval.charAt(i);
            if (cp == '\\') {
                if (noesc) {
                    noesc = false;
                    buf = ParseHelper.createBuffer(i, strval, lenm1 + 12);
                }
                buf.append('\\');
                if (i < lenm1) {
                    cp = strval.charAt(i + 1);
                    if (ParseHelper.isHexCodePoint(cp)) continue;
                    if (cp == '\\') {
                        ++i;
                    }
                }
                buf.append('\\');
                continue;
            }
            if (noesc) continue;
            buf.append(cp);
        }
        if (noesc) {
            return strval;
        }
        return buf;
    }

    private static StringBuilder createBuffer(int i, CharSequence seq, int size) {
        StringBuilder buf = new StringBuilder(size);
        buf.append(seq.subSequence(0, i));
        return buf;
    }

    public static String escapeControl(CharSequence strval) {
        boolean noctrl = true;
        int len = strval.length();
        StringBuilder buf = null;
        for (int i = 0; i < len; ++i) {
            char cp = strval.charAt(i);
            if (Character.isISOControl(cp)) {
                if (noctrl) {
                    noctrl = false;
                    buf = new StringBuilder(len + 20);
                    buf.append(strval.subSequence(0, i));
                }
                buf.append('\\').append(Integer.toHexString(cp)).append(' ');
                continue;
            }
            if (noctrl) continue;
            buf.append(cp);
        }
        if (noctrl) {
            return strval.toString();
        }
        return buf.toString();
    }

    public static String parseIdent(String ident) throws DOMException {
        int len = (ident = ident.trim()).length();
        if (len == 0) {
            throw new DOMException(2, "Empty string is no identifier");
        }
        char c = ident.charAt(0);
        if (!ParseHelper.isNameStartCharOrEsc(c) && c != '-') {
            throw new DOMCharacterException("Identifier cannot start with U+" + Integer.toHexString(c), 0);
        }
        if (c == '-' && (len == 1 || ParseHelper.isDigitCodepoint(ident.charAt(1)))) {
            throw new DOMSyntaxException("Invalid identifier");
        }
        int prev = 32;
        for (int i = 1; i < len; ++i) {
            c = ident.charAt(i);
            if (!(ParseHelper.isNameCharOrEsc(c) || c == ' ' && ParseHelper.isHexCodePoint(prev))) {
                String msg = Character.isLetterOrDigit(c) ? "Identifier cannot contain '" + c + "'" : "Identifier cannot contain U+" + Integer.toHexString(c);
                throw new DOMCharacterException(msg, i);
            }
            prev = c;
        }
        return ParseHelper.unescapeStringValue(ident);
    }

    private static boolean isNameStartCharOrEsc(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '\u0080' || c == '\\' || c == '_';
    }

    private static boolean isNameCharOrEsc(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= '\u0080' || c == '_' || c == '-' || c == '\\';
    }

    private static boolean isDigitCodepoint(char cp) {
        return cp >= '0' && cp <= '9';
    }

    private static boolean isASCIILetterOrDigitCodePoint(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    static boolean isHexCodePoint(int codePoint) {
        return codePoint >= 48 && codePoint <= 57 || codePoint >= 65 && codePoint <= 70 || codePoint >= 97 && codePoint <= 102;
    }

    static boolean isValidXMLNonAlphaCharacter(int cp) {
        return cp == 45 || cp == 46 || cp == 183 || ParseHelper.isValidXMLStartNonAlphaCharacter(cp);
    }

    static boolean isValidXMLStartNonAlphaCharacter(int cp) {
        return cp == 95 || cp >= 192 && cp <= 214 || cp >= 216 && cp <= 246 || cp >= 248 && cp <= 767 || cp >= 880 && cp <= 893 || cp >= 895 && cp <= 8191 || cp >= 8204 && cp <= 8205 || cp >= 8304 && cp <= 8591 || cp >= 11264 && cp <= 12271 || cp >= 12289 && cp <= 57343 || cp >= 63744 && cp <= 64975 || cp >= 65008 && cp <= 65533 || cp >= 65536 && cp <= 983039;
    }

    public static boolean equalSelectorList(SelectorList list1, SelectorList list2) {
        int len;
        if (list1 == null) {
            return list2 == null;
        }
        if (list2 != null && (len = list1.getLength()) == list2.getLength()) {
            for (int i = 0; i < len; ++i) {
                if (list1.item(i).equals(list2.item(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(CharSequence seq, CharSequence lcString) {
        int seqLen = seq.length();
        int len = lcString.length();
        if (len > seqLen) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char lc;
            char c = seq.charAt(i);
            if (c == (lc = lcString.charAt(i)) || !Character.isLowerCase(c) && Character.toLowerCase(c) == lc) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(CharSequence seq, CharSequence lcString) {
        int len;
        int seqLen = seq.length();
        int minidx = seqLen - (len = lcString.length());
        if (minidx < 0) {
            return false;
        }
        for (int i = len - 1; i >= 0; --i) {
            char lc;
            char c = seq.charAt(i + minidx);
            if (c == (lc = lcString.charAt(i)) || Character.toLowerCase(c) == lc) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(CharSequence seq, CharSequence lcString) {
        int len = seq.length();
        if (lcString.length() != len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char lc;
            char c = seq.charAt(i);
            if (c == (lc = lcString.charAt(i)) || !Character.isLowerCase(c) && Character.toLowerCase(c) == lc) continue;
            return false;
        }
        return true;
    }

    public static PseudoCondition createPseudoElementCondition(String pseudoElement) {
        if (pseudoElement == null) {
            throw new NullPointerException("Null pseudo-element");
        }
        PseudoConditionImpl cond = new PseudoConditionImpl(Condition.ConditionType.PSEUDO_ELEMENT);
        cond.name = pseudoElement;
        return cond;
    }

    public static LexicalUnit createRealLexicalUnit(float value) {
        LexicalUnitImpl lu = new LexicalUnitImpl(LexicalUnit.LexicalType.REAL);
        lu.floatValue = value;
        lu.setCssUnit((short)0);
        return lu;
    }

    public static LexicalUnit createPercentageLexicalUnit(float value) {
        LexicalUnitImpl lu = new LexicalUnitImpl(LexicalUnit.LexicalType.PERCENTAGE);
        lu.floatValue = value;
        lu.setCssUnit((short)2);
        lu.dimensionUnitText = "%";
        return lu;
    }

    public static LexicalUnit createDimensionLexicalUnit(short unit, float value) throws IllegalArgumentException {
        if (unit == 255) {
            throw new IllegalArgumentException("Invalid unit.");
        }
        LexicalUnitImpl lu = new LexicalUnitImpl(LexicalUnit.LexicalType.DIMENSION);
        lu.floatValue = value;
        lu.setCssUnit(unit);
        lu.dimensionUnitText = CSSUnit.dimensionUnitString(unit);
        return lu;
    }
}

