/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.initialization.transform.InstrumentationArtifactMetadata;
import org.gradle.api.internal.initialization.transform.InstrumentationDependencyAnalysis;
import org.gradle.api.internal.initialization.transform.services.CacheInstrumentationDataBuildService;
import org.gradle.api.internal.initialization.transform.services.InjectedInstrumentationServices;
import org.gradle.api.internal.initialization.transform.utils.ClassAnalysisUtils;
import org.gradle.api.internal.initialization.transform.utils.InstrumentationAnalysisSerializer;
import org.gradle.api.internal.initialization.transform.utils.InstrumentationTransformUtils;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.classpath.transforms.MrJarUtils;
import org.gradle.internal.file.FileException;
import org.gradle.internal.lazy.Lazy;
import org.gradle.work.DisableCachingByDefault;
import org.objectweb.asm.ClassReader;

@DisableCachingByDefault(because="Not worth caching.")
public abstract class InstrumentationAnalysisTransform
implements TransformAction<Parameters> {
    private final Lazy<InjectedInstrumentationServices> internalServices = Lazy.unsafe().of(() -> (InjectedInstrumentationServices)this.getObjects().newInstance(InjectedInstrumentationServices.class, new Object[0]));

    private static boolean isTypeAccepted(String type) {
        return type != null && !type.startsWith("java/lang/");
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    public abstract Provider<FileSystemLocation> getInput();

    public void transform(TransformOutputs outputs) {
        File artifact = ((FileSystemLocation)this.getInput().get()).getAsFile();
        if (!artifact.exists()) {
            return;
        }
        try {
            TreeMap<String, Set<String>> superTypes = new TreeMap<String, Set<String>>();
            TreeSet<String> dependencies = new TreeSet<String>();
            this.analyzeArtifact(artifact, superTypes, dependencies);
            this.writeOutput(artifact, outputs, superTypes, dependencies);
        }
        catch (IOException | FileException ignored) {
            this.writeOutput(artifact, outputs, Collections.emptyMap(), Collections.emptySet());
        }
    }

    private void analyzeArtifact(File artifact, Map<String, Set<String>> superTypesCollector, Set<String> dependenciesCollector) throws IOException {
        ClasspathWalker walker = ((InjectedInstrumentationServices)this.internalServices.get()).getClasspathWalker();
        walker.visit(artifact, entry -> {
            if (entry.getName().endsWith(".class") && !MrJarUtils.isInUnsupportedMrJarVersionedDirectory(entry)) {
                ClassReader reader = new ClassReader(entry.getContent());
                String className = reader.getClassName();
                Set<String> classSuperTypes = InstrumentationAnalysisTransform.collectSuperTypes(reader);
                InstrumentationAnalysisTransform.collectArtifactClassDependencies(className, reader, dependenciesCollector);
                if (!classSuperTypes.isEmpty()) {
                    superTypesCollector.put(className, classSuperTypes);
                }
            }
        });
    }

    private static Set<String> collectSuperTypes(ClassReader reader) {
        return (Set)Stream.concat(Stream.of(reader.getSuperName()), Stream.of(reader.getInterfaces())).filter(InstrumentationAnalysisTransform::isTypeAccepted).collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)Ordering.natural()));
    }

    private static void collectArtifactClassDependencies(String className, ClassReader reader, Set<String> collector) {
        ClassAnalysisUtils.getClassDependencies(reader, dependencyDescriptor -> {
            if (!dependencyDescriptor.equals(className) && InstrumentationAnalysisTransform.isTypeAccepted(dependencyDescriptor)) {
                collector.add((String)dependencyDescriptor);
            }
        });
    }

    private void writeOutput(File artifact, TransformOutputs outputs, Map<String, Set<String>> superTypes, Set<String> dependencies) {
        InstrumentationAnalysisSerializer serializer = ((CacheInstrumentationDataBuildService)((Parameters)this.getParameters()).getBuildService().get()).getCachedInstrumentationAnalysisSerializer();
        InstrumentationTransformUtils.createInstrumentationClasspathMarker(outputs);
        File typeHierarchyAnalysisFile = outputs.file((Object)"analysis/instrumentation-hierarchy.bin");
        serializer.writeTypeHierarchyAnalysis(typeHierarchyAnalysisFile, superTypes);
        File dependencyAnalysisFile = outputs.file((Object)"analysis/instrumentation-dependencies.bin");
        InstrumentationArtifactMetadata metadata = this.getArtifactMetadata(artifact);
        serializer.writeDependencyAnalysis(dependencyAnalysisFile, new InstrumentationDependencyAnalysis(metadata, InstrumentationAnalysisTransform.toMapWithKeys(dependencies)));
        InstrumentationTransformUtils.outputOriginalArtifact(outputs, artifact);
    }

    private InstrumentationArtifactMetadata getArtifactMetadata(File artifact) {
        long contextId = (Long)((Parameters)this.getParameters()).getContextId().get();
        CacheInstrumentationDataBuildService buildService = (CacheInstrumentationDataBuildService)((Parameters)this.getParameters()).getBuildService().get();
        String hash = (String)Preconditions.checkNotNull((Object)buildService.getArtifactHash(contextId, artifact), (String)"Hash for artifact '%s' is null, that indicates that artifact doesn't exist!", (Object)artifact);
        return new InstrumentationArtifactMetadata(artifact.getName(), hash);
    }

    private static Map<String, Set<String>> toMapWithKeys(Set<String> keys) {
        TreeMap<String, Set<String>> map = new TreeMap<String, Set<String>>();
        keys.forEach(key -> map.put((String)key, Collections.emptySet()));
        return map;
    }

    public static interface Parameters
    extends TransformParameters {
        @Internal
        public Property<CacheInstrumentationDataBuildService> getBuildService();

        @Internal
        public Property<Long> getContextId();
    }
}

