/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProfile;
import org.jetbrains.idea.maven.dom.model.MavenDomProfiles;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomSettingsModel;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.navigator.structure.ProfilesNode;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenSettingsCache;
import org.jetbrains.idea.maven.utils.MavenUtil;

class ProfileNode
extends MavenSimpleNode {
    private final String myProfileName;
    private MavenProfileKind myState;

    ProfileNode(MavenProjectsStructure structure, ProfilesNode parent, String profileName) {
        super(structure, parent);
        this.myProfileName = profileName;
    }

    public String getName() {
        return this.myProfileName;
    }

    public String getProfileName() {
        return this.myProfileName;
    }

    public MavenProfileKind getState() {
        return this.myState;
    }

    void setState(MavenProfileKind state) {
        this.myState = state;
    }

    @Override
    @Nullable
    @NonNls
    protected String getActionId() {
        return "Maven.ToggleProfile";
    }

    @Override
    @Nullable
    @NonNls
    String getMenuId() {
        return "Maven.ProfileMenu";
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        if (this.myProject == null) {
            return null;
        }
        ArrayList<MavenDomProfile> profiles2 = new ArrayList<MavenDomProfile>();
        for (VirtualFile virtualFile : MavenSettingsCache.getInstance(this.myProject).getEffectiveVirtualSettingsFiles()) {
            MavenDomSettingsModel model = MavenDomUtil.getMavenDomModel(this.myProject, virtualFile, MavenDomSettingsModel.class);
            if (model == null) continue;
            this.addProfiles(profiles2, model.getProfiles().getProfiles());
        }
        for (MavenProject mavenProject : this.myMavenProjectsStructure.getProjectsManager().getProjects()) {
            MavenDomProjectModel projectModel;
            MavenDomProfiles profilesModel;
            VirtualFile mavenProjectFile = mavenProject.getFile();
            VirtualFile profilesXmlFile = MavenUtil.findProfilesXmlFile(mavenProjectFile);
            if (profilesXmlFile != null && (profilesModel = MavenDomUtil.getMavenDomProfilesModel(this.myProject, profilesXmlFile)) != null) {
                this.addProfiles(profiles2, profilesModel.getProfiles());
            }
            if ((projectModel = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProjectFile)) == null) continue;
            this.addProfiles(profiles2, projectModel.getProfiles().getProfiles());
        }
        return ProfileNode.getNavigatable(profiles2);
    }

    private static Navigatable getNavigatable(@NotNull List<MavenDomProfile> profiles2) {
        if (profiles2 == null) {
            ProfileNode.$$$reportNull$$$0(0);
        }
        if (profiles2.size() > 1) {
            final ArrayList<ProfileWithName> profileUrls = new ArrayList<ProfileWithName>();
            for (MavenDomProfile profile : profiles2) {
                XmlElement element = profile.getXmlElement();
                if (null == element) continue;
                profileUrls.add(new ProfileWithName(profile, ProfileNode.getPresentableUrl(element)));
            }
            return new NavigatableAdapter(){

                public void navigate(boolean requestFocus) {
                    JBPopupFactory.getInstance().createPopupChooserBuilder((List)profileUrls).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                        @Override
                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            Component result2 = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                            this.setText(((ProfileWithName)value).name);
                            return result2;
                        }
                    }).setTitle(MavenProjectBundle.message("maven.notification.choose.file.to.open", new Object[0])).setItemChosenCallback(value -> {
                        Navigatable navigatable = ProfileNode.getNavigatable(value.profile);
                        if (navigatable != null) {
                            navigatable.navigate(requestFocus);
                        }
                    }).createPopup().showInFocusCenter();
                }
            };
        }
        return ProfileNode.getNavigatable((MavenDomProfile)ContainerUtil.getFirstItem(profiles2));
    }

    @NlsSafe
    @NotNull
    private static String getPresentableUrl(@NotNull XmlElement xmlElement) {
        if (xmlElement == null) {
            ProfileNode.$$$reportNull$$$0(1);
        }
        String string = (String)ReadAction.nonBlocking(() -> xmlElement.getContainingFile().getVirtualFile().getPresentableUrl()).executeSynchronously();
        if (string == null) {
            ProfileNode.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private static Navigatable getNavigatable(@Nullable MavenDomProfile profile) {
        if (profile == null) {
            return null;
        }
        XmlElement xmlElement = profile.getId().getXmlElement();
        return xmlElement instanceof Navigatable ? (Navigatable)xmlElement : null;
    }

    private void addProfiles(@NotNull List<MavenDomProfile> result2, @Nullable List<MavenDomProfile> profilesToAdd) {
        if (result2 == null) {
            ProfileNode.$$$reportNull$$$0(3);
        }
        if (profilesToAdd == null) {
            return;
        }
        for (MavenDomProfile profile : profilesToAdd) {
            if (!StringUtil.equals((CharSequence)((CharSequence)profile.getId().getValue()), (CharSequence)this.myProfileName)) continue;
            result2.add(profile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/navigator/structure/ProfileNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/navigator/structure/ProfileNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableUrl";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addProfiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private record ProfileWithName(MavenDomProfile profile, String name) {
    }
}

