/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.cygwin;

import com.pty4j.windows.winpty.NamedPipe;
import java.io.IOException;
import java.io.InputStream;

public class CygwinPTYInputStream
extends InputStream {
    private final NamedPipe myNamedPipe;
    private boolean myClosed;

    public CygwinPTYInputStream(NamedPipe namedPipe) {
        this.myNamedPipe = namedPipe;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (1 != this.read(b, 0, 1)) {
            return -1;
        }
        return b[0];
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.myClosed) {
            return 0;
        }
        return this.myNamedPipe.read(buf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.myClosed = true;
        this.myNamedPipe.markClosed();
    }

    @Override
    public int available() throws IOException {
        return this.myNamedPipe.available();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

