/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava;

import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.framework.KotlinSdkType;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\"\u001a\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f"}, d2={"pathAsUrl", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/externalSystem/model/project/ContentRootData$SourceRoot;", "getPathAsUrl", "(Lcom/intellij/openapi/externalSystem/model/project/ContentRootData$SourceRoot;)Ljava/lang/String;", "migrateNonJvmSourceFolders", "", "modifiableRootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "kotlin.gradle.gradle-java"})
@JvmName(name="KotlinGradleJavaUtils")
public final class KotlinGradleJavaUtils {
    @ApiStatus.Internal
    @NotNull
    public static final String getPathAsUrl(@NotNull ContentRootData.SourceRoot $this$pathAsUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$pathAsUrl, (String)"<this>");
        String string = VirtualFileManager.constructUrl((String)"file", (String)FileUtil.toSystemIndependentName((String)$this$pathAsUrl.getPath()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructUrl(...)");
        return string;
    }

    @ApiStatus.Internal
    public static final void migrateNonJvmSourceFolders(@NotNull ModifiableRootModel modifiableRootModel, @NotNull ProjectModelExternalSource externalSource) {
        Intrinsics.checkNotNullParameter((Object)modifiableRootModel, (String)"modifiableRootModel");
        Intrinsics.checkNotNullParameter((Object)externalSource, (String)"externalSource");
        for (ContentEntry contentEntry : modifiableRootModel.getContentEntries()) {
            for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                String url;
                Pair<JpsModuleSourceRootType<JpsElement>, JpsElement> pair;
                JpsModuleSourceRoot jpsModuleSourceRoot = sourceFolder.getJpsElement();
                Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRoot, (String)"getJpsElement(...)");
                if (KotlinProjectStructureUtils.getMigratedSourceRootTypeWithProperties(jpsModuleSourceRoot) == null) continue;
                JpsModuleSourceRootType newSourceRootType = (JpsModuleSourceRootType)pair.component1();
                JpsElement properties = (JpsElement)pair.component2();
                Intrinsics.checkNotNullExpressionValue((Object)sourceFolder.getUrl(), (String)"getUrl(...)");
                contentEntry.removeSourceFolder(sourceFolder);
                contentEntry.addSourceFolder(url, newSourceRootType, properties, externalSource);
            }
        }
        KotlinSdkType.Companion.setUpIfNeeded$default(KotlinSdkType.Companion, null, null, 3, null);
    }
}

