/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.accessor;

import com.intellij.ide.vfs.VirtualFileId;
import com.intellij.ide.vfs.VirtualFileIdKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.UriUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.dto.MarkdownHeaderInfo;
import org.intellij.plugins.markdown.lang.index.HeaderAnchorIndex;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.mapper.MarkdownHeaderMapper;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreview;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\u0013J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/accessor/MarkdownLinkOpenerUtil;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "navigateToHeader", "", "project", "Lcom/intellij/openapi/project/Project;", "headerInfo", "Lorg/intellij/plugins/markdown/dto/MarkdownHeaderInfo;", "collectHeaders", "", "anchor", "", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findVirtualFile", "Ljava/net/URI;", "createFileUri", "link", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownLinkOpenerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownLinkOpenerUtil.kt\norg/intellij/plugins/markdown/ui/preview/accessor/MarkdownLinkOpenerUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n808#2,11:80\n1563#2:91\n1634#2,3:92\n14#3:95\n*S KotlinDebug\n*F\n+ 1 MarkdownLinkOpenerUtil.kt\norg/intellij/plugins/markdown/ui/preview/accessor/MarkdownLinkOpenerUtil\n*L\n36#1:80,11\n56#1:91\n56#1:92,3\n29#1:95\n*E\n"})
public final class MarkdownLinkOpenerUtil {
    @NotNull
    public static final MarkdownLinkOpenerUtil INSTANCE = new MarkdownLinkOpenerUtil();
    @NotNull
    private static final Logger logger;

    private MarkdownLinkOpenerUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public final void navigateToHeader(@NotNull Project project, @NotNull MarkdownHeaderInfo headerInfo) {
        MarkdownPreviewFileEditor markdownPreviewFileEditor;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)headerInfo, (String)"headerInfo");
        if (this.createFileUri(headerInfo.getFilePath()) == null) {
            return;
        }
        VirtualFile virtualFile = VirtualFileIdKt.virtualFile((VirtualFileId)headerInfo.getVirtualFileId());
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        PsiElement psiElement = PsiUtilCore.getPsiFile((Project)project, (VirtualFile)file).findElementAt(headerInfo.getTextOffset());
        if (psiElement == null) {
            return;
        }
        PsiElement element2 = psiElement;
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        List list2 = manager.getEditorList(file);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEditorList(...)");
        Iterable $this$filterIsInstance$iv = list2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MarkdownEditorWithPreview)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        MarkdownEditorWithPreview openedEditor = (MarkdownEditorWithPreview)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
        if (openedEditor == null) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, element2.getTextOffset());
            manager.openEditor(descriptor, true);
            return;
        }
        PsiNavigateUtil.navigate((PsiElement)element2, (boolean)true);
        FileEditor fileEditor = openedEditor.getPreviewEditor();
        MarkdownPreviewFileEditor markdownPreviewFileEditor2 = markdownPreviewFileEditor = fileEditor instanceof MarkdownPreviewFileEditor ? (MarkdownPreviewFileEditor)fileEditor : null;
        if (markdownPreviewFileEditor != null) {
            markdownPreviewFileEditor.scrollToLine(openedEditor.getEditor(), headerInfo.getLineNumber());
        }
    }

    @Nullable
    public final List<MarkdownHeaderInfo> collectHeaders(@NotNull Project project, @NotNull String anchor, @NotNull VirtualFile targetFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        return (List)ActionsKt.runReadAction(() -> MarkdownLinkOpenerUtil.collectHeaders$lambda$0(project, targetFile, anchor));
    }

    @Nullable
    public final VirtualFile findVirtualFile(@NotNull URI $this$findVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$findVirtualFile, (String)"<this>");
        String actualPath = SystemInfo.isWindows ? UriUtil.trimLeadingSlashes((String)$this$findVirtualFile.getPath()) : $this$findVirtualFile.getPath();
        Path path = Path.of(actualPath, new String[0]);
        return VfsUtil.findFile((Path)path, (boolean)true);
    }

    private final URI createFileUri(String link) {
        try {
            return new URI("file", null, link, null);
        }
        catch (URISyntaxException exception) {
            logger.warn((Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List collectHeaders$lambda$0(Project $project, VirtualFile $targetFile, String $anchor) {
        void $this$mapTo$iv$iv;
        if (DumbService.Companion.isDumb($project)) {
            return CollectionsKt.emptyList();
        }
        PsiFile file = PsiManager.getInstance((Project)$project).findFile($targetFile);
        GlobalSearchScope scope = file == null ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScope.fileScope((PsiFile)file);
        Intrinsics.checkNotNull((Object)scope);
        Iterable $this$map$iv = HeaderAnchorIndex.Companion.collectHeaders($project, scope, $anchor);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            MarkdownHeader markdownHeader = (MarkdownHeader)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MarkdownHeaderMapper.map((MarkdownHeader)p0));
        }
        return (List)destination$iv$iv;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MarkdownLinkOpenerUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MarkdownLinkOpenerUtil.logger = logger;
    }
}

