/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.diagnostic;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationContextInFile;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.TypeUtilKt$bodyPropertiesDescriptorsMap$;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.NamingConventionsKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SearchUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationAnnotations;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationPackages;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializersClassIds;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0005*\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0002\u001a(\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0001\u001a\u001e\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001b0\u0013*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u001c"}, d2={"isGeneratedSerializableObject", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "serialName", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "analyzeSpecialSerializers", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "findTypeSerializerOrContextUnchecked", "Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/SerializationContextInFile;", "module", "kType", "findTypeSerializer", "findStandardKotlinTypeSerializer", "findEnumTypeSerializer", "bodyPropertiesDescriptorsMap", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "filterUninitialized", "primaryConstructorPropertiesDescriptorsMap", "Lorg/jetbrains/kotlin/psi/KtParameter;", "kotlinx-serialization-compiler-plugin.k1"})
@SourceDebugExtension(value={"SMAP\nTypeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeUtil.kt\norg/jetbrains/kotlinx/serialization/compiler/diagnostic/TypeUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,123:1\n1#2:124\n477#3:125\n682#3:126\n712#3,4:127\n682#3:131\n712#3,4:132\n*S KotlinDebug\n*F\n+ 1 TypeUtil.kt\norg/jetbrains/kotlinx/serialization/compiler/diagnostic/TypeUtilKt\n*L\n113#1:125\n116#1:126\n116#1:127,4\n122#1:131\n122#1:132,4\n*E\n"})
public final class TypeUtilKt {
    public static final boolean isGeneratedSerializableObject(@NotNull KotlinType $this$isGeneratedSerializableObject) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isGeneratedSerializableObject, (String)"<this>");
        ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor($this$isGeneratedSerializableObject);
        if (classDescriptor != null) {
            ClassDescriptor $this$isGeneratedSerializableObject_u24lambda_u240 = classDescriptor;
            boolean bl2 = false;
            bl = $this$isGeneratedSerializableObject_u24lambda_u240.getKind() == ClassKind.OBJECT && KSerializationUtilKt.getHasSerializableOrMetaAnnotationWithoutArgs($this$isGeneratedSerializableObject_u24lambda_u240);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final String serialName(@NotNull KotlinType $this$serialName) {
        Intrinsics.checkNotNullParameter((Object)$this$serialName, (String)"<this>");
        ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor($this$serialName);
        Intrinsics.checkNotNull((Object)classDescriptor);
        ClassDescriptor serializableDescriptor = classDescriptor;
        return TypeUtilKt.serialName(serializableDescriptor);
    }

    @NotNull
    public static final String serialName(@NotNull ClassDescriptor $this$serialName) {
        Intrinsics.checkNotNullParameter((Object)$this$serialName, (String)"<this>");
        String string = KSerializationUtilKt.getSerialNameValue($this$serialName.getAnnotations());
        if (string == null) {
            string = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)$this$serialName)).asString();
        }
        return string;
    }

    @Nullable
    public static final ClassDescriptor analyzeSpecialSerializers(@NotNull ModuleDescriptor moduleDescriptor, @NotNull Annotations annotations) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        return annotations.hasAnnotation(SerializationAnnotations.INSTANCE.getContextualFqName()) || annotations.hasAnnotation(SerializationAnnotations.INSTANCE.getContextualOnPropertyFqName()) ? SearchUtilsKt.getClassFromSerializationPackage(moduleDescriptor, "ContextualSerializer") : (annotations.hasAnnotation(SerializationAnnotations.INSTANCE.getPolymorphicFqName()) ? SearchUtilsKt.getClassFromSerializationPackage(moduleDescriptor, "PolymorphicSerializer") : null);
    }

    @Nullable
    public static final ClassDescriptor findTypeSerializerOrContextUnchecked(@NotNull SerializationContextInFile $this$findTypeSerializerOrContextUnchecked, @NotNull ModuleDescriptor module, @NotNull KotlinType kType) {
        Intrinsics.checkNotNullParameter((Object)$this$findTypeSerializerOrContextUnchecked, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        Annotations annotations = kType.getAnnotations();
        if (TypeUtilsKt.isTypeParameter((KotlinType)kType)) {
            return null;
        }
        KotlinType kotlinType = KSerializationUtilKt.serializableWith(annotations, module);
        if (kotlinType != null) {
            KotlinType it = kotlinType;
            boolean bl = false;
            return KSerializationUtilKt.toClassDescriptor(it);
        }
        kotlinType = $this$findTypeSerializerOrContextUnchecked.getAdditionalSerializersInScopeOfCurrentFile().get(TuplesKt.to((Object)KSerializationUtilKt.toClassDescriptor(kType), (Object)kType.isMarkedNullable()));
        if (kotlinType != null) {
            KotlinType it = kotlinType;
            boolean bl = false;
            return it;
        }
        if (kType.isMarkedNullable()) {
            return TypeUtilKt.findTypeSerializerOrContextUnchecked($this$findTypeSerializerOrContextUnchecked, module, TypeUtilsKt.makeNotNullable((KotlinType)kType));
        }
        if ($this$findTypeSerializerOrContextUnchecked.getContextualKClassListInCurrentFile().contains(kType)) {
            return SearchUtilsKt.getClassFromSerializationPackage(module, "ContextualSerializer");
        }
        ClassDescriptor classDescriptor = TypeUtilKt.analyzeSpecialSerializers(module, annotations);
        if (classDescriptor == null) {
            classDescriptor = TypeUtilKt.findTypeSerializer(module, kType);
        }
        return classDescriptor;
    }

    @Nullable
    public static final ClassDescriptor findTypeSerializer(@NotNull ModuleDescriptor module, @NotNull KotlinType kType) {
        ClassDescriptor stdSer;
        KotlinType userOverride;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        KotlinType kotlinType = userOverride = KSerializationUtilKt.overriddenSerializer(kType, module);
        if (kotlinType != null) {
            return KSerializationUtilKt.toClassDescriptor(kotlinType);
        }
        if (TypeUtilsKt.isTypeParameter((KotlinType)kType)) {
            return null;
        }
        if (KotlinBuiltIns.isArray((KotlinType)kType)) {
            return SearchUtilsKt.getClassFromInternalSerializationPackage(module, "ReferenceArraySerializer");
        }
        if (TypeUtilKt.isGeneratedSerializableObject(kType)) {
            return SearchUtilsKt.getClassFromInternalSerializationPackage(module, "ObjectSerializer");
        }
        ClassDescriptor classDescriptor = TypeUtilKt.findStandardKotlinTypeSerializer(module, kType);
        if (classDescriptor == null) {
            classDescriptor = TypeUtilKt.findEnumTypeSerializer(module, kType);
        }
        ClassDescriptor classDescriptor2 = stdSer = classDescriptor;
        if (classDescriptor2 != null) {
            return classDescriptor2;
        }
        if (TypeUtilsKt.isInterface((KotlinType)kType)) {
            ClassDescriptor classDescriptor3 = KSerializationUtilKt.toClassDescriptor(kType);
            boolean bl = classDescriptor3 != null ? !KSerializationUtilKt.isSealedSerializableInterface(classDescriptor3) : false;
            if (bl) {
                return SearchUtilsKt.getClassFromSerializationPackage(module, "PolymorphicSerializer");
            }
        }
        ClassDescriptor classDescriptor4 = KSerializationUtilKt.toClassDescriptor(kType);
        return classDescriptor4 != null ? KSerializationUtilKt.getClassSerializer(classDescriptor4) : null;
    }

    @Nullable
    public static final ClassDescriptor findStandardKotlinTypeSerializer(@NotNull ModuleDescriptor module, @NotNull KotlinType kType) {
        String string;
        String typeName;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        switch (typeName = org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.getKotlinTypeFqName((KotlinType)kType, (boolean)false)) {
            case "Z": {
                if (TypeUtilsKt.isBoolean((KotlinType)kType)) {
                    string = "BooleanSerializer";
                    break;
                }
                string = null;
                break;
            }
            case "B": {
                if (TypeUtilsKt.isByte((KotlinType)kType)) {
                    string = "ByteSerializer";
                    break;
                }
                string = null;
                break;
            }
            case "S": {
                if (TypeUtilsKt.isShort((KotlinType)kType)) {
                    string = "ShortSerializer";
                    break;
                }
                string = null;
                break;
            }
            case "I": {
                if (TypeUtilsKt.isInt((KotlinType)kType)) {
                    string = "IntSerializer";
                    break;
                }
                string = null;
                break;
            }
            case "J": {
                if (TypeUtilsKt.isLong((KotlinType)kType)) {
                    string = "LongSerializer";
                    break;
                }
                string = null;
                break;
            }
            case "F": {
                if (TypeUtilsKt.isFloat((KotlinType)kType)) {
                    string = "FloatSerializer";
                    break;
                }
                string = null;
                break;
            }
            case "D": {
                if (TypeUtilsKt.isDouble((KotlinType)kType)) {
                    string = "DoubleSerializer";
                    break;
                }
                string = null;
                break;
            }
            case "C": {
                if (TypeUtilsKt.isChar((KotlinType)kType)) {
                    string = "CharSerializer";
                    break;
                }
                string = null;
                break;
            }
            default: {
                string = NamingConventionsKt.findStandardKotlinTypeSerializerName(typeName);
            }
        }
        if (string == null) {
            return null;
        }
        String name = string;
        Name name2 = Name.identifier((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        Name identifier = name2;
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)module, (ClassId)new ClassId(SerializationPackages.INSTANCE.getInternalPackageFqName(), identifier));
        if (classDescriptor == null) {
            classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)module, (ClassId)new ClassId(SerializationPackages.INSTANCE.getPackageFqName(), identifier));
        }
        return classDescriptor;
    }

    @Nullable
    public static final ClassDescriptor findEnumTypeSerializer(@NotNull ModuleDescriptor module, @NotNull KotlinType kType) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor(kType);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        return classDescriptor2.getKind() == ClassKind.ENUM_CLASS && !KSerializationUtilKt.isEnumWithLegacyGeneratedSerializer(classDescriptor2) ? FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)module, (ClassId)SerializersClassIds.INSTANCE.getEnumSerializerId()) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<PropertyDescriptor, KtProperty> bodyPropertiesDescriptorsMap(@NotNull KtPureClassOrObject $this$bodyPropertiesDescriptorsMap, @NotNull BindingContext bindingContext, boolean filterUninitialized) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$bodyPropertiesDescriptorsMap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        List list = $this$bodyPropertiesDescriptorsMap.getDeclarations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDeclarations(...)");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)list);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)bodyPropertiesDescriptorsMap$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence $this$associateBy$iv = SequencesKt.filter((Sequence)sequence, arg_0 -> TypeUtilKt.bodyPropertiesDescriptorsMap$lambda$0(filterUninitialized, arg_0));
        boolean $i$f$associateBy = false;
        Sequence sequence2 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KtProperty ktProperty = (KtProperty)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Object object = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)it);
            PropertyDescriptor propertyDescriptor = object instanceof PropertyDescriptor ? (PropertyDescriptor)object : null;
            Intrinsics.checkNotNull((Object)propertyDescriptor);
            map.put(propertyDescriptor, element$iv$iv);
        }
        return destination$iv$iv;
    }

    public static /* synthetic */ Map bodyPropertiesDescriptorsMap$default(KtPureClassOrObject ktPureClassOrObject, BindingContext bindingContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return TypeUtilKt.bodyPropertiesDescriptorsMap(ktPureClassOrObject, bindingContext, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<PropertyDescriptor, KtParameter> primaryConstructorPropertiesDescriptorsMap(@NotNull KtPureClassOrObject $this$primaryConstructorPropertiesDescriptorsMap, @NotNull BindingContext bindingContext) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$primaryConstructorPropertiesDescriptorsMap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        List list = $this$primaryConstructorPropertiesDescriptorsMap.getPrimaryConstructorParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPrimaryConstructorParameters(...)");
        Sequence $this$associateBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), TypeUtilKt::primaryConstructorPropertiesDescriptorsMap$lambda$0);
        boolean $i$f$associateBy = false;
        Sequence sequence = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KtParameter ktParameter = (KtParameter)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Object object = bindingContext.get((ReadOnlySlice)BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, (Object)it);
            Intrinsics.checkNotNull((Object)object);
            map.put((PropertyDescriptor)object, element$iv$iv);
        }
        return destination$iv$iv;
    }

    private static final boolean bodyPropertiesDescriptorsMap$lambda$0(boolean $filterUninitialized, KtProperty it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $filterUninitialized ? it.getDelegateExpressionOrInitializer() != null : true;
    }

    private static final boolean primaryConstructorPropertiesDescriptorsMap$lambda$0(KtParameter it) {
        return it.hasValOrVar();
    }
}

