/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import oracle.rsi.internal.HandlerDelegator;
import oracle.rsi.internal.Metadata;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class MetadataHandler
extends DefaultHandler {
    protected XMLReader xmlReader = null;
    protected MetadataHandler parent = null;
    protected Stack<String> parents = null;
    protected HandlerDelegator delegator = new HandlerDelegator();
    protected CharArrayWriter contents = null;

    public MetadataHandler() {
        this.parents = new Stack();
        this.contents = new CharArrayWriter();
    }

    protected void createSAXParser() throws Metadata.DBMetadataException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.xmlReader = sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (Throwable throwable) {
            throw new Metadata.DBMetadataException(Metadata.DBMetadataException.CODE.GENERIC, "Unable to create SAX Parser", throwable);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.contents.reset();
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.contents.write(cArray, n, n2);
    }

    protected void setHandler(MetadataHandler metadataHandler) {
        this.delegator.setHandler(metadataHandler);
    }

    protected void parse(InputSource inputSource) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        this.xmlReader.setContentHandler(this.delegator);
        this.xmlReader.setEntityResolver(this.delegator);
        this.xmlReader.setErrorHandler(this.delegator);
        this.xmlReader.setDTDHandler(this.delegator);
        this.xmlReader.parse(inputSource);
    }
}

