/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.shard;

import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0003&'(B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010$\u001a\u00020%R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u001a\u0010\u0019\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012R\u001a\u0010\u001c\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u0012R\u001a\u0010\u001f\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0010\"\u0004\b!\u0010\u0012R\u0011\u0010\"\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0010\u00a8\u0006)"}, d2={"Lorg/opensearch/replication/task/shard/FollowerShardMetric;", "", "<init>", "()V", "followerCheckpoint", "", "getFollowerCheckpoint", "()J", "setFollowerCheckpoint", "(J)V", "leaderCheckpoint", "getLeaderCheckpoint", "setLeaderCheckpoint", "opsWritten", "Ljava/util/concurrent/atomic/AtomicLong;", "getOpsWritten", "()Ljava/util/concurrent/atomic/AtomicLong;", "setOpsWritten", "(Ljava/util/concurrent/atomic/AtomicLong;)V", "opsWriteFailures", "getOpsWriteFailures", "setOpsWriteFailures", "opsWriteThrottles", "getOpsWriteThrottles", "setOpsWriteThrottles", "opsRead", "getOpsRead", "setOpsRead", "opsReadFailures", "getOpsReadFailures", "setOpsReadFailures", "opsReadThrottles", "getOpsReadThrottles", "setOpsReadThrottles", "totalWriteTime", "getTotalWriteTime", "createStats", "Lorg/opensearch/replication/task/shard/FollowerShardMetric$FollowerStats;", "Companion", "FollowerStats", "FollowerStatsFragment", "opensearch-cross-cluster-replication"})
public final class FollowerShardMetric {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long followerCheckpoint;
    private long leaderCheckpoint;
    @NotNull
    private AtomicLong opsWritten = new AtomicLong();
    @NotNull
    private AtomicLong opsWriteFailures = new AtomicLong();
    @NotNull
    private AtomicLong opsWriteThrottles = new AtomicLong();
    @NotNull
    private AtomicLong opsRead = new AtomicLong();
    @NotNull
    private AtomicLong opsReadFailures = new AtomicLong();
    @NotNull
    private AtomicLong opsReadThrottles = new AtomicLong();
    @NotNull
    private final AtomicLong totalWriteTime = new AtomicLong();
    private static final Logger log = LogManager.getLogger(FollowerShardMetric.class);

    public final long getFollowerCheckpoint() {
        return this.followerCheckpoint;
    }

    public final void setFollowerCheckpoint(long l) {
        this.followerCheckpoint = l;
    }

    public final long getLeaderCheckpoint() {
        return this.leaderCheckpoint;
    }

    public final void setLeaderCheckpoint(long l) {
        this.leaderCheckpoint = l;
    }

    @NotNull
    public final AtomicLong getOpsWritten() {
        return this.opsWritten;
    }

    public final void setOpsWritten(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.opsWritten = atomicLong;
    }

    @NotNull
    public final AtomicLong getOpsWriteFailures() {
        return this.opsWriteFailures;
    }

    public final void setOpsWriteFailures(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.opsWriteFailures = atomicLong;
    }

    @NotNull
    public final AtomicLong getOpsWriteThrottles() {
        return this.opsWriteThrottles;
    }

    public final void setOpsWriteThrottles(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.opsWriteThrottles = atomicLong;
    }

    @NotNull
    public final AtomicLong getOpsRead() {
        return this.opsRead;
    }

    public final void setOpsRead(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.opsRead = atomicLong;
    }

    @NotNull
    public final AtomicLong getOpsReadFailures() {
        return this.opsReadFailures;
    }

    public final void setOpsReadFailures(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.opsReadFailures = atomicLong;
    }

    @NotNull
    public final AtomicLong getOpsReadThrottles() {
        return this.opsReadThrottles;
    }

    public final void setOpsReadThrottles(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.opsReadThrottles = atomicLong;
    }

    @NotNull
    public final AtomicLong getTotalWriteTime() {
        return this.totalWriteTime;
    }

    @NotNull
    public final FollowerStats createStats() {
        return new FollowerStats(this.opsWritten.get(), this.opsWriteFailures.get(), this.opsWriteThrottles.get(), this.opsRead.get(), this.opsReadFailures.get(), this.opsReadThrottles.get(), this.followerCheckpoint, this.leaderCheckpoint, this.totalWriteTime.get());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/replication/task/shard/FollowerShardMetric$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001Ba\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\f\u0010\u0010J\u001a\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0018\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\b\u0010(\u001a\u0004\u0018\u00010)J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0014R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0012\"\u0004\b\u001e\u0010\u0014R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0012\"\u0004\b\"\u0010\u0014R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0012\"\u0004\b$\u0010\u0014\u00a8\u00061"}, d2={"Lorg/opensearch/replication/task/shard/FollowerShardMetric$FollowerStats;", "Lorg/opensearch/core/xcontent/ToXContentFragment;", "opsWritten", "", "opsWriteFailures", "opsWriteThrottles", "opsRead", "opsReadFailures", "opsReadThrottles", "followerCheckpoint", "leaderCheckpoint", "totalWriteTime", "<init>", "(JJJJJJJJJ)V", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getOpsWritten", "()J", "setOpsWritten", "(J)V", "getOpsWriteFailures", "setOpsWriteFailures", "getOpsWriteThrottles", "setOpsWriteThrottles", "getOpsRead", "setOpsRead", "getOpsReadFailures", "setOpsReadFailures", "getOpsReadThrottles", "setOpsReadThrottles", "getFollowerCheckpoint", "setFollowerCheckpoint", "getLeaderCheckpoint", "setLeaderCheckpoint", "getTotalWriteTime", "setTotalWriteTime", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "toXContentFragment", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "add", "stat", "opensearch-cross-cluster-replication"})
    public static class FollowerStats
    implements ToXContentFragment {
        private long opsWritten;
        private long opsWriteFailures;
        private long opsWriteThrottles;
        private long opsRead;
        private long opsReadFailures;
        private long opsReadThrottles;
        private long followerCheckpoint;
        private long leaderCheckpoint;
        private long totalWriteTime;

        public FollowerStats(long opsWritten, long opsWriteFailures, long opsWriteThrottles, long opsRead, long opsReadFailures, long opsReadThrottles, long followerCheckpoint, long leaderCheckpoint, long totalWriteTime) {
            this.opsWritten = opsWritten;
            this.opsWriteFailures = opsWriteFailures;
            this.opsWriteThrottles = opsWriteThrottles;
            this.opsRead = opsRead;
            this.opsReadFailures = opsReadFailures;
            this.opsReadThrottles = opsReadThrottles;
            this.followerCheckpoint = followerCheckpoint;
            this.leaderCheckpoint = leaderCheckpoint;
            this.totalWriteTime = totalWriteTime;
        }

        public /* synthetic */ FollowerStats(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            if ((n & 4) != 0) {
                l3 = 0L;
            }
            if ((n & 8) != 0) {
                l4 = 0L;
            }
            if ((n & 0x10) != 0) {
                l5 = 0L;
            }
            if ((n & 0x20) != 0) {
                l6 = 0L;
            }
            if ((n & 0x40) != 0) {
                l7 = 0L;
            }
            if ((n & 0x80) != 0) {
                l8 = 0L;
            }
            if ((n & 0x100) != 0) {
                l9 = 0L;
            }
            this(l, l2, l3, l4, l5, l6, l7, l8, l9);
        }

        public final long getOpsWritten() {
            return this.opsWritten;
        }

        public final void setOpsWritten(long l) {
            this.opsWritten = l;
        }

        public final long getOpsWriteFailures() {
            return this.opsWriteFailures;
        }

        public final void setOpsWriteFailures(long l) {
            this.opsWriteFailures = l;
        }

        public final long getOpsWriteThrottles() {
            return this.opsWriteThrottles;
        }

        public final void setOpsWriteThrottles(long l) {
            this.opsWriteThrottles = l;
        }

        public final long getOpsRead() {
            return this.opsRead;
        }

        public final void setOpsRead(long l) {
            this.opsRead = l;
        }

        public final long getOpsReadFailures() {
            return this.opsReadFailures;
        }

        public final void setOpsReadFailures(long l) {
            this.opsReadFailures = l;
        }

        public final long getOpsReadThrottles() {
            return this.opsReadThrottles;
        }

        public final void setOpsReadThrottles(long l) {
            this.opsReadThrottles = l;
        }

        public final long getFollowerCheckpoint() {
            return this.followerCheckpoint;
        }

        public final void setFollowerCheckpoint(long l) {
            this.followerCheckpoint = l;
        }

        public final long getLeaderCheckpoint() {
            return this.leaderCheckpoint;
        }

        public final void setLeaderCheckpoint(long l) {
            this.leaderCheckpoint = l;
        }

        public final long getTotalWriteTime() {
            return this.totalWriteTime;
        }

        public final void setTotalWriteTime(long l) {
            this.totalWriteTime = l;
        }

        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            builder.startObject();
            this.toXContentFragment(builder, params);
            XContentBuilder xContentBuilder = builder.endObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
            return xContentBuilder;
        }

        @NotNull
        public final XContentBuilder toXContentFragment(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            builder.field("operations_written", this.opsWritten);
            builder.field("operations_read", this.opsRead);
            builder.field("failed_read_requests", this.opsReadFailures);
            builder.field("throttled_read_requests", this.opsReadThrottles);
            builder.field("failed_write_requests", this.opsWriteFailures);
            builder.field("throttled_write_requests", this.opsWriteThrottles);
            builder.field("follower_checkpoint", this.followerCheckpoint);
            builder.field("leader_checkpoint", this.leaderCheckpoint);
            builder.field("total_write_time_millis", this.totalWriteTime);
            return builder;
        }

        public FollowerStats(@NotNull StreamInput inp) {
            Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
            this(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 511, null);
            this.opsWritten = inp.readLong();
            this.opsWriteFailures = inp.readLong();
            this.opsRead = inp.readLong();
            this.opsReadFailures = inp.readLong();
            this.opsReadThrottles = inp.readLong();
            this.followerCheckpoint = inp.readLong();
            this.leaderCheckpoint = inp.readLong();
            this.totalWriteTime = inp.readLong();
        }

        public final void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeLong(this.opsWritten);
            out.writeLong(this.opsWriteFailures);
            out.writeLong(this.opsRead);
            out.writeLong(this.opsReadFailures);
            out.writeLong(this.opsReadThrottles);
            out.writeLong(this.followerCheckpoint);
            out.writeLong(this.leaderCheckpoint);
            out.writeLong(this.totalWriteTime);
        }

        public final void add(@NotNull FollowerStats stat) {
            Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
            this.opsWritten += stat.opsWritten;
            this.opsWriteFailures += stat.opsWriteFailures;
            this.opsWriteThrottles += stat.opsWriteThrottles;
            this.opsRead += stat.opsRead;
            this.opsReadFailures += stat.opsReadFailures;
            this.opsReadThrottles += stat.opsReadThrottles;
            this.followerCheckpoint += stat.followerCheckpoint;
            this.leaderCheckpoint += stat.leaderCheckpoint;
            this.totalWriteTime += stat.totalWriteTime;
        }

        public FollowerStats() {
            this(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 511, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/opensearch/replication/task/shard/FollowerShardMetric$FollowerStatsFragment;", "Lorg/opensearch/replication/task/shard/FollowerShardMetric$FollowerStats;", "Lorg/opensearch/core/xcontent/ToXContentFragment;", "<init>", "()V", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "opensearch-cross-cluster-replication"})
    public static final class FollowerStatsFragment
    extends FollowerStats
    implements ToXContentFragment {
        public FollowerStatsFragment() {
            super(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 511, null);
        }

        @Override
        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            return this.toXContentFragment(builder, params);
        }
    }
}

