"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExcelBuilder = void 0;
var _exceljs = _interopRequireDefault(require("exceljs"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class ExcelBuilder {
  constructor() {
    _defineProperty(this, "workbook", void 0);
    _defineProperty(this, "worksheet", void 0);
    _defineProperty(this, "headerRowsCount", void 0);
    this.workbook = new _exceljs.default.Workbook();
    this.worksheet = this.workbook.addWorksheet('Sheet1');
    this.headerRowsCount = 0;
  }
  addHeaders(json) {
    if (!json || json.length <= 0) {
      return this;
    }
    const headerKeys = this.getHeaderKeys(json);
    this.worksheet.columns = Object.keys(headerKeys).map(key => {
      return {
        header: [key],
        key
      };
    });
    this.headerRowsCount++;
    return this;
  }
  addRows(json) {
    if (!json || json.length <= 0) {
      return this;
    }
    for (const data of json) {
      this.worksheet.addRow(data);
    }
    return this;
  }
  updateColumnWidths() {
    for (const column of this.worksheet.columns) {
      if (!column.eachCell) {
        continue;
      }
      let maxLength = 0;
      let count = 1;
      column.eachCell({
        includeEmpty: true
      }, cell => {
        if (count > this.headerRowsCount) {
          const cellLength = cell.value ? cell.value.toString().length : 0;
          if (cellLength > maxLength) {
            maxLength = cellLength;
          }
        }
        count++;
      });
      column.width = this.getColumnWidth(maxLength);
    }
    return this;
  }
  applyFreeze() {
    this.worksheet.views = [{
      state: 'frozen',
      ySplit: this.headerRowsCount
    }];
    return this;
  }
  applyHeaderStyles() {
    for (let i = 1; i <= this.headerRowsCount; i++) {
      const row = this.worksheet.getRow(i);
      row.height = this.worksheet.properties.defaultRowHeight * 2;
      row.font = {
        bold: true
      };
      row.alignment = {
        horizontal: 'left',
        vertical: 'top',
        wrapText: true
      };
    }
    return this;
  }
  applyAutoFilter() {
    const row = this.worksheet.getRow(this.headerRowsCount);
    const firstCell = row.getCell(1);
    let lastCell = firstCell;
    row.eachCell({
      includeEmpty: true
    }, function (cell) {
      lastCell = cell;
    });
    this.worksheet.autoFilter = {
      from: firstCell.$col$row,
      to: lastCell.$col$row
    };
    return this;
  }
  async getWorkbookAsBase64() {
    const buffer = await this.workbook.xlsx.writeBuffer();
    const base64 = buffer.toString('base64');
    return base64;
  }
  getColumnWidth(length) {
    if (length <= 13) {
      return 15;
    }
    if (length <= 18) {
      return 20;
    }
    return 25;
  }
  getHeaderKeys(json) {
    const headerKeys = {};
    for (const data of json) {
      for (const key of Object.keys(data)) {
        if (!headerKeys[key]) {
          headerKeys[key] = true;
        }
      }
    }
    return headerKeys;
  }
}
exports.ExcelBuilder = ExcelBuilder;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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