/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplaceRootVolumeTaskRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateReplaceRootVolumeTaskRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateReplaceRootVolumeTaskRequest.getter(CreateReplaceRootVolumeTaskRequest::instanceId)).setter(CreateReplaceRootVolumeTaskRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("InstanceId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(CreateReplaceRootVolumeTaskRequest.getter(CreateReplaceRootVolumeTaskRequest::snapshotId)).setter(CreateReplaceRootVolumeTaskRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("SnapshotId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateReplaceRootVolumeTaskRequest.getter(CreateReplaceRootVolumeTaskRequest::clientToken)).setter(CreateReplaceRootVolumeTaskRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateReplaceRootVolumeTaskRequest.getter(CreateReplaceRootVolumeTaskRequest::dryRun)).setter(CreateReplaceRootVolumeTaskRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateReplaceRootVolumeTaskRequest.getter(CreateReplaceRootVolumeTaskRequest::tagSpecifications)).setter(CreateReplaceRootVolumeTaskRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(CreateReplaceRootVolumeTaskRequest.getter(CreateReplaceRootVolumeTaskRequest::imageId)).setter(CreateReplaceRootVolumeTaskRequest.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build()}).build();
    private static final SdkField<Boolean> DELETE_REPLACED_ROOT_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteReplacedRootVolume").getter(CreateReplaceRootVolumeTaskRequest.getter(CreateReplaceRootVolumeTaskRequest::deleteReplacedRootVolume)).setter(CreateReplaceRootVolumeTaskRequest.setter(Builder::deleteReplacedRootVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteReplacedRootVolume").unmarshallLocationName("DeleteReplacedRootVolume").build()}).build();
    private static final SdkField<Long> VOLUME_INITIALIZATION_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VolumeInitializationRate").getter(CreateReplaceRootVolumeTaskRequest.getter(CreateReplaceRootVolumeTaskRequest::volumeInitializationRate)).setter(CreateReplaceRootVolumeTaskRequest.setter(Builder::volumeInitializationRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeInitializationRate").unmarshallLocationName("VolumeInitializationRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, SNAPSHOT_ID_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, TAG_SPECIFICATIONS_FIELD, IMAGE_ID_FIELD, DELETE_REPLACED_ROOT_VOLUME_FIELD, VOLUME_INITIALIZATION_RATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateReplaceRootVolumeTaskRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String snapshotId;
    private final String clientToken;
    private final Boolean dryRun;
    private final List<TagSpecification> tagSpecifications;
    private final String imageId;
    private final Boolean deleteReplacedRootVolume;
    private final Long volumeInitializationRate;

    private CreateReplaceRootVolumeTaskRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.snapshotId = builder.snapshotId;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.tagSpecifications = builder.tagSpecifications;
        this.imageId = builder.imageId;
        this.deleteReplacedRootVolume = builder.deleteReplacedRootVolume;
        this.volumeInitializationRate = builder.volumeInitializationRate;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final Boolean deleteReplacedRootVolume() {
        return this.deleteReplacedRootVolume;
    }

    public final Long volumeInitializationRate() {
        return this.volumeInitializationRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteReplacedRootVolume());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeInitializationRate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplaceRootVolumeTaskRequest)) {
            return false;
        }
        CreateReplaceRootVolumeTaskRequest other = (CreateReplaceRootVolumeTaskRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.deleteReplacedRootVolume(), other.deleteReplacedRootVolume()) && Objects.equals(this.volumeInitializationRate(), other.volumeInitializationRate());
    }

    public final String toString() {
        return ToString.builder((String)"CreateReplaceRootVolumeTaskRequest").add("InstanceId", (Object)this.instanceId()).add("SnapshotId", (Object)this.snapshotId()).add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ImageId", (Object)this.imageId()).add("DeleteReplacedRootVolume", (Object)this.deleteReplacedRootVolume()).add("VolumeInitializationRate", (Object)this.volumeInitializationRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "DeleteReplacedRootVolume": {
                return Optional.ofNullable(clazz.cast(this.deleteReplacedRootVolume()));
            }
            case "VolumeInitializationRate": {
                return Optional.ofNullable(clazz.cast(this.volumeInitializationRate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("DeleteReplacedRootVolume", DELETE_REPLACED_ROOT_VOLUME_FIELD);
        map.put("VolumeInitializationRate", VOLUME_INITIALIZATION_RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReplaceRootVolumeTaskRequest, T> g) {
        return obj -> g.apply((CreateReplaceRootVolumeTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String instanceId;
        private String snapshotId;
        private String clientToken;
        private Boolean dryRun;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String imageId;
        private Boolean deleteReplacedRootVolume;
        private Long volumeInitializationRate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplaceRootVolumeTaskRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.snapshotId(model.snapshotId);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
            this.tagSpecifications(model.tagSpecifications);
            this.imageId(model.imageId);
            this.deleteReplacedRootVolume(model.deleteReplacedRootVolume);
            this.volumeInitializationRate(model.volumeInitializationRate);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final Boolean getDeleteReplacedRootVolume() {
            return this.deleteReplacedRootVolume;
        }

        public final void setDeleteReplacedRootVolume(Boolean deleteReplacedRootVolume) {
            this.deleteReplacedRootVolume = deleteReplacedRootVolume;
        }

        @Override
        public final Builder deleteReplacedRootVolume(Boolean deleteReplacedRootVolume) {
            this.deleteReplacedRootVolume = deleteReplacedRootVolume;
            return this;
        }

        public final Long getVolumeInitializationRate() {
            return this.volumeInitializationRate;
        }

        public final void setVolumeInitializationRate(Long volumeInitializationRate) {
            this.volumeInitializationRate = volumeInitializationRate;
        }

        @Override
        public final Builder volumeInitializationRate(Long volumeInitializationRate) {
            this.volumeInitializationRate = volumeInitializationRate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplaceRootVolumeTaskRequest build() {
            return new CreateReplaceRootVolumeTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReplaceRootVolumeTaskRequest> {
        public Builder instanceId(String var1);

        public Builder snapshotId(String var1);

        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder imageId(String var1);

        public Builder deleteReplacedRootVolume(Boolean var1);

        public Builder volumeInitializationRate(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

