/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.neuralsearch.query.ModelInferenceQueryBuilder;
import org.opensearch.neuralsearch.query.NeuralSparseQueryTwoPhaseInfo;
import org.opensearch.neuralsearch.util.prune.PruneType;

public abstract class AbstractNeuralQueryBuilder<QB extends AbstractNeuralQueryBuilder<QB>>
extends AbstractQueryBuilder<QB>
implements ModelInferenceQueryBuilder {
    @VisibleForTesting
    public static final ParseField QUERY_TEXT_FIELD = new ParseField("query_text", new String[0]);
    @VisibleForTesting
    public static final ParseField MODEL_ID_FIELD = new ParseField("model_id", new String[0]);
    @VisibleForTesting
    public static final ParseField QUERY_TOKENS_FIELD = new ParseField("query_tokens", new String[0]);
    protected String modelId;
    protected String fieldName;
    protected String queryText;
    protected String searchAnalyzer;
    protected Supplier<Map<String, Float>> queryTokensMapSupplier;
    protected NeuralSparseQueryTwoPhaseInfo neuralSparseQueryTwoPhaseInfo = new NeuralSparseQueryTwoPhaseInfo();

    public AbstractNeuralQueryBuilder(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String modelId() {
        return this.modelId;
    }

    public QB modelId(String modelId) {
        this.modelId = modelId;
        return (QB)this;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public QB fieldName(String fieldName) {
        this.fieldName = fieldName;
        return (QB)this;
    }

    public final String queryText() {
        return this.queryText;
    }

    public final QB queryText(String queryText) {
        this.queryText = queryText;
        return (QB)this;
    }

    public final String searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public final QB searchAnalyzer(String searchAnalyzer) {
        this.searchAnalyzer = searchAnalyzer;
        return (QB)this;
    }

    public final Supplier<Map<String, Float>> queryTokensMapSupplier() {
        return this.queryTokensMapSupplier;
    }

    public final QB queryTokensMapSupplier(Supplier<Map<String, Float>> queryTokensMapSupplier) {
        this.queryTokensMapSupplier = queryTokensMapSupplier;
        return (QB)this;
    }

    public final NeuralSparseQueryTwoPhaseInfo neuralSparseQueryTwoPhaseInfo() {
        return this.neuralSparseQueryTwoPhaseInfo;
    }

    public final QB neuralSparseQueryTwoPhaseInfo(NeuralSparseQueryTwoPhaseInfo neuralSparseQueryTwoPhaseInfo) {
        this.neuralSparseQueryTwoPhaseInfo = neuralSparseQueryTwoPhaseInfo;
        return (QB)this;
    }

    public abstract QB prepareTwoPhaseQuery(float var1, PruneType var2);

    public boolean isSparseTwoPhaseTwo() {
        return Objects.nonNull(this.neuralSparseQueryTwoPhaseInfo) && NeuralSparseQueryTwoPhaseInfo.TwoPhaseStatus.PHASE_TWO.equals((Object)this.neuralSparseQueryTwoPhaseInfo.getStatus());
    }

    public boolean isSparseTwoPhaseOne() {
        return Objects.nonNull(this.neuralSparseQueryTwoPhaseInfo) && NeuralSparseQueryTwoPhaseInfo.TwoPhaseStatus.PHASE_ONE.equals((Object)this.neuralSparseQueryTwoPhaseInfo.getStatus());
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public String getQueryText() {
        return this.queryText;
    }

    @Generated
    public String getSearchAnalyzer() {
        return this.searchAnalyzer;
    }

    @Generated
    public Supplier<Map<String, Float>> getQueryTokensMapSupplier() {
        return this.queryTokensMapSupplier;
    }

    @Generated
    public NeuralSparseQueryTwoPhaseInfo getNeuralSparseQueryTwoPhaseInfo() {
        return this.neuralSparseQueryTwoPhaseInfo;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Generated
    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    @Generated
    public void setSearchAnalyzer(String searchAnalyzer) {
        this.searchAnalyzer = searchAnalyzer;
    }

    @Generated
    public void setQueryTokensMapSupplier(Supplier<Map<String, Float>> queryTokensMapSupplier) {
        this.queryTokensMapSupplier = queryTokensMapSupplier;
    }

    @Generated
    public void setNeuralSparseQueryTwoPhaseInfo(NeuralSparseQueryTwoPhaseInfo neuralSparseQueryTwoPhaseInfo) {
        this.neuralSparseQueryTwoPhaseInfo = neuralSparseQueryTwoPhaseInfo;
    }

    @Generated
    public AbstractNeuralQueryBuilder() {
    }
}

