/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5.packets;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.crt.mqtt5.packets.UserProperty;

public class DisconnectPacket {
    private DisconnectReasonCode reasonCode = DisconnectReasonCode.NORMAL_DISCONNECTION;
    private Long sessionExpiryIntervalSeconds;
    private String reasonString;
    private List<UserProperty> userProperties;
    private String serverReference;

    public DisconnectReasonCode getReasonCode() {
        return this.reasonCode;
    }

    public Long getSessionExpiryIntervalSeconds() {
        return this.sessionExpiryIntervalSeconds;
    }

    public String getReasonString() {
        return this.reasonString;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    public String getServerReference() {
        return this.serverReference;
    }

    private DisconnectPacket(DisconnectPacketBuilder builder) {
        this.reasonCode = builder.reasonCode;
        this.sessionExpiryIntervalSeconds = builder.sessionExpiryIntervalSeconds;
        this.reasonString = builder.reasonString;
        this.userProperties = builder.userProperties;
        this.serverReference = builder.serverReference;
    }

    private DisconnectPacket() {
    }

    private void nativeAddDisconnectReasonCode(int reasonCode) {
        this.reasonCode = DisconnectReasonCode.getEnumValueFromInteger(reasonCode);
    }

    public static final class DisconnectPacketBuilder {
        private DisconnectReasonCode reasonCode = DisconnectReasonCode.NORMAL_DISCONNECTION;
        private Long sessionExpiryIntervalSeconds;
        private String reasonString;
        private List<UserProperty> userProperties;
        private String serverReference;

        public DisconnectPacketBuilder withReasonCode(DisconnectReasonCode reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public DisconnectPacketBuilder withSessionExpiryIntervalSeconds(long sessionExpiryIntervalSeconds) {
            this.sessionExpiryIntervalSeconds = sessionExpiryIntervalSeconds;
            return this;
        }

        public DisconnectPacketBuilder withReasonString(String reasonString) {
            this.reasonString = reasonString;
            return this;
        }

        public DisconnectPacketBuilder withUserProperties(List<UserProperty> userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        public DisconnectPacketBuilder withServerReference(String serverReference) {
            this.serverReference = serverReference;
            return this;
        }

        public DisconnectPacket build() {
            return new DisconnectPacket(this);
        }
    }

    public static enum DisconnectReasonCode {
        NORMAL_DISCONNECTION(0),
        DISCONNECT_WITH_WILL_MESSAGE(4),
        UNSPECIFIED_ERROR(128),
        MALFORMED_PACKET(129),
        PROTOCOL_ERROR(130),
        IMPLEMENTATION_SPECIFIC_ERROR(131),
        NOT_AUTHORIZED(135),
        SERVER_BUSY(137),
        SERVER_SHUTTING_DOWN(139),
        KEEP_ALIVE_TIMEOUT(141),
        SESSION_TAKEN_OVER(142),
        TOPIC_FILTER_INVALID(143),
        TOPIC_NAME_INVALID(144),
        RECEIVE_MAXIMUM_EXCEEDED(147),
        TOPIC_ALIAS_INVALID(148),
        PACKET_TOO_LARGE(149),
        MESSAGE_RATE_TOO_HIGH(150),
        QUOTA_EXCEEDED(151),
        ADMINISTRATIVE_ACTION(152),
        PAYLOAD_FORMAT_INVALID(153),
        RETAIN_NOT_SUPPORTED(154),
        QOS_NOT_SUPPORTED(155),
        USE_ANOTHER_SERVER(156),
        SERVER_MOVED(157),
        SHARED_SUBSCRIPTIONS_NOT_SUPPORTED(158),
        CONNECTION_RATE_EXCEEDED(159),
        MAXIMUM_CONNECT_TIME(160),
        SUBSCRIPTION_IDENTIFIERS_NOT_SUPPORTED(161),
        WILDCARD_SUBSCRIPTIONS_NOT_SUPPORTED(162);

        private int reasonCode;
        private static Map<Integer, DisconnectReasonCode> enumMapping;

        private DisconnectReasonCode(int code) {
            this.reasonCode = code;
        }

        public int getValue() {
            return this.reasonCode;
        }

        public static DisconnectReasonCode getEnumValueFromInteger(int value) {
            DisconnectReasonCode enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal DisconnectReasonCode");
        }

        private static Map<Integer, DisconnectReasonCode> buildEnumMapping() {
            return Stream.of(DisconnectReasonCode.values()).collect(Collectors.toMap(DisconnectReasonCode::getValue, Function.identity()));
        }

        static {
            enumMapping = DisconnectReasonCode.buildEnumMapping();
        }
    }
}

