/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.net.Socket;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServerConnectionId {
    private static final Pattern HOST_PORT_PARSE_EXP = Pattern.compile("([0-9a-zA-Z\\-%._:]*):([0-9]+)");
    private final String localHost;
    private final int localPort;
    private final String remoteHost;
    private final int remotePort;
    private final int processorId;
    private final int index;

    public ServerConnectionId(String localHost, int localPort, String remoteHost, int remotePort, int processorId, int index) {
        this.localHost = localHost;
        this.localPort = localPort;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        this.processorId = processorId;
        this.index = index;
    }

    private ServerConnectionId(Map.Entry<String, Integer> localEndpoint, Map.Entry<String, Integer> remoteEndpoint, int processorId, int index) {
        this(localEndpoint.getKey(), localEndpoint.getValue(), remoteEndpoint.getKey(), remoteEndpoint.getValue(), processorId, index);
    }

    public String localHost() {
        return this.localHost;
    }

    public int localPort() {
        return this.localPort;
    }

    public String remoteHost() {
        return this.remoteHost;
    }

    public int remotePort() {
        return this.remotePort;
    }

    public int processorId() {
        return this.processorId;
    }

    public int index() {
        return this.index;
    }

    public static Optional<ServerConnectionId> fromString(String connectionIdString) {
        String[] split = connectionIdString.split("-");
        if (split.length != 4) {
            return Optional.empty();
        }
        try {
            return ServerConnectionId.parseHostPort(split[0]).flatMap(localHost -> ServerConnectionId.parseHostPort(split[1]).map(remoteHost -> new ServerConnectionId((Map.Entry<String, Integer>)localHost, (Map.Entry<String, Integer>)remoteHost, Integer.parseInt(split[2]), Integer.parseInt(split[3]))));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static String generateConnectionId(Socket socket, int processorId, int connectionIndex) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        return localHost + ":" + localPort + "-" + remoteHost + ":" + remotePort + "-" + processorId + "-" + connectionIndex;
    }

    static Optional<Map.Entry<String, Integer>> parseHostPort(String connectionString) {
        Matcher matcher = HOST_PORT_PARSE_EXP.matcher(connectionString);
        if (matcher.matches()) {
            try {
                return Optional.of(Map.entry(matcher.group(1), Integer.parseInt(matcher.group(2))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

