"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../../../src/plugins/typescript/utils");
const typescript_1 = __importDefault(require("typescript"));
const assert = __importStar(require("assert"));
describe('TypeScriptPlugin utils', () => {
    describe('#getTsCheckComment', () => {
        const tsCheckComment = `// @ts-check${typescript_1.default.sys.newLine}`;
        const tsNocheckComment = `// @ts-nocheck${typescript_1.default.sys.newLine}`;
        it('should not return if ts-check is after non-comment-code', () => {
            assert.deepStrictEqual((0, utils_1.getTsCheckComment)(`qwd
            // @ts-check`), undefined);
        });
        it('should return @ts-check', () => {
            assert.deepStrictEqual((0, utils_1.getTsCheckComment)(`
            // @ts-check`), tsCheckComment);
        });
        it('should return @ts-nocheck', () => {
            assert.deepStrictEqual((0, utils_1.getTsCheckComment)(`
            // @ts-nocheck`), tsNocheckComment);
        });
        it('should return if ts-check is after some comments', () => {
            assert.deepStrictEqual((0, utils_1.getTsCheckComment)(`
            // hello
            
            ///
            // @ts-check`), tsCheckComment);
        });
        it('should not return if there are comments but without ts-check', () => {
            assert.deepStrictEqual((0, utils_1.getTsCheckComment)(`
            // nope
            // almost@ts-check
            // @ts-almostcheck
            ///
            `), undefined);
        });
    });
});
//# sourceMappingURL=utils.test.js.map