/* $Id: user.c,v 1.16 1997/08/08 14:29:00 jw5 Exp $
   Signal handling code.
*/

#include <l4/types.h>
#include <l4/ipc.h>
#include <l4/syscalls.h>
#include <l4/kdebug.h>

#include "../include/task.h" 
#include "../include/user.h"
#include "../include/lock.h"
#include "../include/exclpage.h"

/* see fake_interrupts.c  */
void 
handle_signals(void)
{
  l4_threadid_t user_id,sender_thread_id, preempter_id, linux_pager_id;
  dword_t P1,P2,old_eflags, old_eip, *old_esp;
  l4_msgdope_t result;
  dword_t cs;

  user_id=l4_myself();
  user_id.id.lthread = LTHREAD_NO_USER_THREAD;
  asm("movl $0, %%eax\n\t"
      "movw %%cs, %%ax\n\t"
      : "=a" (cs)
      );

  /* thread designated to handle fake_ints */
  for(;;)
    {
      if(l4_i386_ipc_wait(&sender_thread_id,0,&P1,&P2, 
			  L4_IPC_NEVER, &result))
	{
	  /* tell("DispatchMessage: IPC-wait error\n"); */
	  continue;
	}

      /* try local lock.  If set, user thread is already within the
	 kernel.  There is no need to do an zero syscall in this case.


	 Otherwise, get the lock, save registers to ptregs, force the
	 user thread into a zero syscall.  Other places we deal with
	 the lock is in the emulation code in int_entry.S. 

	 In an earlier version there was a race condition in signal
	 delivery. It was possible, that the linux server has finished
	 signal delivery and another linux server tries to propagte a
	 signal to the user. In this situation we had to wait until
	 the user released the emu_lib to propagte the signal anyway.
	 We used a variable sigs_handled to indicate this situation.  */

      if(! simple_try_lock(&(exclusive_page_ptr->emu_local_lock)))
	continue;

#ifdef DEBUG
      enter_kdebug("propagate signal: ex_regs");
#endif
      /* set user thread looping forever */
      l4_thread_ex_regs(user_id, 
			(dword_t) do_nothing_loop, 
			/* XXX esp not required ? */
			(dword_t) exclusive_page_ptr->uemulib_stack+
			STACK_SIZE_UEMULIB, 
			&preempter_id, &linux_pager_id, &old_eflags, &old_eip, 
			(dword_t*) &old_esp);
 
      /* manipulate its stack ( add eip, cs, eflags - error is added by _entry
       */

#ifdef DEBUG
      kd_display("to: ");
      outhex32(old_eip);
#endif
      * (--old_esp)=old_eflags;   /* eflags */
      * (--old_esp)=cs; /* cs */
      * (--old_esp)=old_eip; /* eip */
    
      /* take user thread out of loop, generate 'faked' exception 19 */
      l4_thread_ex_regs(user_id, 
			(dword_t) entry19, 
			(dword_t)old_esp, 
			&preempter_id, &linux_pager_id, &old_eflags, &old_eip, 
			(dword_t*)&old_esp);
#ifdef DEBUG
      kd_display("finished\n\r");
#endif
      /* signal thread continues here, 
	 user thread does an exception 19 and goes back immediately afterwards
	 to user code.
	 */ 

      /* unlock the local lock, otherwise the user thread won't never
	 actually do the zero-syscall
	 */
      simple_unlock(&(exclusive_page_ptr->emu_local_lock));
    
    }

}

   
