/* $Id: config.h,v 1.26 1998/01/16 16:03:51 jw5 Exp $ */

#ifndef __L4_I386_CONFIG_H
#define __L4_I386_CONFIG_H

/* debug flag */
#define L4_DEBUG 1
#define INLINED_RET_FROM_SYSCALL
#define INTR_SCHEDULING	

#define USE_PRIOS		/* L4 priorities for Linux server
				   kernel threads */
#define USE_SMALL_SPACES 64	/* do we use small address spaces, and
				   their size in MB */
/* #define USE_SUPER_CLAN */	/* use supervisor (rmgr) for all task
				   creations, yielding "flat" clan */
/* #define IRQ_LOCK */		/* use locking instead of machine-cli/sti */

/* #define TAME_SERVER */	/* only use machine-cli for PIC
				   programming -- implies IRQ_LOCK! */
/* #define BROKEN_L4_SCHEDULE */	/* l4_thread_schedule (and prios)
				   don't work -- use on old versions of L4 */

#define PRIO_IRQ(x) (144 - (x))	/* x = 15..0  -> prio 129..144 */
#define PRIO_BOTTOM_HALF (128)
#define PRIO_KERNEL 127
#define PRIO_ROOT 100

#define MCP_SUPER   255
#define MCP_KERNEL  100
#define MCP_USER    0

/* L4 thread numbers for Linux server kernel threads */

#define LTHREAD_NO_LINUX_SERVER	(3)
#define LTHREAD_NO_PROC_UNSELECT (2)
#define LTHREAD_NO_IRQ(x) 	(16 + (x)) /* x = 0..15  -> threadno 16..31*/
#define LTHREAD_NO_BOTTOM_HALF 	(32)
#define LTHREAD_NO_ROOT_EXEC 	(33)
#define LTHREAD_NO_ROOT_PAGER	(34)
#define LTHREAD_NO_SIG_SEGV	(35)


#define LTHREAD_NO_USER_THREAD	(0)
#define LTHREAD_NO_SIGNAL_THREAD	(1)
#define NO_IRQS 16		/* number of machine interrupts */

/* stack sizes */
#define INIT_USER_STACK_START 1021
#define STACK_SIZE_PROC_UNSELECT 512
#define STACK_SIZE_IRQ (1024)
#define STACK_SIZE_BOTTOM_HALF (1024)
#define STACK_SIZE_ROOT_EXEC (1024)
#define STACK_SIZE_SIG_SEGV (512)
#define STACK_SIZE_USIGNAL (512)
#define STACK_SIZE_UEMULIB (512)

/* L4 task numbers */
#define TASK_NO_MIN (10)
#define TASK_NO_MAX (2047)

/* size of client-usable vm */
#ifdef __ASSEMBLY__
#define TASK_SIZE (0xA0000000)
#else
#define TASK_SIZE (0xA0000000UL)
#endif

/* basis address for exclusive page */
#define EXCLUSIVE_PAGE_ADDRESS (TASK_SIZE)
#define EMULIB_CODE_ADDRESS (TASK_SIZE + 0x8000)


/* address of kernel info page */
#define KERNEL_INFO_PAGE_ADDRESS (0x1000)

/* end of user-configurable section */

/* some invariants follow */
#ifdef TAME_SERVER		/* implies IRQ_LOCK */
# ifndef IRQ_LOCK
# define IRQ_LOCK
# endif
#endif

#ifdef BROKEN_L4_SCHEDULE
# undef USE_PRIOS
# undef USE_SMALL_SPACES
# ifndef IRQ_LOCK
# define IRQ_LOCK
# endif
#endif

#endif /* ! __L4_I386_CONFIG_H */
