#ifndef __L4_MEMORY_H__ 
#define __L4_MEMORY_H__ 

#include <linux/mm.h>
#include <asm/pgtable.h>
#include <l4/kernel.h>
#include <l4/kdebug.h>
#include <l4/ipc.h>

/* #define DEBUG_KO */
/* #define DEBUG_REQUEST_KO */

#ifdef DEBUG_KO
#define KO(x) ko(x)
#else
#define KO(x) 
#endif
#ifdef DEBUG_REQUEST_KO
#define RKO(x) ko(x)
#else
#define RKO(x) 
#endif

extern l4_kernel_info_t *l4_kernel_info;
extern l4_threadid_t sigma0_id;

/*
 * defines for functions
 */

#define L4_ACCESS_MASK (2L)
#define L4_READ_ACCESS (0)
#define L4_WRITE_ACCESS (2)

#define L4_PAG_OK (0)
#define L4_PAG_BAD_ACCESS (-1)
#define L4_PAG_TEMP_NOT_PRESENT (-2)

/* #define LINUX_MEM_START (0x100000) */
extern char _stext, _etext;		/* defined in head.S */

#define LINUX_MEM_START ((unsigned) &_stext)

#define L4_4MB (0x400000U)
#define L4_LOG2_4MB (22)
#define L4_ONE_GIG (0x40000000U)
#define L4_LOG2_HALF_GIG (29)
#define L4_HALF_ADDRESS_SPACE (29)
#define L4_4MB_MASK (~(L4_4MB - 1))

#define L4_PHYS (0)

#define RP_WRITABLE 	0
#define RP_NOT_WRITABLE 1
#define RP_NOT_MAPPED 	2
#define RP_RESERVED_COLOR 	3
#define RP_4M 		22

#define PF_EUSER (4)
#define PF_EKERNEL (0)
#define PF_EWRITE (2)
#define PF_EREAD (0)
#define PF_EPROTECTION (1)
#define PF_ENOTPRESENT (0)

extern unsigned long root_pager_low_memory_start, root_pager_memory_start, 
  root_pager_memory_end;

extern l4_threadid_t root_pager_id, root_preempter_id, sig_segv_thread_id;
extern char emu_lib_text[PAGE_SIZE];

int 
request_page_from_sigma0(unsigned long address);
int 
request_mem_area_from_sigma0(dword_t fault_address, dword_t pte_val);
void 
request_physical_page_from_sigma0(unsigned long physical_page, 
				  unsigned long access, 
				  unsigned long vm_page);
void
request_zero_page_from_sigma0(void);

int 
setup_kernel_info_page(void);

void 
new_paging_init(unsigned long start_mem, unsigned long *end_mem_p, 
		unsigned long *start_mem_p);
 
void 
start_root_pager(void);
void 
root_pager(void);
void 
kernel_pager(void);

int 
handle_pagefault(void **msg, dword_t *fault_address, dword_t *faulting_eip);
int 
l4_do_page_fault(unsigned long address, unsigned long error_code);

extern inline int
adapter_page(unsigned long addr)
{
  return (addr > 0x80000000U);
}
extern inline void 
request_page_writeable(unsigned long address, pte_t pte)
{
#ifdef DEBUG
  printk("(%x.%x) request_page_writeable(%lx, %lx);\n", 
	 l4_myself().id.task, l4_myself().id.lthread, address, pte_val(pte)); 
#endif
  if (l4_do_page_fault(address, 
		       (PF_EKERNEL | PF_EWRITE | 
			(pte_present(pte) ? PF_EPROTECTION : PF_ENOTPRESENT )))
      )
      panic("do_page_fault return after bad kernel write access");
}

extern inline void 
request_page_readable(unsigned long address)
{
#ifdef DEBUG
  printk("(%x.%x) request_page_readable(%lx);\n", 
	 l4_myself().id.task, l4_myself().id.lthread, address);
#endif
  if (l4_do_page_fault(address, 
		       PF_EKERNEL | PF_EREAD | PF_ENOTPRESENT))
      panic("do_page_fault return after bad kernel read access");
}

extern inline pte_t * 
lookup_pte(pgd_t *page_dir, dword_t pf_address)
{
  /*
   * find the page table entry within the page table hierarchy
   */
  pgd_t *pgd = page_dir + (pf_address >> PGDIR_SHIFT) ;
  if (pgd_present(*pgd))
    {
      pmd_t *pmd = pmd_offset(pgd, pf_address);
      if (pmd_present(*pmd))
	{
	  pte_t *pte=pte_offset(pmd, pf_address);
	  return pte;
	}
#ifdef DEBUG
      else
	herc_printf("!pmd_present\n");
#endif
    }
#ifdef DEBUG
  else
    herc_printf("!pgd_present\n");
#endif
  return NULL;
}

#endif
