/* $Id: lock.h,v 1.28 1997/08/31 21:03:01 hohmuth Exp $
locks.h
*/
#ifndef __LOCK_H__
#define __LOCK_H__


#include <l4/syscalls.h>
#include <asm/atomic.h>
/* #include <asm/segment.h> */

#include "locktypes.h"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif


/* simple lock functions */

/* lock_solid does an busy wait on the lock */
/* void simple_lock_solid(simple_lock_t *); */

/* 
 * atomic test of lock 
 * returns 0 if lock was set,
 * else lock is set and 1 is returned
*/
extern inline int 
simple_try_lock(simple_lock_t *lock)
{
  int tmp;
  __asm__ __volatile__ ("xchg	%1, (%2)\n\t"
			: "=r" (tmp)
			: "0" (1), "r" (lock)
			: "memory"
			);
  return (tmp == 0);
}

 
extern inline void 
simple_unlock(simple_lock_t *lock)
{
  *lock = 0;
  /*
  __asm__ __volatile__ ("xchg	%1, (%2)\n\t"
			:
			: "r" (0), "r" (lock)
			: "memory"
			);
			*/
}

extern inline int
simple_lock_locked(simple_lock_t * lock)
{
  return (*lock==0) ? FALSE : TRUE; 
}

extern inline void
simple_lock_solid(register simple_lock_t *p)
{
  while (simple_lock_locked(p) || !simple_try_lock(p))
    l4_thread_switch(L4_NIL_ID);
}
extern inline void
simple_lock(simple_lock_t * lock)
{
  if(!simple_try_lock(lock))
    simple_lock_solid(lock);
}

extern inline int
lock_int_lock(void)
{
  long tmp;
  __asm__ __volatile__ (
			"movl	%%esp, %0	\n\t"
			"andl	$0xfffff000, %0\n\t"
			"cmpl	$-1, "SYMBOL_NAME_STR(interrupt_lock_owner)"\n\t"
			"jz	1f		\n\t" /* free */
			"movl	0xff8(%0), %0\n\t"
			"cmpl	%0, "SYMBOL_NAME_STR(interrupt_lock_owner)"\n\t"
			"jz	2f		\n\t"  /* locked by myself */
			"xorl	%0, %0	\n\t"
			"jmp	3f		\n\t"
			"1:\n\t"
			"movl	0xff8(%0), %%edx\n\t"
			"movl	0xffc(%0), %0\n\t"
			"movl	%%edx, "SYMBOL_NAME_STR(interrupt_lock_owner)"\n\t"
			"movl	%0, "SYMBOL_NAME_STR(interrupt_lock_owner)"+4\n\t"
			"2:\n\t"
			"movl	$1, %0	\n\t"
			"3:\n\t"
			: "=a" (tmp)
			:
			: "edx", "memory"
			);
  return tmp;
}
extern inline int 
holding_int_lock(void)
{
  long tmp;
  __asm__ __volatile__ (
			"movl	%%esp, %0	\n\t"
			"andl	$0xfffff000, %0\n\t"
			/*
			"cmpl	$0, "SYMBOL_NAME_STR(interrupt_lock_owner)"\n\t"
			"jz	2f		\n\t"
			*/
			"movl	0xff8(%0), %0\n\t"
			"cmpl	%0, "SYMBOL_NAME_STR(interrupt_lock_owner)"\n\t"
			"jnz	2f		\n\t"  /* locked by myself */
			"movl	$1, %0	\n\t"
			"jmp	3f		\n\t"

			"2:\n\t"
			"xorl	%0, %0	\n\t"
			"3:\n\t"
			: "=a" (tmp)
			);
  return tmp;
}

#endif /* __LOCK_H__ */









