/* $Id: irq.c,v 1.52 1998/01/16 16:05:05 jw5 Exp $ */
/* 
 * Copyright (C) 1992, 1993 Linus Torvalds
 */

#define __IRQ_DEFINE__		/* signal to <asm/system.h>: do definitions */

#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/ipc.h>
#include <l4/kdebug.h>

#include <linux/param.h>	/* HZ */
#include <linux/ptrace.h>	/* struct pt_regs */
#include <linux/sched.h>	/* intr_count */
#include <linux/malloc.h>	/* kmalloc() */
#include <linux/kernel_stat.h>	/* kstat */
#include <linux/signal.h>	/* SA_* definitions */
#include <linux/random.h>	/* interrupt randomness */
#include <linux/ioport.h>	/* request_region() */

#include <asm/io.h>		/* inb() et al. */
#include <asm/system.h>		/* save_flags(), cli() et al. */

#include "../include/config.h"
#include "../include/task.h"
#include "../include/rmgr.h"
#include "../include/l4_memory.h"
#include "../include/lock.h"
#include "../include/debug.h"
#include "../include/perform.h"

/* #define GET_RID_OF_BH_THREAD */

/* define NO_INTR_SCHEDULING to reintroduce old scheduling behavior */
/* #define NO_INTR_SCHEDULING	 */

/* #define MEASURE_IRQ_PATH */
#ifdef MEASURE_IRQ_PATH
#include "../include/perform.h"
unsigned long irq_start, irq_stop;
#endif
/* #define GET_RID_OF_BH_THREAD */
/* interfaces we implement */


#include <linux/interrupt.h>
#include <asm/irq.h>

/*#define DEBUG*/
#define SANITY

#define BH_THREAD

#ifdef SANITY
unsigned long int irqs_in_progress;
#endif /* SANITY */
extern int idle_sleeping;
unsigned long irq_start, irq_stop;

/* masking/unmasking interrupts */
#if 1
extern int start, end;
static int dma_warning_count = 10;
void
check_dma_addr(unsigned int a)
{
  if ((a>=(unsigned int)&start) && (a<=root_pager_memory_start))
    {
      herc_printf("dma src: %lx, eip: %p\n", a, (&a)-1);
    }
}
#endif

static inline void mask_irq(unsigned int irq_nr)
{
  unsigned char mask;

  /* special case: as we emulate irq 0, we shouldn't (un)mask it */
  if (irq_nr == TIMER_IRQ)
    return;

  __cli_if_tame();

  mask = 1 << (irq_nr & 7);
  if (irq_nr < 8)
    {
      outb(inb(0x21) | mask, 0x21);
    }
  else 
    {
      outb(inb(0xA1) | mask, 0xA1);
    }

  __sti_if_tame();
}

static inline void unmask_irq(unsigned int irq_nr)
{
  unsigned char mask;

  /* special case: as we emulate irq 0, we shouldn't (un)mask it */
  if (irq_nr == TIMER_IRQ)
    return;

  __cli_if_tame();

  mask = ~(1 << (irq_nr & 7));
  if (irq_nr < 8) 
    {
      outb(inb(0x21) & mask, 0x21);
    } 
  else
    {
      outb(inb(0xA1) & mask, 0xA1);
    }

  __sti_if_tame();
}

#ifdef IRQ_LOCK
l4_threadid_t interrupt_lock_owner = L4_INVALID_ID;

struct next_locker *int_lock_queue_head = 0;
struct next_locker *int_lock_queue_tail = 0;

#ifdef TAME_SERVER
simple_lock_t irq_queue_lock = FALSE;
#endif

extern int debug_msr;
void
__new_cli(void)
{
  l4_threadid_t me = get_l4_id_from_stack();
  struct next_locker this;
  l4_threadid_t waker;
  l4_msgdope_t result;
  dword_t data1, data2;

#if 0
  if (current->comm[0]=='_')
    ko('C');
#endif
#if 0
  ko('C');
  kd_display("new cli\\r\\n");
  if (debug_msr)
    {
      herc_printf("%x called new_cli, lock hold by: %x\n", 
		  get_l4_id_from_stack().lh.low, interrupt_lock_owner.lh.low);
      enter_kdebug("watch_int_lock");
    }
#endif
  
  DPRINT("%x called new_cli, lock hold by: %x\n", 
	 get_l4_id_from_stack().lh.low, interrupt_lock_owner.lh.low);
  this.id = me;
  this.queued = 1;
  this.next = 0;
	
  if (!int_lock_queue_tail)
    {
      int_lock_queue_head = &this;
      waker = interrupt_lock_owner;
    }
  else
    {
      int_lock_queue_tail->next = &this;
      waker = int_lock_queue_tail->id;
    }
  int_lock_queue_tail = &this;

  /* end of critical region, but remain __cli()'d */
  __sti_q_not_sti();

  /* go to sleep */
  if (waker.lh.low==-1)
    enter_kdebug("waker == -1");

  if (l4_i386_ipc_receive(waker, L4_IPC_SHORT_MSG,
			  &data1, &data2,
			  L4_IPC_NEVER, &result))
    {
      enter_kdebug("cli: receive error");
    }
#ifdef SANITY
  else
    {
      if (! (data1 == 0xce11dead && data2 == 0xc001b001))
	enter_kdebug("cli: wakeup wrong");
    }
#endif
  /* we'll be interrupt_lock_owner when we return */

#ifdef SANITY
  if (this.queued)
    enter_kdebug("cli: still queued");

  if (! thread_equal(interrupt_lock_owner, me))
    enter_kdebug("cli: early wakeup");
#endif
}

void
__new_sti(void)
{
  struct next_locker *n;
  l4_msgdope_t result;

  DPRINT("%x called new_sti, lock hold by: %x\n", 
	 get_l4_id_from_stack().lh.low, interrupt_lock_owner.lh.low);

  /* dequeue thread waiting for lock, if any */
  n = int_lock_queue_head;
  if ((int_lock_queue_head = n->next) == 0)
    int_lock_queue_tail = 0;

  if (n)
    {
      interrupt_lock_owner = n->id;
      n->queued = 0;

      if (l4_i386_ipc_send(n->id, L4_IPC_SHORT_MSG, 0xce11dead, 0xc001b001,
			   L4_IPC_NEVER, &result))
	{
	  enter_kdebug("sti: send error");
	}
    }
  else
    {
      interrupt_lock_owner = L4_INVALID_ID;
    }
}

#endif /* IRQ_LOCK */

void disable_irq(unsigned int irq_nr)
{
	unsigned long flags;

	save_flags(flags);
	cli();
	mask_irq(irq_nr);
	restore_flags(flags);
}

void enable_irq(unsigned int irq_nr)
{
	unsigned long flags;
	save_flags(flags);
	cli();
	unmask_irq(irq_nr);
	restore_flags(flags);
}


extern inline void
wakeup_idle_if_needed(void)
{
  /* when in an irq service routine, we must make sure the
     wakeup request will really wake up the process.  so if the
     kernel server is idling, wake it up. */
  if (need_resched && idle_sleeping)
    {
      l4_msgdope_t dummydope;
      dword_t foo;
      /*      ko('W');*/
      if (l4_i386_ipc_call(kernel_thread_id,
			   0, 0xbbbbbbbb, 0xdeadbeef, 
			   0, &foo, &foo,
			   L4_IPC_TIMEOUT(0,1,0,0,0,0), /* rcv = inf,
							   snd = 0 */
			   &dummydope))
	kd_display("wake_up_process: ipc failed\\r\\n");
    }
}


#ifndef GET_RID_OF_BH_THREAD
/* bottom half execution (for slow interrupt handlers) */

#ifdef BH_THREAD
/* bottom half thread.

   Note: this must be run at some higher priority than regular kernel
   threads (but at lower priority than interrupt threads) because
   bottom half handlers expect not to be interrupted by anything but
   interrupt handlers. */

static l4_threadid_t bh_th_id;
#if 0
static struct task_struct bh_task_struct;
#endif

static void bottom_half_thread(void)
{
  int code;
  dword_t dummy;
  l4_msgdope_t dummydope;
  l4_threadid_t sender;

  set_default_idt();

#if 0
  /* initialize task struct for bottom half thread */
  bh_task_struct.tss = (struct thread_struct)INIT_TSS;
  bh_task_struct.tss. kernel_thread_id = l4_myself();
#endif

  /* wait for an activation from an interrupt thread, then try to
     execute bottom halfs */
  
  for (;;)
    {
#ifdef SANITY
      irqs_in_progress &= ~(1 << 16); /* last irq + 1 */
#endif
      code = l4_i386_ipc_wait(&sender, 0,
			      &dummy, &dummy,
			      L4_IPC_NEVER, &dummydope);
      if (code)
	continue;		/* Hmm... */

      /* verify we've been activated from some local thread */
      if (! thread_equal(get_taskid(sender), get_taskid(bh_th_id)))
	continue;		/* Hmm... */

      code = l4_i386_ipc_send(sender, 0,
			      0xaffeaffe, 0xaffeaffe,
			      L4_IPC_NEVER, &dummydope);
      if (code)
	{
	  enter_kdebug("bh: reply failed");
	}
#ifdef SANITY
      irqs_in_progress |= (1 << 16); /* last irq + 1 */
#endif

#if 0
      /* XXX aquire kernel lock to synchronize with other kernel threads */
      kernel_enter(&bh_task_struct);
#endif

      cli();

      start_bh_atomic();
      /*
	intr_count++;
	*/
      while ((bh_active & bh_mask))
	{
	  sti();
	  do_bottom_half();
	  cli();
	}
      end_bh_atomic();
      /*       intr_count--; */

      sti();
      /* check whether we have to wakeup our service thread due to 
	 need_resched */
      wakeup_idle_if_needed();      
#if 0
      /* release kernel lock */
      kernel_exit();
#endif
    }
}
#endif
#endif

/* execute bottom halfs; will be entered with interrupts disabled,
   and must exit with interrupts disabled. */
static inline
void execute_bottom_halfs(void) 
{
  /* this code is called from the interrupt thread.  in order to
     prevent preventing the irq thread from receiving more interrupts,
     we can't execute bottom halfs right here.  Instead, notify a
     special bottom half thread. */
  dword_t dummy;
  if ((bh_active & bh_mask) && ! intr_count)
    {
#ifdef GET_RID_OF_BH_THREAD
  if (idle_sleeping)
    {
      l4_msgdope_t dummydope;
      dword_t foo;
/*       ko('Z'); */
      if (l4_i386_ipc_call(kernel_thread_id,
			   0, 0xaaaaaaaa, 0xdeadbeef, 
			   0, &foo, &foo,
			   L4_IPC_TIMEOUT(0,1,0,0,0,0), /* rcv = inf,
							   snd = 0 */
			   &dummydope))
	kd_display("wake_up_process: ipc failed\\r\\n");
    }
#else
#ifdef BH_THREAD
      l4_msgdope_t dummydope;
      sti();

      l4_i386_ipc_call(bh_th_id, 0,
		       0, 0,
		       0, &dummy, &dummy,
		       L4_IPC_TIMEOUT(0,1,0,0,0,0), /* rcv = inf,
						       snd = 0 */
		       &dummydope);
#else
      start_bh_atomic();
/*       intr_count++; */
      while ((bh_active & bh_mask))
	{
	  sti();
	  do_bottom_half();
	  cli();
	}
      end_bh_atomic();
/*       intr_count--; */
#endif
#endif
    }
  else
    {
      /* check whether we have to wakeup our service thread due to 
	 need_resched */
      wakeup_idle_if_needed();      
      sti();
    }
}



/* high level irq handlers */

/* Initial irq handlers. (from arch/i386/kernel/irq.c) */

static void no_action(int cpl, void *dev_id, struct pt_regs *regs) { }

/* IRQ2 is cascade interrupt to second interrupt controller */
static struct irqaction irq2  = { no_action, 0, 0, "cascade", NULL, NULL};

/* Note that on a 486, we don't want to do a SIGFPE on a irq13 as the
   irq is unreliable, and exception 16 works correctly (ie as
   explained in the intel literature). */
 
static void math_error_irq(int cpl, void *dev_id, struct pt_regs *regs)
{
  outb(0,0xF0);			/* XXX necessary? */
}

static struct irqaction irq13 = { math_error_irq, 0, 0, "math error", 
				    NULL, NULL };

/* a handler we install if we can't attach to a given interrupt in
   order to prevent probes and requests for this irq */
static struct irqaction irq_unassigned = { no_action, 0, 0, "non-Linux",
					     NULL, NULL};

static struct irqaction *irq_action[16] = {
  &irq_unassigned, &irq_unassigned, &irq_unassigned, &irq_unassigned, 
  &irq_unassigned, &irq_unassigned, &irq_unassigned, &irq_unassigned, 
  &irq_unassigned, &irq_unassigned, &irq_unassigned, &irq_unassigned, 
  &irq_unassigned, &irq_unassigned, &irq_unassigned, &irq_unassigned
};

/*
 * do_IRQ handles IRQ's that have been installed without the
 * SA_INTERRUPT flag: it uses the full signal-handling return
 * and runs with other interrupts enabled. All relatively slow
 * IRQ's should use this format: notably the keyboard/timer
 * routines.
 */
static void do_IRQ(int irq, struct pt_regs * regs)
{
	struct irqaction * action = *(irq + irq_action);

	kstat.interrupts[irq]++;
	while (action) {
		if (action->flags & SA_SAMPLE_RANDOM)
			add_interrupt_randomness(irq);
		action->handler(irq, action->dev_id, regs);
		action = action->next;
	}
}

/*
 * do_fast_IRQ handles IRQ's that don't need the fancy interrupt return
 * stuff - the handler is also running with interrupts disabled unless
 * it explicitly enables them later.
 */
static void do_fast_IRQ(int irq)
{
	struct irqaction * action = *(irq + irq_action);

	kstat.interrupts[irq]++;
	while (action) {
		action->handler(irq, action->dev_id, NULL);
		action = action->next;
	}
#ifndef NO_INTR_SCHEDULING	
 	wakeup_idle_if_needed();
#endif	  
}


/* code to build low-level irq handlers follows (from
   include/asm-i386/irq.h) */

/*
 * The "inb" instructions are not needed, but seem to change the timings
 * a bit - without them it seems that the harddisk driver won't work on
 * all hardware. Arghh.
 */
#define ACK_FIRST(mask) \
	"inb $0x21,%%al\n\t" \
	"jmp 1f\n" \
	"1:\tjmp 1f\n" \
	"1:\torb $" #mask ",%%al\n\t" \
	"outb %%al,$0x21\n\t" \
	"jmp 1f\n" \
	"1:\tjmp 1f\n" \
	"1:\tmovb $0x20,%%al\n\t" \
	"outb %%al,$0x20\n\t"

/* XXX is this safe in the L4 environment? */
#define ACK_SECOND(mask) \
	"inb $0xA1,%%al\n\t" \
	"jmp 1f\n" \
	"1:\tjmp 1f\n" \
	"1:\torb $" #mask ",%%al\n\t" \
	"outb %%al,$0xA1\n\t" \
	"jmp 1f\n" \
	"1:\tjmp 1f\n" \
	"1:\tmovb $0x20,%%al\n\t" \
	"outb %%al,$0xA0\n\t" \
	"jmp 1f\n" \
	"1:\tjmp 1f\n" \
	"1:\toutb %%al,$0x20\n\t"

#define UNBLK_FIRST(mask) \
	"inb $0x21,%%al\n\t" \
	"jmp 1f\n" \
	"1:\tjmp 1f\n" \
	"1:\tandb $~(" #mask "),%%al\n\t" \
	"outb %%al,$0x21\n\t"

#define UNBLK_SECOND(mask) \
	"inb $0xA1,%%al\n\t" \
	"jmp 1f\n" \
	"1:\tjmp 1f\n" \
	"1:\tandb $~(" #mask "),%%al\n\t" \
	"outb %%al,$0xA1\n\t"

#define IRQ_NAME2(nr) nr##_interrupt(void)
#define IRQ_NAME(nr) IRQ_NAME2(IRQ##nr)
#define FAST_IRQ_NAME(nr) IRQ_NAME2(fast_IRQ##nr)
#define BAD_IRQ_NAME(nr) IRQ_NAME2(bad_IRQ##nr)

/* L4-specific code follows 

   We try to mimic the standard i386 irq scheme: We define handlers
   for all IRQs and have them called from an IRQ thread via a handler
   table (equivalently to the table of interrupt gates on i386) 

   handlers are entered with interrupts disabled (_real_ interrupts
   disabled, but cli-unlocked (!), if that makes a difference (i.e.,
   when IRQ_LOCK is #def'd)), and must leave in the same state. */

#define IRQ_ASM(foo)							\
  asm(foo								\
      : /* nothing out */						\
      : /* nothing in */						\
      : "memory", "eax" /* clobbers eax */)

#define BUILD_IRQ(chip,nr,mask)						\
									\
static void IRQ_NAME(nr)						\
{									\
  /* the following code is equivalent to include/asm-i386/irq.h's	\
     BUILD_IRQ() macro */						\
  IRQ_ASM(ACK_##chip(mask));						\
  __sti_if_tame();							\
  cli();								\
  start_bh_atomic();							\
  sti();								\
  do_IRQ(nr, 0);		/* XXX pt_regs is NULL! */		\
  cli();								\
  __cli_if_tame();							\
  IRQ_ASM(UNBLK_##chip(mask));						\
  __sti_if_tame();							\
  end_bh_atomic();							\
  execute_bottom_halfs();						\
  sti();								\
  __cli();								\
}									\
									\
static void FAST_IRQ_NAME(nr)						\
{									\
  /* the following code is equivalent to include/asm-i386/irq.h's	\
      BUILD_IRQ() macro */						\
  IRQ_ASM(ACK_##chip(mask));						\
  __sti_if_tame();							\
  cli();								\
  start_bh_atomic();							\
  do_fast_IRQ(nr);							\
  cli();								\
  __cli_if_tame();							\
  IRQ_ASM(UNBLK_##chip(mask));						\
  __sti_if_tame();							\
  end_bh_atomic();							\
  sti();								\
  __cli();								\
}									\
									\
static void BAD_IRQ_NAME(nr)						\
{									\
  /* the following code is equivalent to include/asm-i386/irq.h's	\
     BUILD_IRQ() macro */						\
  IRQ_ASM(ACK_##chip(mask));						\
}

/* the timer irq should only be entered with __cli() when we're not a
   tame server */

#define BUILD_TIMER_IRQ(chip,nr,mask)					\
static void IRQ_NAME(nr)						\
{									\
  /* the following code is equivalent to include/asm-i386/irq.h's	\
     BUILD_TIMER_IRQ() macro */						\
  cli();								\
  start_bh_atomic();							\
  do_IRQ(nr, 0);		/* XXX pt_regs is NULL! */		\
  cli();								\
  end_bh_atomic();							\
  execute_bottom_halfs();						\
  sti();								\
  __cli_tame();								\
}

BUILD_TIMER_IRQ(FIRST,0,0x01)
#define fast_IRQ0_interrupt IRQ0_interrupt
#define bad_IRQ0_interrupt IRQ0_interrupt

BUILD_IRQ(FIRST,1,0x02)
BUILD_IRQ(FIRST,2,0x04)
BUILD_IRQ(FIRST,3,0x08)
BUILD_IRQ(FIRST,4,0x10)
BUILD_IRQ(FIRST,5,0x20)
BUILD_IRQ(FIRST,6,0x40)
BUILD_IRQ(FIRST,7,0x80)
BUILD_IRQ(SECOND,8,0x01)
BUILD_IRQ(SECOND,9,0x02)
BUILD_IRQ(SECOND,10,0x04)
BUILD_IRQ(SECOND,11,0x08)
BUILD_IRQ(SECOND,12,0x10)
BUILD_IRQ(SECOND,13,0x20)
BUILD_IRQ(SECOND,14,0x40)
BUILD_IRQ(SECOND,15,0x80)

/* Pointers to the low-level handlers: first the general ones, then
   the fast ones, then the bad ones. */

static void (* const interrupt[16])(void) = {
	IRQ0_interrupt, IRQ1_interrupt, IRQ2_interrupt, IRQ3_interrupt,
	IRQ4_interrupt, IRQ5_interrupt, IRQ6_interrupt, IRQ7_interrupt,
	IRQ8_interrupt, IRQ9_interrupt, IRQ10_interrupt, IRQ11_interrupt,
	IRQ12_interrupt, IRQ13_interrupt, IRQ14_interrupt, IRQ15_interrupt
};

static void (* const fast_interrupt[16])(void) = {
	fast_IRQ0_interrupt, fast_IRQ1_interrupt,
	fast_IRQ2_interrupt, fast_IRQ3_interrupt,
	fast_IRQ4_interrupt, fast_IRQ5_interrupt,
	fast_IRQ6_interrupt, fast_IRQ7_interrupt,
	fast_IRQ8_interrupt, fast_IRQ9_interrupt,
	fast_IRQ10_interrupt, fast_IRQ11_interrupt,
	fast_IRQ12_interrupt, fast_IRQ13_interrupt,
	fast_IRQ14_interrupt, fast_IRQ15_interrupt
};

static void (* const bad_interrupt[16])(void) = {
	bad_IRQ0_interrupt, bad_IRQ1_interrupt,
	bad_IRQ2_interrupt, bad_IRQ3_interrupt,
	bad_IRQ4_interrupt, bad_IRQ5_interrupt,
	bad_IRQ6_interrupt, bad_IRQ7_interrupt,
	bad_IRQ8_interrupt, bad_IRQ9_interrupt,
	bad_IRQ10_interrupt, bad_IRQ11_interrupt,
	bad_IRQ12_interrupt, bad_IRQ13_interrupt,
	bad_IRQ14_interrupt, bad_IRQ15_interrupt
};


/* interrupt vectors */

static void (*irq_vecs[16])(void);

static inline 
void set_intr_vec(unsigned irq, void (*handler)(void))
{
  irq_vecs[irq] = handler;
}

/* irq handler structures (from arch/i386/kernel/irq.c; changed
   set_intr_gate() to set_intr_vec()) */

int get_irq_list(char *buf)
{
	int i, len = 0;
	struct irqaction * action;

	for (i = 0 ; i < 16 ; i++) {
		action = irq_action[i];
		if (!action) 
			continue;
		len += sprintf(buf+len, "%2d: %8d %c %s",
			i, kstat.interrupts[i],
			(action->flags & SA_INTERRUPT) ? '+' : ' ',
			action->name);
		for (action=action->next; action; action = action->next) {
			len += sprintf(buf+len, ",%s %s",
				(action->flags & SA_INTERRUPT) ? " +" : "",
				action->name);
		}
		len += sprintf(buf+len, "\n");
	}		
	return len;
}

int setup_x86_irq(int irq, struct irqaction * new)
{
	int shared = 0;
	struct irqaction *old, **p;
	unsigned long flags;

	p = irq_action + irq;
	if ((old = *p) != NULL) {
		/* Can't share interrupts unless both agree to */
		if (!(old->flags & new->flags & SA_SHIRQ))
			return -EBUSY;

		/* Can't share interrupts unless both are same type */
		if ((old->flags ^ new->flags) & SA_INTERRUPT)
			return -EBUSY;

		/* add new interrupt at end of irq queue */
		do {
			p = &old->next;
			old = *p;
		} while (old);
		shared = 1;
	}

	if (new->flags & SA_SAMPLE_RANDOM)
		rand_initialize_irq(irq);

	save_flags(flags);
	cli();
	*p = new;

	if (!shared) {
		if (new->flags & SA_INTERRUPT)
			set_intr_vec(irq,fast_interrupt[irq]);
		else
			set_intr_vec(irq,interrupt[irq]);
		unmask_irq(irq);
	}
	restore_flags(flags);
	return 0;
}

int request_irq(unsigned int irq, 
		void (*handler)(int, void *, struct pt_regs *),
		unsigned long irqflags, 
		const char * devname,
		void *dev_id)
{
	int retval;
	struct irqaction * action;

	if (irq > 15)
		return -EINVAL;
	if (!handler)
		return -EINVAL;

	action = (struct irqaction *)kmalloc(sizeof(struct irqaction), GFP_KERNEL);
	if (!action)
		return -ENOMEM;

	action->handler = handler;
	action->flags = irqflags;
	action->mask = 0;
	action->name = devname;
	action->next = NULL;
	action->dev_id = dev_id;

	retval = setup_x86_irq(irq, action);

	if (retval)
		kfree(action);
	return retval;
}
		
void free_irq(unsigned int irq, void *dev_id)
{
	struct irqaction * action, **p;
	unsigned long flags;

	if (irq > 15) {
		printk("Trying to free IRQ%d\n",irq);
		return;
	}
	for (p = irq + irq_action; (action = *p) != NULL; p = &action->next) {
		if (action->dev_id != dev_id)
			continue;

		/* Found it - now free it */
		save_flags(flags);
		cli();
		*p = action->next;
		if (!irq[irq_action]) {
			mask_irq(irq);
			set_intr_vec(irq,bad_interrupt[irq]);
		}
		restore_flags(flags);
		kfree(action);
		return;
	}
	printk("Trying to free free IRQ%d\n",irq);
}


/* irq probing (from arch/i386/kernel/irq.c) */

unsigned long probe_irq_on (void)
{
	unsigned int i, irqs = 0, irqmask;
	unsigned long delay;

	/* first, enable any unassigned irqs */
	for (i = 15; i > 0; i--) {
		if (!irq_action[i]) {
			enable_irq(i);
			irqs |= (1 << i);
		}
	}

	/* wait for spurious interrupts to mask themselves out again */
	for (delay = jiffies + HZ/10; delay > jiffies; )
		/* about 100ms delay */;

	/* now filter out any obviously spurious interrupts */
	irqmask = (((unsigned int)inb(0xA1))<<8) | (unsigned int)inb(0x21);
#ifdef DEBUG
	printk("probe_irq_on: probing for irq vec 0x%x\n", irqs & ~irqmask);
#endif
	return irqs & ~irqmask;
}

int probe_irq_off (unsigned long irqs)
{
	unsigned int i, irqmask;

	irqmask = (((unsigned int)inb(0xA1))<<8) | (unsigned int)inb(0x21);
#ifdef DEBUG
	printk("probe_irq_off: irqs=0x%04x irqmask=0x%04x\n", irqs, irqmask);
#endif
	irqs &= irqmask;
#ifdef DEBUG
	printk("probe_irq_off: got irq vec 0x%lx\n", irqs);
#endif

	if (!irqs)
		return 0;
	i = ffz(~irqs);
	if (irqs != (irqs & (1 << i)))
		i = -i;
	return i;
}


/* low-level timer-interrupt handler thread */
static void timer_irq_thread(void)
{
  /* we can't grab the timer interrupt 0, as L4 needs it for itself.
     So we try to wake up every 1000/HZ = 10 ms. */

#if (HZ != 100)
# error "adapt me...  This code only works for HZ == 100"
#endif

  dword_t dummy;
  l4_msgdope_t dummydope;
  unsigned long total, newtotal;
  unsigned long totallost;

  extern unsigned long lost_ticks; /* in kernel/sched.c */

  const unsigned long jiffie_usecs = 1000000L / HZ;
  
/*   set_default_idt(); */

  totallost = 0;
  total = l4_kernel_info->clock;

  __cli_tame();			/* we run with irq disabled by default */

  /* OK, now get ready to take irq handlers */
  irq_action[TIMER_IRQ] = 0;

  for (;;)
    {
#ifdef SANITY
      irqs_in_progress &= ~(1 << TIMER_IRQ);
#endif

      l4_i386_ipc_receive(L4_NIL_ID, 0,
			  &dummy, &dummy,
			  L4_IPC_TIMEOUT(0,0,4*39,12,0,0), /* ca. 10 ms */
			  &dummydope);
#ifdef SANITY
      irqs_in_progress |= (1 << TIMER_IRQ);
#endif

      /* synchronize jiffies/lost_ticks with real-time clock */
      newtotal = l4_kernel_info->clock;

      totallost += (newtotal - total); /* usecs we slept */
      total = newtotal;

      if (totallost < jiffie_usecs)
	continue;		/* just sleep a little longer in order
				   to prevent negative jiffie updates */
      totallost -= jiffie_usecs; /* account for irq handler's
				    update of jiffies */
      if (totallost > jiffie_usecs)
	{
	  unsigned long jiffies_catchup = totallost / jiffie_usecs;

	  totallost -= jiffies_catchup * jiffie_usecs;
	  jiffies += jiffies_catchup;
	  lost_ticks += jiffies_catchup;
	}
/* #define PIPE_LATENCY */
#ifdef PIPE_LATENCY
      if (current->comm[0]!='_')
	{
#endif
      /* call irq handler */
      mb();			/* "memory barrier" so that the next
				   statement will always re-read the
				   handler info from the irq_vecs
				   field */
      (irq_vecs[TIMER_IRQ])();
      mb();
#ifdef PIPE_LATENCY
	}
#endif

    }
}

/* low-level interrupt handler thread; must be re-entrant 

   Note: irq handlers expect not to be interrupted except by other
   interrupts.  That's why, this thread needs to run with a relatively
   high priority. */

static void irq_thread(unsigned irq)
{
  dword_t dummy, d1;
  l4_msgdope_t dummydope;
  int code;
  l4_threadid_t irq_th;

/*   set_default_idt(); */

  /* first, register to the irq */

  /* in case we're running under a RMGR, fetch the irq nr first from it */
  d1 = rmgr_get_irq(irq);
  if (d1 != 0)
    {
      /* the supervisor thread exists and sent a negative response */
      printk("irq_thread: RMGR denied irq %u: code 0x%x\n", irq, d1);
      goto error;
    }

  irq_th.lh.low = irq + 1;
  irq_th.lh.high = 0;

  code = l4_i386_ipc_receive(irq_th,
			     0, /* receive descriptor */
			     &dummy,
			     &dummy,
			     L4_IPC_TIMEOUT(0,0,0,1,0,0), /* rcv = 0,
							     snd = inf */
			     &dummydope);
  if (code != L4_IPC_RETIMEOUT)
    {
      printk("irq_thread: can't register to irq %u: error 0x%x\n", irq, 
	     (unsigned) code);

    error:
      /* sleep forever */
      l4_i386_ipc_receive(L4_NIL_ID, 0,
			  &dummy, &dummy,
			  L4_IPC_NEVER,
			  &dummydope);
#ifdef SANITY
      panic("irq_thread: sleep forever returned!");
#endif
    }

  /* now wait for irq messages and handle them appropriately */

  __cli();			/* we run with irq disabled by default */

  /* OK, now get ready to take irq handlers */
  irq_action[irq] = 0;

  for (;;) 
    {
#ifdef SANITY
      irqs_in_progress &= ~(1 << irq);
#endif

#ifdef MEASURE_IRQ_PATH
      read_time(&irq_stop);
#endif     
      code = l4_i386_ipc_receive(irq_th,
				 0, /* receive descriptor */
				 &dummy,
				 &dummy,
				 L4_IPC_NEVER,
				 &dummydope);
      if (code)
	{
	  printk("irq_thread: irq %u (%x:%x) receive failed, code = 0x%x", 
		 irq, irq_th.lh.high, irq_th.lh.low,
		 (unsigned) code);
	  enter_kdebug("receive from intr failed");
	}
      else
	{
#ifdef MEASURE_IRQ_PATH
	  read_time(&irq_start);
#endif
#ifdef SANITY
	  irqs_in_progress |= (1 << irq);
#endif
	  
	  mb();			/* "memory barrier" so that the next
				   statement will always re-read the
				   handler info from the irq_vecs
				   field */
	  (irq_vecs[irq])();	/* call irq handler */
	  mb();
	}
    }
}


/* initialize IRQ system */

extern unsigned interrupt_stacks;

void init_IRQ(void)
{
  l4_sched_param_t schedparam;
  unsigned stack_page = (unsigned)&interrupt_stacks;

  unsigned i;
  unsigned *sp;
  dword_t dummy, routine;

  l4_threadid_t preempter, pager, my_preempter, my_pager;

  /* get thread parameters */
  l4_threadid_t me = l4_myself();
  my_preempter = L4_INVALID_ID;
  my_pager = L4_INVALID_ID;
  l4_thread_ex_regs(me, (dword_t) -1, (dword_t) -1,
		    &my_preempter,
		    &my_pager,
		    &dummy,
		    &dummy,
		    &dummy);

#ifndef GET_RID_OF_BH_THREAD
#ifdef BH_THREAD
  /* start bottom-half thread */

  /* save thread id */
  bh_th_id = me;
  bh_th_id.id.lthread = LTHREAD_NO_BOTTOM_HALF;

  /* allocate stack page and space for the thread id*/
  sp = (unsigned *) (stack_page + PAGE_SIZE) - sizeof(l4_threadid_t); 

  /* put thread id to top of stack */
  put_l4_id_to_stack((unsigned)sp, bh_th_id);
  *(unsigned *)stack_page = STACK_MAGIC;

  /* push parameters on the stack */
  *(--sp) = 0;			/* fake return address */


  /* create thread */
  preempter = my_preempter;
  pager = my_pager;
  l4_thread_ex_regs(bh_th_id,
		    (dword_t) bottom_half_thread, /* eip */
		    (dword_t) sp, /* esp */
		    &preempter, /* preempter */
		    &pager,	/* pager */
		    &dummy,	/* old_flags */
		    &dummy,	/* old_eip */
		    &dummy);	/* old_esp */

#ifdef USE_PRIOS
  rmgr_set_prio(bh_th_id, PRIO_BOTTOM_HALF);
#endif
#endif
#endif

  /* set up interrupt vectors, and start interrupt threads */
  for (i = 0; i < 16 ; i++)
    {
      l4_threadid_t newthid;

      set_intr_vec(i, bad_interrupt[i]);
      
      /* create thread */
      newthid = me;
      newthid.id.lthread = LTHREAD_NO_IRQ(i);

      /* allocate stack page and space for the thread id*/
      stack_page += PAGE_SIZE;
      sp = (unsigned *) (stack_page + PAGE_SIZE) - sizeof(l4_threadid_t); 
            
      /* put thread id on bottom of stack */
      put_l4_id_to_stack((unsigned)sp, newthid);
      *(unsigned *)stack_page = STACK_MAGIC;
      

      /* push parameters on the stack */
#ifdef SANITY
      *(--sp) = newthid.lh.low;	/* push the thread id */
      *(--sp) = newthid.lh.high;
#endif

      if (i == TIMER_IRQ)	/* must be handled differently */
	{
	  routine = (dword_t) timer_irq_thread;
	}
      else
	{
	  *(--sp) = i;

	  routine = (dword_t) irq_thread;
	}

      *(--sp) = 0;		/* fake return address */

      preempter = my_preempter;
      pager = my_pager;

      l4_thread_ex_regs(newthid,
			routine, /* eip */
			(dword_t) sp, /* esp */
			&preempter, /* preempter */
			&pager, /* pager */
			&dummy, /* old_flags */
			&dummy, /* old_eip */
			&dummy); /* old_esp */

#ifdef USE_PRIOS
      /* set prio */
      rmgr_set_prio(newthid, PRIO_IRQ(i));
#endif
  
      /* give the new thread some time to initialize.  this prevents
	 races because the new thread runs with high priority (we
	 won't preempt it) */
      l4_thread_switch(newthid);
    }
#ifdef USE_PRIOS
  rmgr_set_prio(l4_myself(), PRIO_KERNEL);
#endif

  request_region(0x20,0x20,"pic1");
  request_region(0xa0,0x20,"pic2");
  setup_x86_irq(2, &irq2);
  setup_x86_irq(13, &irq13);
}
