#include <linux/module.h>
#include <linux/smp.h>
#include <linux/user.h>
#include <linux/elfcore.h>
#include <asm/segment.h>

extern void dump_thread(struct pt_regs *, struct user *);
extern int dump_fpu(elf_fpregset_t *);

static struct symbol_table arch_symbol_table = {
#include <linux/symtab_begin.h>
	/* platform dependent support */
	X(dump_thread),
	X(dump_fpu),
	XNOVERS(down_failed),
	XNOVERS(up_wakeup),
	X(memcpy_tofs),
	X(memcpy_fromfs),
	X(put_user_long),
	X(put_user_word),
	X(put_user_byte),
	X(get_user_long),
	X(get_user_word),
	X(get_user_byte),
#include <linux/symtab_end.h>
};

void arch_syms_export(void)
{
	register_symtab(&arch_symbol_table);
}
