#include <linux/sched.h>
#include <asm/resource.h>

#include <l4/syscalls.h>

void l4_get_utime(struct task_struct *p)
{
  l4_sched_param_t foo;
  l4_threadid_t foo_id = L4_INVALID_ID;

#ifndef BROKEN_L4_SCHEDULE
  p->utime = (unsigned long) 
    l4_thread_schedule(p->tss.user_thread_id, (dword_t) -1,
		       &foo_id, &foo_id, &foo)
    / (1000000 / HZ);
#else
  p->utime = 0;
#endif
}
