#include <asm/segment.h>
#include <asm/page.h>

#include "../include/l4_memory.h"

#define MIN(a,b) (((a)<(b))?(a):(b))

/* #define DEBUG_MEMCPY_TOFS */
extern inline
void
__memcpy_tofs(void * to, const void * from, unsigned long n)
{
  unsigned long page, offset;

#ifdef DEBUG_MEMCPY_TOFS
  printk("(%x.%x)__memcpy_tofs to: %p, from: %p, len: %lx\n", 
	 l4_myself().id.task, l4_myself().id.lthread, to, from, n);
#endif 
  macro_parse_ptabs_write(to, page, offset);
  if (page)
    {
#ifdef DEBUG_MEMCPY_TOFS
      printk("(%x.%x)    __memcpy_tofs writing to: %lx\n", 
	     l4_myself().id.task, l4_myself().id.lthread, (page + offset));
#endif 
      memcpy((void *)(page + offset), from, n);
    }
  else
    {
      request_page_writeable((unsigned long)to, __pte(offset));
      macro_parse_ptabs_write(to, page, offset);
      if (page)
	{
#ifdef DEBUG_MEMCPY_TOFS
	  printk("(%x.%x)    __memcpy_tofs writing to: %lx\n", 
		 l4_myself().id.task, l4_myself().id.lthread,(page + offset));
#endif 
	  memcpy((void *)(page + offset), from, n);
	}
      else
	panic("No page in memcpy_tofs\n");
    }
}
#undef DEBUG_MEMCPY_TOFS
void 
memcpy_tofs(void * to, const void * from, unsigned long n)
{
  unsigned long copy_size = (unsigned long)to & ~PAGE_MASK;

#ifdef DEBUG_MEMCPY_TOFS
  printk("(%x.%x)memcpy_tofs called from: %lx to: %p, from: %p, len: %lx\n", 
	 l4_myself().id.task, l4_myself().id.lthread, 
	 __builtin_return_address(0), to, from, n);
#endif 
  if (copy_size)
    {
      copy_size = MIN(PAGE_SIZE - copy_size, n);
      __memcpy_tofs(to, from, copy_size);
      n -= copy_size;
    }
  while (n)
    {
      from +=copy_size;
      to += copy_size;
      copy_size = MIN(PAGE_SIZE, n);
      __memcpy_tofs(to, from, copy_size);
      n -= copy_size;
    }
}
/* #define DEBUG_MEMCPY_FROMFS */
extern inline
void
__memcpy_fromfs(void * to, const void * from, unsigned long n)
{
  unsigned long page, offset;

#ifdef DEBUG_MEMCPY_FROMFS
  printk("(%x.%x)__memcpy_fromfs to: %p, from: %p, len: %lx\n", 
	 l4_myself().id.task, l4_myself().id.lthread, to, from, n);
#endif 
  macro_parse_ptabs_read(from, page, offset);
  if (page)
    {
#ifdef DEBUG_MEMCPY_FROMFS
      printk("(%x.%x)    __memcpy_fromfs reading from: %lx\n", 
	     l4_myself().id.task, l4_myself().id.lthread, (page + offset));
#endif 
      memcpy(to, (void *)(page + offset), n);
    }
  else
    {
      request_page_readable((unsigned long)from);
      macro_parse_ptabs_read(from, page, offset);
      if (page)
	{
#ifdef DEBUG_MEMCPY_FROMFS
	  printk("(%x.%x)    __memcpy_fromfs reading from: %lx\n", 
		 l4_myself().id.task, l4_myself().id.lthread,(page + offset));
#endif 
	  memcpy(to, (void *)(page + offset), n);
	}
      else
	panic("No page in memcpy_fromfs\n");
    }
}
#undef DEBUG_MEMCPY_FROMFS
void 
memcpy_fromfs(void * to, const void * from, unsigned long n)
{
  unsigned long copy_size = (unsigned long)from & ~PAGE_MASK;

#ifdef DEBUG_MEMCPY_FROMFS
  printk("(%x.%x)memcpy_fromfs called from: %lx to: %p, from: %p, len: %lx\n", 
	 l4_myself().id.task, l4_myself().id.lthread, 
	 __builtin_return_address(0), to, from, n);
#endif 
  if (copy_size)
    {
      copy_size = MIN(PAGE_SIZE - copy_size, n);
      __memcpy_fromfs(to, from, copy_size);
      n -= copy_size;
    }
  while (n)
    {
      from +=copy_size;
      to += copy_size;
      copy_size = MIN(PAGE_SIZE, n);
      __memcpy_fromfs(to, from, copy_size);
      n -= copy_size;
    }
}

