/* $id: task.c,v 1.25 1996/07/02 18:28:26 hohmuth exp $ */

#include <l4/types.h>
#include <l4/ipc.h>
#include <l4/syscalls.h>

#include <linux/sched.h>

#include <asm/bitops.h>

#include "../include/config.h"
#include "../include/l4_memory.h"
#include "../include/exclpage.h"
#include "../include/linuxipc.h"
#include "../include/rmgr.h"
#include "../include/debug.h"

/* we implement this interface: */
#include "../include/task.h"

#ifdef USE_SUPER_CLAN
# define l4_task_new rmgr_task_new
#endif

static void task_no_init(void);

int l4_task_version = 0;
static int stack_after_special_init_task[128];
l4_taskid_t template_id;

#define IDLE_STACK_SIZE 50

static int idle_stack[IDLE_STACK_SIZE];
void
idle_loop(void)
{
  int count = 0;
  while(1) {
    count &= 3;
    *((char *)0xb0f9e) = "|/-\\"[count++];
  }
}

extern struct task_struct init_task;


void
finish_start_linux_server_thread(l4_threadid_t __server_id, 
				 dword_t __server_eip, dword_t __server_esp)
{
#if LTHREAD_NO_LINUX_SERVER == 0
#error check thread number of linux server
#endif

  l4_msgdope_t result;
  l4_threadid_t pager = L4_INVALID_ID, preempter = L4_INVALID_ID;
  dword_t dummy;
  l4_thread_ex_regs(l4_myself(), 
		    (dword_t) -1, (dword_t)-1,
		    &preempter, &pager, &dummy, &dummy, &dummy);
  
  l4_thread_ex_regs(__server_id, 
		    __server_eip, __server_esp,
		    &preempter, &root_pager_id, &dummy, &dummy, &dummy);
  
  /* #define IDLE_THREAD */
#ifdef IDLE_THREAD
  {
    l4_threadid_t idle_id = root_pager_id;
    l4_threadid_t pager = L4_INVALID_ID, preempter = L4_INVALID_ID;
    dword_t dummy;
    idle_id.id.lthread = 1;
    l4_thread_ex_regs(l4_myself(), 
		      (dword_t) -1, (dword_t)-1,
		      &preempter, &pager, &dummy, &dummy, &dummy);
    
    l4_thread_ex_regs(idle_id, 
		      (dword_t) idle_loop, (dword_t)idle_stack+IDLE_STACK_SIZE,
		      &preempter, &pager, &dummy, &dummy, &dummy);
    rmgr_set_prio(idle_id, 1);
  }
#endif

#if 1
  /* start forwarding short messages across clan border */
  {
    void *desc;
    int err;
    l4_threadid_t t, d;
    dword_t d1, d2;
    dword_t scratch = 0x40000000; /* XXX hardcoded! */

    for (;;)
      {
	err = l4_i386_ipc_chief_wait(&t, &d, 
				     L4_IPC_MAPMSG(scratch, 30),
				     &d1, &d2, 
				     L4_IPC_NEVER, &result);
	
	herc_printf("redir: received msg from %x.%x for %x.%x: "
		    "result=0x%x, d1=0x%x, d2=0x%x\n",
		    t.lh.high, t.lh.low, d.lh.high, d.lh.low,
		    result.msgdope, d1, d2);
	
	while (!err && L4_IPC_MSG_REDIRECTED(result))
	  {
	    /* we received a request here */
	    /* was a flexpage in there? */
	    if (l4_ipc_fpage_received(result))
	      {
		desc = L4_IPC_SHORT_FPAGE;

		/* make sure we grant the mapping, flushing it from
                   our own address space */
		d2 |= 1;
	      }
	    else
	      desc = L4_IPC_SHORT_MSG;

	    desc = (void *)((unsigned)desc | L4_IPC_DECEIT);

	    herc_printf("redir: forwarding msg: "
			"desc=0x%x, d1=0x%x, d2=0x%x\n",
			(unsigned) desc, d1, d2);

	    /* send it on */
	    err = l4_i386_ipc_chief_reply_and_wait(d, t,
						   desc, d1, d2,
						   &t, &d, 
						   L4_IPC_MAPMSG(scratch, 30),
						   &d1, &d2,
						   L4_IPC_NEVER, &result);

	    herc_printf("redir: received msg from %x.%x for %x.%x: "
			"result=0x%x, d1=0x%x, d2=0x%x\n",
			t.lh.high, t.lh.low, d.lh.high, d.lh.low,
			result.msgdope, d1, d2);
	
	  }

	herc_printf("redir: ipc error, result was 0x%x\n", result.msgdope);

	if (l4_ipc_fpage_received(result))
	  l4_fpage_unmap(l4_fpage(scratch, 30, 0, 0).fpage, 
			 L4_FP_FLUSH_PAGE|L4_FP_ALL_SPACES);
      }
  }
#else  /* old code: just sleep forever */
  l4_i386_ipc_receive(L4_NIL_ID, L4_IPC_SHORT_MSG, &dummy, &dummy, 
		      L4_IPC_NEVER, &result);
  kd_display("ipc result: ");
  outhex32(result.msgdope);
  enter_kdebug("wakeup after sleep forever");
#endif
}



l4_threadid_t kernel_thread_id;
unsigned long kernel_taskno;
void 
start_linux_server_thread(dword_t eip, dword_t esp)
{
  dword_t dummy, i;
  static dword_t __server_eip, __server_esp;
  static l4_threadid_t __server_id;
  
  task_no_init();

  __server_id = l4_myself();
  __server_id.id.lthread =  LTHREAD_NO_LINUX_SERVER;
  __server_eip = eip;
  __server_esp = esp;

  kernel_taskno = __server_id.id.task*4;
  kernel_thread_id = __server_id;
  template_id = __server_id;
  template_id.id.chief = __server_id.id.task;
  template_id.id.nest++;

  put_l4_id_to_stack(esp, __server_id);

#ifdef USE_SMALL_SPACES
  /* put this task (the linux server task) into a small address space */
  rmgr_set_small_space(__server_id, 1);
#endif

  /* switch to new stack, since the newly created service thread has
     to continue on our stack */

  asm volatile("movl %0, %%esp\n\t" 
	       : /* No output */ 
	       : "r" (&stack_after_special_init_task[126])
	       );

  finish_start_linux_server_thread(__server_id, __server_eip, __server_esp);
  enter_kdebug("returned from finish_start_linux_server_thread");
}

/* task number management */
#define BITVEC_SIZE (TASK_NO_MAX - TASK_NO_MIN + 1)
#define VEC_SIZE    (BITVEC_SIZE / sizeof(unsigned) + 1)

static unsigned task_used[VEC_SIZE] 
  = {0, };

int task_no_alloc(void) 
{
  int n = find_first_zero_bit(task_used, BITVEC_SIZE);

  if (n > BITVEC_SIZE)
    return -1;

  set_bit(n, task_used);
  if (++l4_task_version > 127)
    l4_task_version = 0;

  return TASK_NO_MIN + n;
}

int task_no_free(int n)
{
  n -= TASK_NO_MIN;
  if (n < 0 || n >= BITVEC_SIZE)
    return -1;

  if (! change_bit(n, task_used))
    return -1;

  return 0;
}

static void task_no_init(void)
{
  int err;
  unsigned i;

  if (! have_rmgr)		/* do we have a supervisor? */
    return;

  for (i = TASK_NO_MIN; i <= TASK_NO_MAX; i++)
    {
      err = rmgr_get_task(i);

      if (err != 0)
	set_bit(i, task_used);	/* can't allocate this task number */
    }
}


/*
 * default exception handlers
 */
/*
int_handler_t default_int_handler_array[NUM_DEFAULT_INT_HANDLER] =
{
  def_int_entry0,
  def_int_entry1,
  def_int_entry2,
  def_int_entry3,
  def_int_entry4,
  def_int_entry5,
  def_int_entry6,
  def_int_entry7,
  def_int_entry8,
  def_int_entry9,
  def_int_entry10,
  def_int_entry11,
  def_int_entry12,
  def_int_entry13,
  def_int_entry14,
  def_int_entry15,
  def_int_entry16,
  def_int_entry17,
  def_int_entry18,
  def_int_entry19
};
*/
int_handler_t default_int_handler_array[NUM_DEFAULT_INT_HANDLER] =
{
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
};

void 
set_idt(idt_entry_t *idt, int_handler_t *int_handler, int num)
{
  int i;

  /* XXX Do we need a seperate idt_descr for each idt ? */
  idt_descr_t idt_descr = {num * 8 - 1, (unsigned long)idt};
  idt_entry_t dummy = { 0, 0, 0, TRAPGATE, USERLEVEL, SEGPRESENT, 0 }; 

#ifdef DEBUG
  kd_display("\r\nset_idt: idt address: ");
  outhex32(idt);
  enter_kdebug("set_idt");
#endif

  for (i=0; i<num; i++)
    {
      dummy.int_handler_low  =  (long)int_handler[i];
      dummy.int_handler_high = ((long)int_handler[i]) >> 16;
      idt[i] = dummy;
    }
  asm("lidt	(%%eax)\n\t" : : "a" (&idt_descr)); 
}

static idt_entry_t default_idt[NUM_DEFAULT_INT_HANDLER];
void set_default_idt(void)
{
/*   set_idt(default_idt, default_int_handler_array, NUM_DEFAULT_INT_HANDLER);   */
}

void default_int_handler_func(exception_frame_t frame)
{
  panic("exception %x triggered at eip: %x with error %x\n"
	"eax: %x, ebx: %x, ecx: %x, edx: %x\n"
	"esi: %x, edi: %x, ebp: %x, esp: %x\n",
	frame.number, frame.eip, frame.error, 
	frame.eax, frame.ebx, frame.ecx, frame.edx, 
	frame.esi, frame.edi, frame.ebp, (unsigned int)&frame.stack_top);
}
