/* $Id: segment.h,v 1.7 1997/07/29 12:11:49 hohmuth Exp $ */

#ifndef __ASM_L4_I386_SEGMENT_H
#define __ASM_L4_I386_SEGMENT_H

#ifndef __ASSEMBLY__

#include <linux/posix_types.h>
#include <asm/page.h>
#include <linux/sched.h>

#define USER_VM_OFFSET (0x20000000UL) /* .5 MB */

extern unsigned long current_pdir;
extern pgd_t swapper_pg_dir[1024];

/* prototypes and macros */

void
put_user_byte_slow_path(unsigned char val, unsigned long address);
unsigned char
get_user_byte_slow_path(unsigned long address);
void
put_user_word_slow_path(unsigned short val, unsigned long address);
unsigned short 
get_user_word_slow_path(unsigned long address);
void
put_user_long_slow_path(unsigned long val, unsigned long address);
unsigned long 
get_user_long_slow_path(unsigned long address);
void 
memcpy_tofs(void * to, const void * from, unsigned long n);
void 
memcpy_fromfs(void * to, const void * from, unsigned long n);

#define get_fs_byte(addr) get_user_byte((unsigned char *)(addr))
#define get_fs_word(addr) get_user_word((unsigned short *)(addr))
#define get_fs_long(addr) get_user_long((unsigned long *)(addr))
#define put_fs_byte(x,addr) put_user_byte((x),(unsigned char *)(addr))
#define put_fs_word(x,addr) put_user_word((x),(unsigned short *)(addr))
#define put_fs_long(x,addr) put_user_long((x),(unsigned long *)(addr))

#define str(x) _str(x)
#define _str(x) #x

#ifdef ENABLE_CHECK_GCC_BUG
#define CHECK_GCC_BUG							      \
      "subl	%%ebx, %%ebx	\n\t"					      \
      "subl	%%eax, %%eax	\n\t"					      \
      "orl	%1, %1		\n\t"					      \
      "je	1f		\n\t"
#else
#define CHECK_GCC_BUG ""
#endif


#define PARSE_PTABS_PRE()						      \
  asm(									      \
      CHECK_GCC_BUG							      \
      "movl	%1, %%eax		\n\t" 				      \
      "movl	%1, %%ebx		\n\t" /* mov address to eax/ebx */    \
      "#			/* 1 */	\n\t"				      \
									      \
      "shrl	$22, %%eax		\n\t" /* extract pdir index */	      \
      "movl " SYMBOL_NAME_STR(current_pdir) ", %0 \n\t" /*load pdir address*/ \
      "#			/* 2 */	\n\t"				      \
									      \
      "shrl	$12, %%ebx		\n\t" /* extract ptab offset (1. remove offset within page) */	      						     \
      "andl	$0xfff, %1		\n\t" /* extract offset within page */\
      "#			/* 3 */	\n\t"				      \
									      \
      "movl	(%0, %%eax, 4), %0	\n\t" /* load ptab address */	      \
      "andl	$0x3ff, %%ebx		\n\t" /* extract ptab offset */	      \
      "#			/* 4 */	\n\t"				      \
					      /* (2. remove pdir index) */    \
      "movl	%0, %%eax		\n\t" 				      \
      "andl	$0xfffff000, %0 	\n\t" 				      \
      "#			/* 5 */	\n\t"				      \
									      \
      "testb	$1, %%al		\n\t"				      \
      "jz	3f			\n\t" /* ptab present ? */	      \
      "#			/* 6 */	\n\t"				      \
									      \
      "movl	(%0, %%ebx, 4), %%eax	\n\t"

#define PARSE_PTABS_READ()						      \
      "#			/* 7 */	\n\t"				      \
									      \
      "testb	$1, %%al		\n\t"				      \
      "jz	3f			\n\t" /* page present ? */	      \
      "#			/* 8 */	\n\t"				      \
									      \
      "orl	$"str(_PAGE_ACCESSED)", (%0, %%ebx, 4)	\n\t"

#define PARSE_PTABS_WRITE()						      \
      "#			/* 7 */	\n\t"				      \
									      \
      "andb	$3, %%al		\n\t"				      \
      "cmpb	$3, %%al		\n\t"				      \
      "#			/* 8 */	\n\t"				      \
									      \
      "jnz	3f			\n\t" /* page writable ? */	      \
      "#			/* 9 */	\n\t"				      \
									      \
      "orl	$("str(_PAGE_DIRTY)"+"str(_PAGE_ACCESSED)"),(%0, %%ebx, 4)\n\t"


#define PARSE_PTABS_POST(address, page, offset)				      \
      "andl	$0xfffff000, %%eax	\n\t"				      \
      "#			/* r9/w10 */	\n\t"			      \
									      \
      "movl	%%eax, %0		\n\t"				      \
      "jmp	4f			\n\t"				      \
      "#			/* r10/w11 */	\n\t"			      \
									      \
      "1:\n\t"								      \
      "int	$3			\n\t"				      \
      "jmp	2f			\n\t"				      \
      ".ascii	\"gcc\"			\n\t"				      \
      "2:\n\t"								      \
									      \
      "3:\n\t"								      \
      "movl %%eax, %1			\n\t"				      \
      "subl %0, %0			\n\t"				      \
									      \
      "4:\n\t"								      \
      : 								      \
      "&=r" (page), /* page table entry */				      \
      "=r" (offset) /* page offset */					      \
      : 								      \
      "1" (address) 							      \
      :									      \
      "bx", "ax"							      \
      );

#define macro_parse_ptabs_write(address, page, offset)\
  PARSE_PTABS_PRE()\
  PARSE_PTABS_WRITE()\
  PARSE_PTABS_POST(address, page, offset)

#define macro_parse_ptabs_read(address, page, offset)\
  PARSE_PTABS_PRE()\
  PARSE_PTABS_READ()\
  PARSE_PTABS_POST(address, page, offset)

/* #define BUILD_REALLY */
#ifndef BUILD_REALLY

#define BUILD_USER_ACCESS(name, type)					      \
void									      \
put_user_##name##_pf(unsigned  type val, type * address, pte_t pte);	      \
void									      \
put_user_##name(unsigned  type val, type * address);			      \
unsigned type 								      \
get_user_##name##_pf(type * address);					      \
unsigned type 								      \
get_user_##name(type * address);

#else

#define BUILD_USER_ACCESS(name, type)					      \
void									      \
put_user_##name##_pf(unsigned  type val, type * address, pte_t pte);	      \
extern inline void							      \
put_user_##name(unsigned  type val, type * address)			      \
{									      \
  unsigned long page, offset;						      \
  if ( (sizeof(unsigned type) == 1) || 					      \
       ( ((unsigned long)address & ~PAGE_MASK) <= 			      \
         (PAGE_SIZE - sizeof(unsigned type) )) )			      \
    {									      \
      macro_parse_ptabs_write(address, page, offset);			      \
      if (page)								      \
	*((unsigned type *)(page + offset)) = val;			      \
      else								      \
	put_user_##name##_pf(val, address, __pte(offset));		      \
    }									      \
  else									      \
    put_user_##name##_slow_path(val, (unsigned long) address);		      \
}									      \
unsigned type 								      \
get_user_##name##_pf(type * address);					      \
extern inline unsigned type 						      \
get_user_##name(type * address)						      \
{									      \
  unsigned long page, offset;						      \
  if ( (sizeof(unsigned type) == 1) || 					      \
       ( ((unsigned long)address & ~PAGE_MASK) <= 			      \
	 (PAGE_SIZE - sizeof(unsigned type) )) )			      \
    {									      \
      macro_parse_ptabs_read(address, page, offset);			      \
      if (page)								      \
	return *((unsigned type *)(page + offset));			      \
      else								      \
	return get_user_##name##_pf(address);				      \
    }									      \
  else									      \
    return get_user_##name##_slow_path((unsigned long)address);		      \
}

#endif

BUILD_USER_ACCESS(byte, char)
BUILD_USER_ACCESS(word, short)
BUILD_USER_ACCESS(long, long)

/*
 * Uh, these should become the main single-value transfer routines..
 * They automatically use the right size if we just have the right
 * pointer type..
 */
#define put_user(x,ptr) __put_user((unsigned long)(x),(ptr),sizeof(*(ptr)))
#define get_user(ptr) ((__typeof__(*(ptr)))__get_user((ptr),sizeof(*(ptr))))


/*
 * This is a silly but good way to make sure that
 * the __put_user function is indeed always optimized,
 * and that we use the correct sizes..
 */
extern int bad_user_access_length(void);

static inline void __put_user(unsigned long val, void * addr, int size)
{
	switch (size) {
		case 1:
		        put_user_byte((unsigned char)val, 
				      (unsigned char *)addr);
			break;
		case 2:
		        put_user_word((unsigned short)val, 
				      (unsigned short *)addr);
			break;
		case 4:
		        put_user_long((unsigned long)val, 
				      (unsigned long *)addr);
			break;
		default:
			bad_user_access_length();
	}
}

static inline unsigned long __get_user(const void * y, int size)
{
	switch (size) {
		case 1:
		       return get_user_byte((unsigned char *)y);
		case 2:
		       return get_user_word((unsigned short *)y);
		case 4:
		       return get_user_long((unsigned long *)y);
		default:
			return bad_user_access_length();
	}
}


/* L4 is not segmented, however we need to be able to fool verify_area()
 * when doing system calls from kernel mode legitimately.
 */
#define KERNEL_DS   0
#define USER_DS     ((short) (USER_VM_OFFSET >> 16))

static inline unsigned short get_fs(void)
{
  return current->tss.fs >> 16;
}

static inline unsigned short get_ds(void)
{
  return KERNEL_DS;
}

void set_fs(unsigned short val);
      

#endif /* ! __ASSEMBLY */

#endif /* ! __ASM_L4_I386_SEGMENT_H */
