/* net/atm/atmarp.h - RFC1577 ATM ARP */
 
/* Written 1995,1996 by Werner Almesberger, EPFL LRC */
 
 
#ifndef NET_ATM_ATMARP_H
#define NET_ATM_ATMARP_H

#include <linux/netdevice.h>
#include <linux/skbuff.h>
#include <linux/atm.h>
#include <linux/atmdev.h>
#include <linux/atmarp.h>


#define PRIV(dev) ((struct atmarp_priv *) ((struct device *) (dev)+1))
#define AE(vcc) ((struct atmarp_entry *) (vcc->user_back))


struct atmarp_entry {
	unsigned long	ip;		/* IP address, 0 if none */
	struct atm_vcc	*vcc;		/* active VCC */
	unsigned char encap;		/* 0: NULL, 1: LLC/SNAP */
	struct device	*dev;		/* device back pointer */
	void (*old_push)(struct atm_vcc *vcc,struct sk_buff *skb);
					/* keep old push fn for detaching */
	unsigned long last_use;		/* last send or receive operation */
	unsigned long idle_timeout;	/* keep open idle for so many jiffies*/
	struct sk_buff *queued;		/* queue one skb when resolving */
	struct atmarp_entry *next;	/* ugly linked list ... */
};

/* Entry is PVC iff vcc && vcc->family == AF_ATMPVC */
 

struct atmarp_priv {
	struct atmarp_entry *table;	/* ARP table */
	char name[8];			/* interface name */
	int number;			/* for convenience ... */
	struct enet_statistics stats;
	struct device *next;		/* next CLIP interface */
};


extern struct atm_vcc *atmarpd; /* ugly */


int clip_create(int number);
int atmarp_mkip(struct atm_vcc *vcc,int timeout);
int atmarp_setentry(struct atm_vcc *vcc,unsigned long ip);
int atmarp_encap(struct atm_vcc *vcc,int mode);

#endif
