/* net/atm/ipcommon.h - Common items for all ways of doing IP over ATM */

/* Written 1996,1997 by Werner Almesberger, EPFL LRC */


#ifndef NET_ATM_IPCOMMON_H
#define NET_ATM_IPCOMMON_H


#include <linux/string.h>
#include <linux/skbuff.h>
#include <linux/netdevice.h>
#include <linux/atmdev.h>
#include <linux/atmclip.h>


extern const unsigned char llc_oui[6];
extern struct device *clip_devs;


#define CLIP(dev) ((struct clip_priv *) ((struct device *) (dev)+1))


struct clip_priv {
	char name[8];			/* interface name */
	int number;			/* for convenience ... */
	struct atm_vcc *vcc;
	struct enet_statistics stats;
	struct clip_priv *next;		/* next CLIP interface */
};


extern struct clip_priv *old_clip_devs;


static inline void ipcom_push(struct sk_buff *skb)
{
	skb->mac.raw = skb->data;
	if (!skb->dev->hard_header_len) skb->protocol = htons(ETH_P_IP);
	else if (skb->len < RFC1483LLC_LEN || memcmp(skb->data,llc_oui,
		    sizeof(llc_oui))) skb->protocol = 0;
			/* probably wrong encap ... */
		else {
			skb->protocol = ((unsigned short *) skb->data)[3];
			skb_pull(skb,RFC1483LLC_LEN);
		}
	CLIP(skb->dev)->stats.rx_packets++;
	netif_rx(skb);
}


static inline void ipcom_xmit(struct device *dev,struct atm_vcc *vcc,
    struct sk_buff *skb)
{
	if (dev->hard_header_len) {
		memcpy(skb->data,llc_oui,sizeof(llc_oui));
		((unsigned short *) skb->data)[3] = htons(ETH_P_IP); /* hack */
	}
	atomic_add(skb->truesize,&vcc->tx_inuse);
	skb->atm.iovcnt = 0;
	vcc->dev->ops->send(vcc,skb);
}


struct sk_buff *atm_peek_clip(struct atm_vcc *vcc,unsigned long pdu_size,
    __u32 (*fetch)(struct atm_vcc *vcc,int i));
void atm_pop_clip(struct atm_vcc *vcc,struct sk_buff *skb);
void ipcom_init(struct device *dev,
    int (*hard_start_xmit)(struct sk_buff *skb,struct device *dev),
    unsigned short extra_flags);
int ipcom_pick_number(int number);
void skb_migrate(struct sk_buff_head *from,struct sk_buff_head *to);

#endif
