## ----echo = FALSE, message = FALSE--------------------------------------------
knitr::opts_chunk$set(collapse = T, comment = "#>")

## ----message = FALSE, warning=FALSE-------------------------------------------
library(booklet)
X <- iris[, 1:4]
head(X)

## -----------------------------------------------------------------------------
X_scaled <- pca_standardize_norm(X, center = TRUE, scale = TRUE)
head(X_scaled)

## -----------------------------------------------------------------------------
eigs <- pca_eigen(X_scaled)

## -----------------------------------------------------------------------------
# You can also use the `pca_ind_coords()` function.
ind_coords <- t(t(as.matrix(eigs[["U"]])) * sqrt(eigs[["values"]]))
head(ind_coords)

