/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.intlincomb;

import choco.cp.solver.constraints.integer.intlincomb.IntLinCombOp;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class IntLinCombLEQ
extends IntLinCombOp {
    public IntLinCombLEQ(int[] coeffs, int nbPosVars, int cste, IntDomainVar[] vars, AbstractSConstraint constraint) {
        super(coeffs, nbPosVars, cste, vars, constraint);
    }

    @Override
    public Boolean isEntailed() {
        if (this.coeffPolicy.computeLowerBound() > 0) {
            return Boolean.FALSE;
        }
        if (this.coeffPolicy.computeUpperBound() <= 0) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return this.compute(tuple) <= 0;
    }

    @Override
    public boolean filterOnImprovedLowerBound() throws ContradictionException {
        return this.propagateNewLowerBound(this.coeffPolicy.computeLowerBound());
    }

    @Override
    public boolean filterOnImprovedUpperBound() throws ContradictionException {
        return false;
    }

    @Override
    public boolean isConsistent() {
        return this.hasConsistentLowerBound();
    }

    @Override
    public AbstractSConstraint opposite(Solver solver) {
        IntExp term = solver.scalar(this.coeffs, this.vars);
        return (AbstractSConstraint)solver.gt(term, -this.cste);
    }

    @Override
    protected String getOperator() {
        return " <= ";
    }
}

