/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet;

import ec.util.spreadsheet.Cell;
import ec.util.spreadsheet.SheetConsumer;
import java.util.Objects;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class Sheet {
    public abstract int getRowCount();

    public abstract int getColumnCount();

    @Deprecated
    public abstract @Nullable Cell getCell(int var1, int var2) throws IndexOutOfBoundsException;

    public @Nullable Object getCellValue(int rowIdx, int columnIdx) throws IndexOutOfBoundsException {
        return Sheet.getCellValueFromCell(this, rowIdx, columnIdx);
    }

    @Deprecated
    public void forEach(@NonNull SheetConsumer<? super Cell> action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        Sheet.forEachByRow(this, action);
    }

    public void forEachValue(@NonNull SheetConsumer<? super Object> action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        Sheet.forEachValueByRow(this, action);
    }

    @NonNull
    public abstract String getName();

    @Deprecated
    @NonNull
    public Sheet inv() {
        return Sheet.invUsingDelegate(this);
    }

    private static void forEachByRow(@NonNull Sheet sheet, @NonNull SheetConsumer<? super Cell> action) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        Objects.requireNonNull(action);
        int rowCount = sheet.getRowCount();
        int columnCount = sheet.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Cell cell = sheet.getCell(i, j);
                if (cell == null) continue;
                action.accept(i, j, cell);
            }
        }
    }

    private static void forEachValueByRow(@NonNull Sheet sheet, @NonNull SheetConsumer<? super Object> action) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        Objects.requireNonNull(action);
        int rowCount = sheet.getRowCount();
        int columnCount = sheet.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Object value = sheet.getCellValue(i, j);
                if (value == null) continue;
                action.accept(i, j, value);
            }
        }
    }

    private static @Nullable Object getCellValueFromCell(@NonNull Sheet sheet, int rowIdx, int columnIdx) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        Cell cell = sheet.getCell(rowIdx, columnIdx);
        return cell != null ? cell.getValue() : null;
    }

    @NonNull
    private static Sheet invUsingDelegate(@NonNull Sheet sheet) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        return sheet instanceof InvSheet ? ((InvSheet)sheet).sheet : new InvSheet(sheet);
    }

    private static final class InvSheet
    extends Sheet {
        private final Sheet sheet;

        public InvSheet(Sheet sheet) {
            this.sheet = sheet;
        }

        @Override
        public int getRowCount() {
            return this.sheet.getColumnCount();
        }

        @Override
        public int getColumnCount() {
            return this.sheet.getRowCount();
        }

        @Override
        public Cell getCell(int rowIdx, int columnIdx) {
            return this.sheet.getCell(columnIdx, rowIdx);
        }

        @Override
        public Object getCellValue(int rowIdx, int columnIdx) throws IndexOutOfBoundsException {
            return this.sheet.getCellValue(columnIdx, rowIdx);
        }

        @Override
        public void forEach(SheetConsumer<? super Cell> action) {
            this.sheet.forEach((i, j, c) -> action.accept(j, i, (Cell)c));
        }

        @Override
        public void forEachValue(SheetConsumer<? super Object> action) {
            this.sheet.forEachValue((i, j, v) -> action.accept(j, i, v));
        }

        @Override
        public String getName() {
            return this.sheet.getName();
        }
    }
}

