/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.legacy.core;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.xml.legacy.core.XmlTimeSeries;
import jdplus.toolkit.base.xml.legacy.core.XmlTsPeriod;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TsDataType", propOrder={"frequency", "firstYear", "firstPeriod", "values"})
@XmlSeeAlso(value={})
public class XmlTsData
extends XmlTimeSeries {
    @XmlElement(name="Frequency")
    @XmlSchemaType(name="unsignedShort")
    protected int frequency;
    @XmlElement(name="FirstYear", required=true)
    @XmlSchemaType(name="gYear")
    protected int firstYear;
    @XmlElement(name="FirstPeriod")
    @XmlSchemaType(name="unsignedShort")
    protected Integer firstPeriod;
    @XmlElement(name="Values")
    @XmlList
    protected double[] values;
    @XmlAttribute(name="name")
    protected String description;
    private static final Adapter ADAPTER = new Adapter();

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int value) {
        this.frequency = value;
    }

    public int getFirstYear() {
        return this.firstYear;
    }

    public void setFirstYear(int value) {
        this.firstYear = value;
    }

    public Integer getFirstPeriod() {
        return this.firstPeriod;
    }

    public void setFirstPeriod(Integer value) {
        this.firstPeriod = value;
    }

    public double[] getValues() {
        return this.values;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public String getName() {
        return this.description;
    }

    public void setName(String value) {
        this.description = value;
    }

    public static TsData unmarshal(XmlTsData xml) {
        TsPeriod start = XmlTsPeriod.of(xml.frequency, xml.firstYear, xml.firstPeriod);
        return TsData.ofInternal((TsPeriod)start, (double[])xml.values);
    }

    public static boolean marshal(TsData v, XmlTsData xml) {
        TsPeriod start = v.getStart();
        xml.frequency = start.getUnit().getAnnualFrequency();
        xml.firstYear = start.year();
        xml.firstPeriod = xml.frequency != 1 ? Integer.valueOf(start.annualPosition() + 1) : null;
        xml.values = v.getValues().toArray();
        return true;
    }

    public static XmlAdapter<XmlTsData, TsData> getAdapter() {
        return ADAPTER;
    }

    public static class Adapter
    extends XmlAdapter<XmlTsData, TsData> {
        public TsData unmarshal(XmlTsData v) throws Exception {
            if (v == null) {
                return null;
            }
            return XmlTsData.unmarshal(v);
        }

        public XmlTsData marshal(TsData v) throws Exception {
            if (v == null) {
                return null;
            }
            XmlTsData xml = new XmlTsData();
            XmlTsData.marshal(v, xml);
            return xml;
        }
    }
}

