/*
 * Decompiled with CFR 0.152.
 */
package internal.text.base.api;

import java.io.IOException;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.HasDataHierarchy;
import jdplus.toolkit.base.tsp.stream.DataSetTs;
import jdplus.toolkit.base.tsp.stream.HasTsStream;
import jdplus.toolkit.base.tsp.util.DataSetConversion;
import jdplus.toolkit.base.tsp.util.DataSourcePreconditions;
import jdplus.toolkit.base.tsp.util.ImmutableValueFactory;
import lombok.Generated;
import lombok.NonNull;

public final class TxtSupport
implements HasDataHierarchy,
HasTsStream {
    @NonNull
    private final String providerName;
    @NonNull
    private final ImmutableValueFactory<TsCollection> txt;
    @NonNull
    private final DataSetConversion<TsCollection, Integer> seriesIndex;

    @NonNull
    public List<DataSet> children(@NonNull DataSource dataSource) throws IllegalArgumentException, IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSource)dataSource);
        TsCollection data = (TsCollection)this.txt.load(dataSource);
        DataSet.Converter seriesParam = this.seriesIndex.getConverter((Object)data);
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES);
        return IntStream.range(0, data.length()).mapToObj(index -> {
            seriesParam.set(builder, (Object)index);
            return builder.build();
        }).collect(Collectors.toList());
    }

    @NonNull
    public List<DataSet> children(@NonNull DataSet parent) throws IllegalArgumentException {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSet)parent);
        throw new IllegalArgumentException("Not supported yet.");
    }

    @NonNull
    public Stream<DataSetTs> getData(@NonNull DataSource dataSource, @NonNull TsInformationType type) throws IllegalArgumentException, IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSource)dataSource);
        TsCollection data = (TsCollection)this.txt.load(dataSource);
        DataSet.Converter seriesParam = this.seriesIndex.getConverter((Object)data);
        return IntStream.range(0, data.length()).mapToObj(this.getMapper(dataSource, data, (DataSet.Converter<Integer>)seriesParam));
    }

    @NonNull
    public Stream<DataSetTs> getData(@NonNull DataSet dataSet, @NonNull TsInformationType type) throws IllegalArgumentException, IOException {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSource)dataSet.getDataSource());
        TsCollection data = (TsCollection)this.txt.load(dataSet.getDataSource());
        DataSet.Converter seriesParam = this.seriesIndex.getConverter((Object)data);
        return IntStream.range(0, data.length()).filter(((Integer)seriesParam.get(dataSet))::equals).mapToObj(this.getMapper(dataSet.getDataSource(), data, (DataSet.Converter<Integer>)seriesParam));
    }

    private IntFunction<DataSetTs> getMapper(DataSource dataSource, TsCollection data, DataSet.Converter<Integer> seriesParam) {
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES);
        return index -> {
            seriesParam.set(builder, (Object)index);
            return new DataSetTs(builder.build(), data.get(index).getName(), data.get(index).getMeta(), data.get(index).getData());
        };
    }

    @Generated
    private TxtSupport(@NonNull String providerName, @NonNull ImmutableValueFactory<TsCollection> txt, @NonNull DataSetConversion<TsCollection, Integer> seriesIndex) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (txt == null) {
            throw new NullPointerException("txt is marked non-null but is null");
        }
        if (seriesIndex == null) {
            throw new NullPointerException("seriesIndex is marked non-null but is null");
        }
        this.providerName = providerName;
        this.txt = txt;
        this.seriesIndex = seriesIndex;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull TxtSupport of(@NonNull String providerName, @NonNull ImmutableValueFactory<TsCollection> txt, @NonNull DataSetConversion<TsCollection, Integer> seriesIndex) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (txt == null) {
            throw new NullPointerException("txt is marked non-null but is null");
        }
        if (seriesIndex == null) {
            throw new NullPointerException("seriesIndex is marked non-null but is null");
        }
        return new TxtSupport(providerName, txt, seriesIndex);
    }
}

