/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.math.matrices.decomposition.QRDecomposition;
import jdplus.toolkit.base.core.math.matrices.decomposition.Reflector;

public class Householder2 {
    private double[] qr;
    private double[] beta;
    private int m;
    private int n;

    public QRDecomposition decompose(FastMatrix A) {
        this.init(A);
        this.householder();
        return new QRDecomposition(FastMatrix.builder(this.qr).nrows(this.m).ncolumns(this.n).build(), this.beta, null);
    }

    private void init(FastMatrix A) {
        this.qr = A.toArray();
        this.m = A.getRowsCount();
        this.n = A.getColumnsCount();
        this.beta = new double[this.n];
    }

    private void householder() {
        int k = Math.min(this.m, this.n);
        Reflector hous = new Reflector(this.qr);
        FastMatrix M = FastMatrix.builder(this.qr).nrows(this.m).ncolumns(this.n).build();
        MatrixWindow wnd = M.all();
        int i = 0;
        int j = 0;
        while (i < k) {
            hous.set(j, this.m - i);
            hous.larfg();
            int nc = this.n - i - 1;
            if (nc > 0) {
                FastMatrix fm = wnd.bhshrink();
                if (hous.beta != 0.0) {
                    hous.lapply(fm);
                }
            }
            this.beta[i] = hous.beta;
            this.qr[j] = hous.alpha;
            wnd.bvshrink();
            ++i;
            j += this.m + 1;
        }
    }
}

