/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import org.rosuda.deducer.menu.OneWayPlotModel;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class KSamplePlots
extends JDialog
implements ActionListener {
    private JRadioButton plot;
    private JRadioButton noPlot;
    private JCheckBox scale;
    private JPanel okayCancelPanel;
    private JSeparator sep;
    private JLabel alphaLabel;
    private JSlider alpha;
    private JCheckBox points;
    private JCheckBox boxPlot;
    private OneWayPlotModel model;

    public KSamplePlots(JDialog jDialog, OneWayPlotModel oneWayPlotModel) {
        super(jDialog);
        this.initGUI();
        this.setModel(oneWayPlotModel);
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.plot = new JRadioButton();
            this.getContentPane().add(this.plot);
            this.plot.setText("Horizontal");
            this.plot.setBounds(21, 37, 102, 18);
            this.noPlot = new JRadioButton();
            this.getContentPane().add(this.noPlot);
            this.noPlot.setText("No Plot");
            this.noPlot.setBounds(21, 156, 102, 18);
            this.boxPlot = new JCheckBox();
            this.getContentPane().add(this.boxPlot);
            this.boxPlot.setText("Show Box Plot");
            this.boxPlot.setBounds(134, 10, 141, 18);
            this.points = new JCheckBox();
            this.getContentPane().add(this.points);
            this.points.setText("Show Points");
            this.points.setBounds(134, 37, 141, 18);
            this.scale = new JCheckBox();
            this.getContentPane().add(this.scale);
            this.scale.setText("Scale variables");
            this.scale.setBounds(134, 64, 141, 18);
            this.alpha = new JSlider();
            this.getContentPane().add(this.alpha);
            this.alpha.setBounds(134, 112, 140, 21);
            this.alpha.setMinimum(1);
            this.alpha.setMaximum(100);
            this.alphaLabel = new JLabel();
            this.getContentPane().add(this.alphaLabel);
            this.alphaLabel.setText("Transparancy");
            this.alphaLabel.setBounds(134, 92, 140, 14);
            this.alphaLabel.setHorizontalAlignment(0);
            this.sep = new JSeparator();
            this.getContentPane().add(this.sep);
            this.sep.setBounds(45, 140, 165, 10);
            this.okayCancelPanel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add(this.okayCancelPanel);
            this.okayCancelPanel.setBounds(73, 187, 182, 36);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.plot);
            buttonGroup.add(this.noPlot);
            this.setTitle("Plots");
            this.setResizable(false);
            this.setSize(275, 245);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setModel(OneWayPlotModel oneWayPlotModel) {
        this.plot.setSelected(oneWayPlotModel.plot);
        this.noPlot.setSelected(!oneWayPlotModel.plot);
        this.boxPlot.setSelected(oneWayPlotModel.box);
        this.points.setSelected(oneWayPlotModel.points);
        this.scale.setSelected(oneWayPlotModel.scale);
        this.alpha.setValue((int)(oneWayPlotModel.alpha * 100.0));
        this.model = oneWayPlotModel;
    }

    public void updateModel() {
        this.model.plot = this.plot.isSelected();
        this.model.box = this.boxPlot.isSelected();
        this.model.points = this.points.isSelected();
        this.model.scale = this.scale.isSelected();
        this.model.alpha = (double)this.alpha.getValue() / 100.0;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel") {
            this.dispose();
        } else if (string == "OK") {
            this.updateModel();
            this.dispose();
        }
    }
}

