/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MapValues;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureResolver;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static Apply createValueApply(Expression expression, Collection<?> values) {
        return ExpressionUtil.createValueApply(expression, null, values);
    }

    public static Apply createValueApply(Expression expression, DataType dataType, Collection<?> values) {
        Apply apply = ExpressionUtil.createApply(values.size() == 1 ? "equal" : "isIn", expression);
        for (Object value : values) {
            apply.addExpressions(new Expression[]{ExpressionUtil.createConstant(dataType, value)});
        }
        return apply;
    }

    public static Apply createApply(DefineFunction defineFunction, Expression ... expressions) {
        return ExpressionUtil.createApply(defineFunction.requireName(), expressions);
    }

    public static Apply createApply(String function, Expression ... expressions) {
        Apply apply = new Apply(function).addExpressions(expressions);
        return apply;
    }

    public static Constant createMissingConstant() {
        return ExpressionUtil.createConstant(null, null);
    }

    public static Constant createConstant(Number value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        return ExpressionUtil.createConstant(TypeUtil.getDataType(value), value);
    }

    public static Constant createConstant(DataType dataType, Object value) {
        Constant constant = new Constant(value).setDataType(dataType).setMissing(Boolean.valueOf(value == null));
        return constant;
    }

    public static MapValues createMapValues(String name, Map<?, ?> mapping) {
        ArrayList inputValues = new ArrayList();
        ArrayList outputValues = new ArrayList();
        Set<Map.Entry<?, ?>> entries = mapping.entrySet();
        for (Map.Entry entry : entries) {
            inputValues.add(entry.getKey());
            outputValues.add(entry.getValue());
        }
        return ExpressionUtil.createMapValues(name, inputValues, outputValues);
    }

    public static MapValues createMapValues(String name, List<?> inputValues, List<?> outputValues) {
        String inputColumn = "data:input";
        String outputColumn = "data:output";
        LinkedHashMap data = new LinkedHashMap();
        data.put(inputColumn, inputValues);
        data.put(outputColumn, outputValues);
        MapValues mapValues = new MapValues(outputColumn, PMMLUtil.createInlineTable(data)).addFieldColumnPairs(new FieldColumnPair[]{new FieldColumnPair(name, inputColumn)});
        return mapValues;
    }

    public static Expression toNegative(Expression expression) {
        if (expression instanceof Constant) {
            Constant constant = (Constant)expression;
            constant.setValue(ValueUtil.toNegative(constant.getValue()));
            return constant;
        }
        return ExpressionUtil.createApply("*", new Expression[]{ExpressionUtil.createConstant(-1), expression});
    }

    public static boolean isString(Expression expression, FeatureResolver featureResolver) {
        DataType dataType = ExpressionUtil.getDataType(expression, featureResolver);
        return dataType == DataType.STRING;
    }

    public static DataType getDataType(Expression expression, FeatureResolver featureResolver) {
        if (expression instanceof Constant) {
            Constant constant = (Constant)expression;
            return constant.getDataType();
        }
        if (expression instanceof FieldRef) {
            Feature feature;
            FieldRef fieldRef = (FieldRef)expression;
            Feature feature2 = feature = featureResolver != null ? featureResolver.resolveFeature(fieldRef.requireField()) : null;
            if (feature == null) {
                return null;
            }
            return feature.getDataType();
        }
        if (expression instanceof Apply) {
            String function;
            Apply apply = (Apply)expression;
            switch (function = apply.requireFunction()) {
                case "ceil": 
                case "floor": 
                case "round": {
                    return DataType.INTEGER;
                }
                case "isMissing": 
                case "isNotMissing": 
                case "isValid": 
                case "isNotValid": {
                    return DataType.BOOLEAN;
                }
                case "equal": 
                case "notEqual": 
                case "lessThan": 
                case "lessOrEqual": 
                case "greaterThan": 
                case "greaterOrEqual": {
                    return DataType.BOOLEAN;
                }
                case "and": 
                case "or": {
                    return DataType.BOOLEAN;
                }
                case "not": {
                    return DataType.BOOLEAN;
                }
                case "isIn": 
                case "isNotIn": {
                    return DataType.BOOLEAN;
                }
                case "if": {
                    List expressions = apply.getExpressions();
                    if (expressions.size() > 1) {
                        DataType trueDataType = ExpressionUtil.getDataType((Expression)expressions.get(1), featureResolver);
                        if (expressions.size() > 2) {
                            DataType falseDataType = ExpressionUtil.getDataType((Expression)expressions.get(2), featureResolver);
                            if (Objects.equals(trueDataType, falseDataType)) {
                                return trueDataType;
                            }
                            return null;
                        }
                        return trueDataType;
                    }
                    return null;
                }
                case "concat": 
                case "lowercase": 
                case "substring": 
                case "trimBlanks": 
                case "uppercase": {
                    return DataType.STRING;
                }
                case "stringLength": {
                    return DataType.INTEGER;
                }
                case "replace": {
                    return DataType.STRING;
                }
                case "matches": {
                    return DataType.BOOLEAN;
                }
                case "formatDatetime": 
                case "formatNumber": {
                    return DataType.STRING;
                }
                case "dateDaysSinceYear": 
                case "dateSecondsSinceMidnight": 
                case "dateSecondsSinceYear": {
                    return DataType.INTEGER;
                }
            }
            return null;
        }
        return null;
    }
}

