/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.sts;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;

public final class LocalLinearTrend {
    public static int dim() {
        return 2;
    }

    public static StateComponent stateComponent(double lvar, double svar) {
        Data data = new Data(lvar, svar);
        return new StateComponent(new Initialization(data), new Dynamics(data));
    }

    public static ISsfLoading defaultLoading() {
        return Loading.fromPosition(0);
    }

    @Generated
    private LocalLinearTrend() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Data {
        final double lv;
        final double sv;

        Data(double lv, double sv) {
            this.lv = lv;
            this.sv = sv;
        }
    }

    public static class Initialization
    implements ISsfInitialization {
        private final Data data;

        Initialization(Data data) {
            this.data = data;
        }

        @Override
        public int getStateDim() {
            return 2;
        }

        @Override
        public boolean isDiffuse() {
            return true;
        }

        @Override
        public int getDiffuseDim() {
            return 2;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            b.diagonal().set(1.0);
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix pf0) {
            if (this.data.lv > 0.0) {
                pf0.set(0, 0, this.data.lv);
            }
            if (this.data.sv > 0.0) {
                pf0.set(1, 1, this.data.sv);
            }
        }

        @Override
        public void Pi0(FastMatrix pi0) {
            pi0.diagonal().set(1.0);
        }
    }

    public static class Dynamics
    implements ISsfDynamics {
        private final Data data;

        Dynamics(Data data) {
            this.data = data;
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public int getInnovationsDim() {
            int n = 0;
            if (this.data.lv > 0.0) {
                ++n;
            }
            if (this.data.sv > 0.0) {
                ++n;
            }
            return n;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            if (this.data.lv > 0.0) {
                qm.set(0, 0, this.data.lv);
            }
            if (this.data.sv > 0.0) {
                qm.set(1, 1, this.data.sv);
            }
        }

        @Override
        public boolean hasInnovations(int pos) {
            return this.data.lv != 0.0 || this.data.sv != 0.0;
        }

        @Override
        public void S(int pos, FastMatrix s) {
            if (this.data.lv != 0.0 && this.data.sv != 0.0) {
                s.set(0, 0, Math.sqrt(this.data.lv));
                s.set(1, 1, Math.sqrt(this.data.sv));
            } else if (this.data.lv != 0.0) {
                s.set(1, 0, Math.sqrt(this.data.lv));
            } else if (this.data.sv != 0.0) {
                s.set(0, 1, Math.sqrt(this.data.sv));
            }
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            if (this.data.lv != 0.0 && this.data.sv != 0.0) {
                x.add(0, Math.sqrt(this.data.lv) * u.get(0));
                x.add(1, Math.sqrt(this.data.sv) * u.get(1));
            } else if (this.data.lv != 0.0) {
                x.add(0, Math.sqrt(this.data.lv) * u.get(0));
            } else if (this.data.sv != 0.0) {
                x.add(1, Math.sqrt(this.data.sv) * u.get(0));
            }
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            if (this.data.sv != 0.0 && this.data.lv != 0.0) {
                xs.set(0, Math.sqrt(this.data.lv) * x.get(0));
                xs.set(1, Math.sqrt(this.data.sv) * x.get(1));
            } else if (this.data.lv != 0.0) {
                xs.set(0, Math.sqrt(this.data.lv) * x.get(0));
            } else if (this.data.sv != 0.0) {
                xs.set(0, Math.sqrt(this.data.sv) * x.get(1));
            }
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            tr.set(0, 0, 1.0);
            tr.set(0, 1, 1.0);
            tr.set(1, 1, 1.0);
        }

        @Override
        public void TX(int pos, DataBlock x) {
            x.add(0, x.get(1));
        }

        @Override
        public void TVT(int pos, FastMatrix vm) {
            double v01 = vm.get(0, 1);
            double v11 = vm.get(1, 1);
            vm.add(0, 0, 2.0 * v01 + v11);
            vm.add(0, 1, v11);
            vm.add(1, 0, v11);
        }

        @Override
        public void XT(int pos, DataBlock x) {
            x.add(1, x.get(0));
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            if (this.data.lv > 0.0) {
                p.add(0, 0, this.data.lv);
            }
            if (this.data.sv > 0.0) {
                p.add(1, 1, this.data.sv);
            }
        }
    }
}

