/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.google.common.io.CharStreams;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jpmml.xgboost.FeatureMap;
import org.jpmml.xgboost.Learner;

public class XGBoostUtil {
    public static final String SERIALIZATION_HEADER = "CONFIG-offset:";
    public static final String BINF_HEADER = "binf";

    private XGBoostUtil() {
    }

    public static Learner loadLearner(InputStream is) throws IOException {
        return XGBoostUtil.loadLearner(is, ByteOrder.nativeOrder(), null);
    }

    public static Learner loadLearner(InputStream is, ByteOrder byteOrder, String charset) throws IOException {
        return XGBoostUtil.loadLearner(is, byteOrder, charset, "$");
    }

    public static Learner loadLearner(InputStream is, ByteOrder byteOrder, String charset, String jsonPath) throws IOException {
        is = new BufferedInputStream(is, 16384);
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            return XGBoostUtil.loadLearner(new DataInputStream(is), charset, jsonPath);
        }
        if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            return XGBoostUtil.loadLearner(new LittleEndianDataInputStream(is), charset, jsonPath);
        }
        throw new IllegalArgumentException();
    }

    public static <DIS extends InputStream> Learner loadLearner(DIS is, String charset, String jsonPath) throws IOException {
        if (!is.markSupported()) {
            throw new IllegalArgumentException();
        }
        String signature = XGBoostUtil.readSignature(is, 16);
        Learner learner = new Learner();
        if (signature.startsWith("{")) {
            if (XGBoostUtil.isText(signature)) {
                learner.loadJSON(is, charset, jsonPath);
            } else {
                learner.loadUBJSON(is, jsonPath);
            }
        } else {
            learner.loadBinary(is, charset);
        }
        return learner;
    }

    public static FeatureMap loadFeatureMap(InputStream is) throws IOException {
        FeatureMap featureMap = new FeatureMap();
        Iterator<String> lines = XGBoostUtil.parseFeatureMap(is);
        int i = 0;
        while (lines.hasNext()) {
            String line = lines.next();
            StringTokenizer st = new StringTokenizer(line, "\t");
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException(line);
            }
            String id = st.nextToken();
            String name = st.nextToken();
            String type = st.nextToken();
            if (Integer.parseInt(id) != i) {
                throw new IllegalArgumentException(id);
            }
            featureMap.addEntry(name, type);
            ++i;
        }
        return featureMap;
    }

    private static Iterator<String> parseFeatureMap(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, "UTF-8");
        List lines = CharStreams.readLines((Readable)reader);
        return lines.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readSignature(InputStream is, int limit) throws IOException {
        is.mark(limit);
        try {
            byte[] buffer = new byte[limit];
            int length = is.read(buffer);
            String string = new String(buffer, 0, length);
            return string;
        }
        finally {
            is.reset();
        }
    }

    private static boolean isText(String json) {
        if (!json.startsWith("{")) {
            throw new IllegalArgumentException();
        }
        for (int i = 1; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c == '\"';
        }
        return true;
    }
}

