/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.core.arima.ArimaException;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.math.matrices.decomposition.Gauss;
import jdplus.toolkit.base.core.math.matrices.decomposition.LUDecomposition;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.ssf.arima.ExactArimaForecasts;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.toolkit.base.core.ucarima.WienerKolmogorovEstimators;

public class BurmanEstimates {
    private static final double[] ONE = new double[]{1.0};
    private final int nfcasts;
    private final int nbcasts;
    private final DoubleSeq data;
    private final UcarimaModel ucm;
    private final boolean bmean;
    private final int mcmp;
    private final double ser;
    private final WienerKolmogorovEstimators wk;
    private double[] ar;
    private double[] ma;
    private double[][] g;
    private double mean;
    private double meanc;
    private double[] z;
    private DoubleSeq[] estimates;
    private DoubleSeq[] forecasts;
    private DoubleSeq[] backcasts;
    private DoubleSeq xbcasts;
    private DoubleSeq xfcasts;
    private LUDecomposition lu;
    private int nf;
    private int nbc;
    private int nfc;

    public static Builder builder() {
        return new Builder();
    }

    private BurmanEstimates(Builder builder) {
        this.data = builder.data;
        this.bmean = builder.bmean;
        this.mcmp = builder.mcmp;
        this.ucm = builder.ucm;
        this.ser = builder.ser;
        this.nfcasts = builder.nf;
        this.nbcasts = builder.nb;
        this.wk = new WienerKolmogorovEstimators(this.ucm);
        this.initModel();
        this.extendSeries();
        for (int i = 0; i < this.ucm.getComponentsCount(); ++i) {
            this.calc(i);
        }
    }

    private void calc(int cmp) {
        int i2;
        int i3;
        int i4;
        int j;
        int n = this.data.length();
        double fmu = 0.0;
        double bmu = 0.0;
        double mc = 0.0;
        if (this.mcmp == cmp) {
            if (this.isTrendConstant()) {
                double c = this.meanc;
                this.estimates[cmp] = DoubleSeq.onMapping((int)n, i -> c);
                this.forecasts[cmp] = DoubleSeq.onMapping((int)this.nfcasts, i -> c);
                this.backcasts[cmp] = DoubleSeq.onMapping((int)this.nbcasts, i -> c);
                return;
            }
            BackFilter sur = this.ucm.getComponent(cmp).getNonStationaryAr();
            if (this.mean != 0.0) {
                if (sur.isIdentity()) {
                    mc = this.meanc;
                } else {
                    bmu = this.mean;
                    double d = fmu = sur.get(0) * sur.get(sur.getDegree()) < 0.0 ? -this.mean : this.mean;
                }
            }
        }
        if (this.g[cmp] == null) {
            return;
        }
        int qstar = this.ma.length - 1;
        int pstar = this.ar.length - 1;
        int rstar = qstar + pstar;
        double[] gcur = this.g[cmp];
        int gstar = gcur.length - 1;
        int start = 0;
        int end = this.nbc + n + qstar;
        double[] w1 = new double[end];
        for (int i5 = start; i5 < end; ++i5) {
            double s = gcur[0] * this.z[i5];
            for (int k = 1; k <= gstar; ++k) {
                s += gcur[k] * this.z[i5 + k];
            }
            w1[i5] = s;
        }
        double[] ww = new double[rstar];
        int i6 = 0;
        int j2 = this.nbc + n + qstar - pstar;
        while (i6 < pstar) {
            ww[i6] = w1[j2];
            ++i6;
            ++j2;
        }
        for (i6 = pstar; i6 < ww.length; ++i6) {
            ww[i6] = fmu / 2.0;
        }
        this.lu.solve(DataBlock.of((double[])ww));
        double[] x1 = new double[this.nbc + n + this.nfc];
        start = this.nbc + n + qstar - pstar;
        int i7 = 0;
        int j3 = start;
        while (i7 < rstar) {
            x1[j3] = ww[i7];
            ++i7;
            ++j3;
        }
        end = 0;
        for (i7 = start - 1; i7 >= end; --i7) {
            double s = w1[i7];
            for (int k = 1; k < this.ma.length; ++k) {
                s -= x1[i7 + k] * this.ma[k];
            }
            x1[i7] = s / this.ma[0];
        }
        for (i7 = this.nbc + n + 2 * qstar; i7 < x1.length; ++i7) {
            double s = fmu / 2.0;
            for (j = 1; j <= pstar; ++j) {
                s -= this.ar[j] * x1[i7 - j];
            }
            x1[i7] = s;
        }
        double[] w2 = new double[n + this.nbc + this.nfc];
        start = this.nbc - qstar;
        end = this.nbc + n + this.nfc;
        for (i4 = start; i4 < end; ++i4) {
            double s = gcur[0] * this.z[i4];
            for (int k = 1; k <= gstar; ++k) {
                s += gcur[k] * this.z[i4 - k];
            }
            w2[i4] = s;
        }
        ww = new double[rstar];
        int j4 = this.nbc + pstar - qstar;
        for (i4 = 0; i4 < pstar; ++i4) {
            ww[i4] = w2[--j4];
        }
        for (i4 = pstar; i4 < ww.length; ++i4) {
            ww[i4] = bmu / 2.0;
        }
        this.lu.solve(DataBlock.of((double[])ww));
        double[] x2 = new double[n + this.nbc + this.nfc];
        start = this.nbc + pstar - qstar;
        j = start;
        for (i3 = 0; i3 < ww.length; ++i3) {
            x2[--j] = ww[i3];
        }
        for (i3 = start; i3 < x2.length; ++i3) {
            double s = w2[i3];
            for (int k = 1; k < this.ma.length; ++k) {
                s -= x2[i3 - k] * this.ma[k];
            }
            x2[i3] = s / this.ma[0];
        }
        for (i3 = this.nbc - 2 * qstar - 1; i3 >= 0; --i3) {
            double s = bmu / 2.0;
            for (int j5 = 1; j5 <= pstar; ++j5) {
                s -= this.ar[j5] * x2[i3 + j5];
            }
            x2[i3] = s;
        }
        double[] rslt = new double[n + this.nfc + this.nbc];
        for (i2 = 0; i2 < x1.length; ++i2) {
            rslt[i2] = x1[i2] + x2[i2];
        }
        this.estimates[cmp] = DoubleSeq.of((double[])rslt, (int)this.nbc, (int)n);
        if (mc != 0.0) {
            i2 = 0;
            while (i2 < rslt.length) {
                int n2 = i2++;
                rslt[n2] = rslt[n2] + mc;
            }
        }
        if (this.nfcasts > 0) {
            this.forecasts[cmp] = DoubleSeq.of((double[])rslt, (int)(n + this.nbc), (int)this.nfcasts);
        }
        if (this.nbcasts > 0) {
            this.backcasts[cmp] = DoubleSeq.of((double[])rslt, (int)(this.nbc - this.nbcasts), (int)this.nbcasts);
        }
    }

    public DoubleSeq estimates(int cmp, boolean signal) {
        if (signal) {
            return this.estimates[cmp];
        }
        return this.data.fastOp(this.estimates[cmp], (a, b) -> a - b);
    }

    private void extendSeries() {
        int q = this.ma.length - 1;
        int p = this.ar.length - 1;
        this.nf = q > p ? 2 * q : p + q;
        this.nbc = Math.max(this.nf, this.nbcasts);
        this.nfc = Math.max(this.nf, this.nfcasts);
        ExactArimaForecasts fcasts = new ExactArimaForecasts();
        fcasts.prepare(this.wk.getUcarimaModel().getModel(), this.bmean);
        this.xfcasts = fcasts.forecasts(this.data, this.nfc);
        this.xbcasts = fcasts.backcasts(this.data, this.nbc);
        this.mean = this.bmean ? fcasts.getMean() : 0.0;
        int n = this.data.length();
        this.z = new double[n + this.nbc + this.nfc];
        this.data.copyTo(this.z, this.nbc);
        this.xfcasts.copyTo(this.z, this.nbc + n);
        this.xbcasts.copyTo(this.z, 0);
        this.meanc = this.correctedMean();
        if (this.useMean()) {
            int i = 0;
            while (i < this.z.length) {
                int n2 = i++;
                this.z[n2] = this.z[n2] - this.meanc;
            }
        }
    }

    private double correctedMean() {
        IArimaModel arima = this.model();
        return this.mean / arima.getStationaryAr().asPolynomial().evaluateAt(1.0);
    }

    public DoubleSeq forecasts(int cmp, boolean signal) {
        if (signal) {
            return this.forecasts[cmp];
        }
        DoubleSeq xf = this.xfcasts.range(0, this.nfcasts);
        return this.forecasts[cmp].fastOp(xf, (a, b) -> a - b);
    }

    public DoubleSeq backcasts(int cmp, boolean signal) {
        if (signal) {
            return this.backcasts[cmp];
        }
        int nb = this.xbcasts.length();
        DoubleSeq xb = this.xbcasts.range(nb - this.nbcasts, nb);
        return this.backcasts[cmp].fastOp(xb, (a, b) -> a - b);
    }

    public DoubleSeq getSeriesBackcasts() {
        return this.xbcasts.drop(this.xbcasts.length() - this.nbcasts, 0);
    }

    public DoubleSeq getSeriesForecasts() {
        return this.xfcasts.range(0, this.nfcasts);
    }

    private void initModel() {
        IArimaModel model = this.ucm.getModel();
        int ncmps = this.ucm.getComponentsCount();
        this.estimates = new DoubleSeq[ncmps];
        this.forecasts = new DoubleSeq[ncmps];
        this.backcasts = new DoubleSeq[ncmps];
        this.g = new double[ncmps][];
        Polynomial pma = model.getMa().asPolynomial();
        double v = model.getInnovationVariance();
        if (v != 1.0) {
            pma = pma.times(Math.sqrt(v));
        }
        Polynomial par = model.getAr().asPolynomial();
        for (int i = 0; i < ncmps; ++i) {
            ArimaModel cmp = this.ucm.getComponent(i);
            if (cmp.isNull()) continue;
            SymmetricFilter sma = cmp.symmetricMa();
            if (!sma.isNull()) {
                BackFilter scar;
                BackFilter umar = model.getNonStationaryAr();
                BackFilter ucar = cmp.getNonStationaryAr();
                BackFilter nar = umar.divide(ucar);
                BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool();
                BackFilter smar = model.getStationaryAr();
                if (smp.simplify(smar, scar = cmp.getStationaryAr())) {
                    smar = (BackFilter)smp.getLeft();
                    scar = (BackFilter)smp.getRight();
                }
                BackFilter dar = scar;
                nar = nar.times(smar);
                BackFilter denom = new BackFilter(pma).times(dar);
                SymmetricFilter c = sma.times(SymmetricFilter.convolutionOf((IFiniteFilter)nar));
                double mvar = model.getInnovationVariance();
                if (mvar != 1.0) {
                    c = c.times(1.0 / mvar);
                }
                BackFilter gf = c.decompose(denom);
                this.g[i] = gf.asPolynomial().toArray();
                continue;
            }
            this.g[i] = ONE;
        }
        this.ma = pma.toArray();
        this.ar = par.toArray();
        this.initSolver();
    }

    private boolean isTrendConstant() {
        return this.wk.getUcarimaModel().getComponent(this.mcmp).isNull();
    }

    private boolean useMean() {
        return this.bmean && this.model().getNonStationaryArOrder() == 0;
    }

    private IArimaModel model() {
        return this.wk.getUcarimaModel().getModel();
    }

    private void initSolver() {
        int qstar = this.ma.length - 1;
        int pstar = this.ar.length - 1;
        FastMatrix M = FastMatrix.square((int)(pstar + qstar));
        MatrixWindow top = M.top(0);
        FastMatrix M1 = top.vnext(pstar);
        for (int j = 0; j <= qstar; ++j) {
            M1.subDiagonal(j).set(this.ma[j]);
        }
        FastMatrix M2 = top.vnext(qstar);
        for (int j = 0; j <= pstar; ++j) {
            M2.subDiagonal(j).set(this.ar[pstar - j]);
        }
        this.lu = Gauss.decompose((FastMatrix)M);
    }

    public boolean isMeanCorrection() {
        return this.bmean;
    }

    public DoubleSeq stdevEstimates(int cmp) {
        if (this.wk.getUcarimaModel().getComponent(cmp).isNull()) {
            return Doubles.EMPTY;
        }
        try {
            int n = (this.data.length() + 1) / 2;
            double[] err = this.wk.totalErrorVariance(cmp, true, 0, n);
            double[] e = new double[this.data.length()];
            for (int i = 0; i < err.length; ++i) {
                double x;
                e[i] = x = this.ser * Math.sqrt(err[i]);
                e[e.length - i - 1] = x;
            }
            return DoubleSeq.of((double[])e);
        }
        catch (ArimaException | MatrixException err) {
            return Doubles.EMPTY;
        }
    }

    public DoubleSeq stdevForecasts(int cmp, boolean signal) {
        if (this.wk.getUcarimaModel().getComponent(cmp).isNull() || this.nfcasts == 0) {
            return null;
        }
        try {
            double[] e = this.wk.totalErrorVariance(cmp, signal, -this.nfcasts, this.nfcasts);
            double[] err = new double[this.nfcasts];
            for (int i = 0; i < this.nfcasts; ++i) {
                err[i] = this.ser * Math.sqrt(e[this.nfcasts - 1 - i]);
            }
            return DoubleSeq.of((double[])err);
        }
        catch (ArimaException | MatrixException err) {
            return null;
        }
    }

    public DoubleSeq stdevBackcasts(int cmp, boolean signal) {
        if (this.wk.getUcarimaModel().getComponent(cmp).isNull() || this.nbcasts == 0) {
            return null;
        }
        try {
            double[] e = this.wk.totalErrorVariance(cmp, signal, -this.nbcasts, this.nbcasts);
            double[] err = new double[this.nbcasts];
            for (int j = this.nbcasts - 1; j >= 0; --j) {
                err[j] = this.ser * Math.sqrt(e[j]);
            }
            return DoubleSeq.of((double[])err);
        }
        catch (ArimaException | MatrixException err) {
            return null;
        }
    }

    public static class Builder {
        private int nf;
        private int nb;
        private DoubleSeq data;
        private UcarimaModel ucm;
        private boolean bmean;
        private int mcmp;
        private double ser = 1.0;

        public Builder forecastsCount(int nf) {
            this.nf = nf;
            return this;
        }

        public Builder backcastsCount(int nb) {
            this.nb = nb;
            return this;
        }

        public Builder data(DoubleSeq y) {
            this.data = y;
            return this;
        }

        public Builder mean(boolean mean) {
            this.bmean = mean;
            return this;
        }

        public Builder meanComponent(int cmp) {
            this.mcmp = cmp;
            return this;
        }

        public Builder innovationStdev(double ser) {
            this.ser = ser;
            return this;
        }

        public Builder ucarimaModel(UcarimaModel ucm) {
            this.ucm = ucm;
            return this;
        }

        public BurmanEstimates build() {
            return new BurmanEstimates(this);
        }
    }
}

