/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.api.timeseries.regression.IEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.ILengthOfPeriodVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.IRegressionModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.tramoseats.base.core.tramo.TramoModelBuilder;
import lombok.Generated;

public class AutomaticFRegressionTest
implements IRegressionModule {
    public static final double DEF_TMEAN = 1.96;
    public static final double DEF_TLP = 2.0;
    public static final double DEF_TEASTER = 2.2;
    public static final double DEF_FPVAL = 0.01;
    public static final String FTD = "F-based trading days tests";
    private final ITradingDaysVariable td;
    private final ITradingDaysVariable wd;
    private final ILengthOfPeriodVariable lp;
    private final boolean adjust;
    private final IEasterVariable easter;
    private final double tmean;
    private final double teaster;
    private final double tlp;
    private final double fpvalue;
    private final boolean testMean;
    private final double precision;

    public static Builder builder() {
        return new Builder();
    }

    private AutomaticFRegressionTest(Builder builder) {
        this.td = builder.td;
        this.wd = builder.wd;
        this.lp = builder.lp;
        this.easter = builder.easter;
        this.fpvalue = builder.fpvalue;
        this.tmean = builder.tmean;
        this.teaster = builder.teaster;
        this.tlp = builder.tlp;
        this.testMean = builder.testMean;
        this.precision = builder.precision;
        this.adjust = builder.adjust;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult test(RegSarimaModelling context) {
        context.getLog().push(FTD);
        try {
            ModelDescription current = context.getDescription();
            ModelDescription test0 = this.createTestModel(context, null, null);
            IRegArimaComputer processor = RegArimaUtility.processor((boolean)true, (double)this.precision);
            RegArimaEstimation regarima0 = processor.process(test0.regarima(), test0.mapping());
            ConcentratedLikelihoodWithMissing ll0 = regarima0.getConcentratedLikelihood();
            int nhp = test0.getArimaSpec().freeParametersCount();
            if (this.td == null) {
                ProcessingResult processingResult = this.update(current, test0, null, ll0, nhp);
                return processingResult;
            }
            ModelDescription test6 = this.createTestModel(context, this.td, null);
            RegArimaEstimation regarima6 = processor.process(test6.regarima(), test6.mapping());
            ConcentratedLikelihoodWithMissing ll6 = regarima6.getConcentratedLikelihood();
            ModelDescription test1 = this.createTestModel(context, this.wd, null);
            RegArimaEstimation regarima1 = processor.process(test1.regarima(), test1.mapping());
            ConcentratedLikelihoodWithMissing ll1 = regarima1.getConcentratedLikelihood();
            Info info = new Info(ll0, ll1, ll6, nhp);
            context.getLog().info(FTD, (Object)info);
            if (info.getPftd6() > info.getPftd1() && info.getPftd6() > 1.0 - this.fpvalue) {
                ModelDescription all = this.createTestModel(context, this.td, this.lp);
                RegArimaEstimation regarima = processor.process(all.regarima(), all.mapping());
                ProcessingResult processingResult = this.update(current, all, this.td, regarima.getConcentratedLikelihood(), nhp);
                return processingResult;
            }
            if (info.getPftd1() < 1.0 - this.fpvalue) {
                ProcessingResult all = this.update(current, test0, null, ll0, nhp);
                return all;
            }
            ModelDescription all = this.createTestModel(context, this.wd, this.lp);
            RegArimaEstimation regarima = processor.process(all.regarima(), all.mapping());
            ProcessingResult processingResult = this.update(current, all, this.wd, regarima.getConcentratedLikelihood(), nhp);
            return processingResult;
        }
        catch (Exception err) {
            ProcessingResult processingResult = ProcessingResult.Failed;
            return processingResult;
        }
        finally {
            context.getLog().pop();
        }
    }

    private ModelDescription createTestModel(RegSarimaModelling context, ITradingDaysVariable td, ILengthOfPeriodVariable lp) {
        ModelDescription tmp = ModelDescription.copyOf((ModelDescription)context.getDescription());
        if (td != null) {
            tmp.addVariable(Variable.variable((String)"td", (ITsVariable)td, TramoModelBuilder.calendarAMI));
            if (lp != null) {
                tmp.addVariable(Variable.variable((String)"lp", (ITsVariable)lp, TramoModelBuilder.calendarAMI));
            }
        }
        if (this.easter != null) {
            tmp.addVariable(Variable.variable((String)"easter", (ITsVariable)this.easter, TramoModelBuilder.calendarAMI));
        }
        return tmp;
    }

    private ProcessingResult update(ModelDescription current, ModelDescription test, ITradingDaysVariable aTd, ConcentratedLikelihoodWithMissing ll, int nhp) {
        int pos;
        boolean preadjustment;
        boolean changed = false;
        boolean bl = preadjustment = this.adjust && current.isLogTransformation();
        if (aTd != null) {
            current.addVariable(Variable.variable((String)"td", (ITsVariable)aTd, TramoModelBuilder.calendarAMI));
        }
        if (this.testMean) {
            boolean mean;
            boolean bl2 = mean = Math.abs(ll.tstat(0, nhp, true)) > this.tmean;
            if (mean != current.isMean()) {
                current.setMean(mean);
                changed = true;
            }
        }
        if (aTd != null && this.lp != null) {
            double tstat;
            pos = test.findPosition((ITsVariable)this.lp);
            double d = tstat = pos >= 0 ? ll.tstat(pos, nhp, true) : 0.0;
            if (Math.abs(tstat) > this.tlp) {
                if (preadjustment && tstat > 0.0) {
                    current.setPreadjustment(this.lp.getType());
                } else {
                    current.addVariable(Variable.variable((String)"lp", (ITsVariable)this.lp, TramoModelBuilder.calendarAMI));
                }
                changed = true;
            }
        }
        if (this.easter != null && (pos = test.findPosition((ITsVariable)this.easter)) >= 0 && Math.abs(ll.tstat(pos, nhp, true)) > this.teaster) {
            current.addVariable(Variable.variable((String)"easter", (ITsVariable)this.easter, TramoModelBuilder.calendarAMI));
            changed = true;
        }
        return changed ? ProcessingResult.Changed : ProcessingResult.Unchanged;
    }

    public static class Builder {
        private ITradingDaysVariable td;
        private ITradingDaysVariable wd;
        private ILengthOfPeriodVariable lp;
        private IEasterVariable easter;
        private double tmean = 1.96;
        private double tlp = 2.0;
        private double teaster = 2.2;
        private double fpvalue = 0.01;
        private boolean testMean = true;
        private double precision = 1.0E-5;
        private boolean adjust = false;

        public Builder tradingDays(ITradingDaysVariable td) {
            this.td = td;
            return this;
        }

        public Builder workingDays(ITradingDaysVariable wd) {
            this.wd = wd;
            return this;
        }

        public Builder leapYear(ILengthOfPeriodVariable lp) {
            this.lp = lp;
            return this;
        }

        public Builder adjust(boolean adjust) {
            this.adjust = adjust;
            return this;
        }

        public Builder easter(IEasterVariable easter) {
            this.easter = easter;
            return this;
        }

        public Builder meanThreshold(double tmean) {
            this.tmean = tmean;
            return this;
        }

        public Builder easterThreshold(double teaster) {
            this.teaster = teaster;
            return this;
        }

        public Builder lpThreshold(double tlp) {
            this.tlp = tlp;
            return this;
        }

        public Builder fPValue(double f) {
            this.fpvalue = f;
            return this;
        }

        public Builder testMean(boolean test) {
            this.testMean = test;
            return this;
        }

        public Builder estimationPrecision(double eps) {
            this.precision = eps;
            return this;
        }

        public AutomaticFRegressionTest build() {
            return new AutomaticFRegressionTest(this);
        }
    }

    public static class Info {
        final ConcentratedLikelihoodWithMissing ll0;
        final ConcentratedLikelihoodWithMissing ll1;
        final ConcentratedLikelihoodWithMissing ll6;
        final int nhp;
        final double ss0;
        final double ss1;
        final double ss6;
        final double ssmc1;
        final double ssmc6;
        final double pftd1;
        final double pftd6;

        public Info(ConcentratedLikelihoodWithMissing ll0, ConcentratedLikelihoodWithMissing ll1, ConcentratedLikelihoodWithMissing ll6, int nhp) {
            this.ll0 = ll0;
            this.ll1 = ll1;
            this.ll6 = ll6;
            this.nhp = nhp;
            this.ss0 = ll0.ssq();
            this.ss1 = ll1.ssq();
            this.ss6 = ll6.ssq();
            this.ssmc1 = this.ss1 / (double)(ll1.degreesOfFreedom() - nhp);
            this.ssmc6 = this.ss6 / (double)(ll6.degreesOfFreedom() - nhp);
            double ftd = (this.ss0 - this.ss1) / this.ssmc1;
            this.pftd1 = ftd <= 0.0 ? 0.0 : new F(1.0, (double)(ll1.degreesOfFreedom() - nhp)).getProbability(ftd, ProbabilityType.Lower);
            ftd = (this.ss0 - this.ss6) / (this.ssmc6 * 6.0);
            this.pftd6 = ftd <= 0.0 ? 0.0 : new F(6.0, (double)(ll6.degreesOfFreedom() - nhp)).getProbability(ftd, ProbabilityType.Lower);
        }

        public double SS0() {
            return this.ll0.ssq();
        }

        public double SS1() {
            return this.ll1.ssq();
        }

        public double SS6() {
            return this.ll6.ssq();
        }

        @Generated
        public ConcentratedLikelihoodWithMissing getLl0() {
            return this.ll0;
        }

        @Generated
        public ConcentratedLikelihoodWithMissing getLl1() {
            return this.ll1;
        }

        @Generated
        public ConcentratedLikelihoodWithMissing getLl6() {
            return this.ll6;
        }

        @Generated
        public int getNhp() {
            return this.nhp;
        }

        @Generated
        public double getSs0() {
            return this.ss0;
        }

        @Generated
        public double getSs1() {
            return this.ss1;
        }

        @Generated
        public double getSs6() {
            return this.ss6;
        }

        @Generated
        public double getSsmc1() {
            return this.ssmc1;
        }

        @Generated
        public double getSsmc6() {
            return this.ssmc6;
        }

        @Generated
        public double getPftd1() {
            return this.pftd1;
        }

        @Generated
        public double getPftd6() {
            return this.pftd6;
        }
    }
}

