#ifndef HAVE_CODE_GENERATOR_HPP
#define HAVE_CODE_GENERATOR_HPP
// Autogenerated - do not edit by hand !
#include <fstream>
#include <iostream>
#include <sstream>

#include "global.hpp"

namespace TMBad {

void searchReplace(std::string& str, const std::string& oldStr,
                   const std::string& newStr);

struct code_config {
  bool asm_comments;
  bool gpu;
  std::string indent;
  std::string header_comment;
  std::string float_str;
  std::ostream* cout;
  std::string float_ptr();
  std::string void_str();
  void init_code();
  void write_header_comment();
  code_config();
};

void write_common(std::ostringstream& buffer, code_config cfg, size_t node);

void write_forward(global& glob, code_config cfg = code_config());

void write_reverse(global& glob, code_config cfg = code_config());

void write_all(global glob, code_config cfg = code_config());

}  // namespace TMBad
#endif  // HAVE_CODE_GENERATOR_HPP
