EVAL <- isTRUE(as.logical(Sys.getenv("R_RGEEDIM_RUN_EXAMPLES"))) &&
  requireNamespace("terra", quietly = TRUE) &&
  rgeedim::gd_is_initialized(project = Sys.getenv("GOOGLE_CLOUD_QUOTA_PROJECT", "rgeedim-demo"))

litedown::reactor(
  eval = EVAL,
  collapse = TRUE,
  fig.width = 8,
  fig.align = 'center'
)

library(rgeedim)
library(terra)

project_id <- Sys.getenv("GOOGLE_CLOUD_QUOTA_PROJECT", "rgeedim-demo")
gd_initialize(project = project_id)

## Sacramento county area
# b <- soilDB::fetchSDA_spatial("CA067", "areasymbol", geom="sapolygon")
# sapply(terra::ext(b), as.numeric)

b <- gd_bbox(
  xmin = -121.9,
  ymax = 38.8,
  xmax = -121.0,
  ymin = 38.0
)

collection_name <- "NASA/ORNL/DAYMET_V4"

# search collection for spatial and date range
res <- collection_name |> 
  gd_collection_from_name() |> 
  gd_search(region = b,
            start_date = "2020-01-01", 
            end_date = "2020-02-01")

# inspect table of IDs and dates
gd_properties(res)
td <- tempdir()

# download each daily image in collection as separate GeoTIFF (no compositing)
# Note: `filename` is a directory
res |>
  gd_download(filename = td, 
              composite = FALSE, 
              region = b, 
              crs = "EPSG:5070", 
              scale = 1000)

# each EE image is named YYYYMMDD_1km, so geotiffs have same base name
r <- rast(list.files(td, pattern = "\\d{8}_1km.tif$", full.names = TRUE))
r2 <- r[[which(names(r) == "prcp")]]

# inspect: sum daily precip values -> monthly total
plot(sum(r2))

## optional: create animated GIF w/ {gifski}

# library(gifski)
# 
# r3 <- cumsum(r2 + 1e-3)
# gifski::save_gif({
#   res <- lapply(seq_len(nlyr(r3)), function(i) {
#     plot(
#       r3[[i]],
#       type = "continuous",
#       main = paste0("2020-01-", formatC(i, width = 2, flag = 0)),
#       range = c(0, 100)
#     )
#   })
# }, delay = 0.25, 
#    width = 400, 
#    height = 400)
#    
# browseURL("animation.gif")

unlink(list.files(td, pattern = "\\d{8}_1km.tif$", full.names = TRUE))

