/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.BoundHRTask;
import choco.cp.solver.constraints.global.scheduling.EnumHRTask;
import choco.cp.solver.constraints.global.scheduling.RTask;
import choco.kernel.common.util.bitmask.BitMask;
import choco.kernel.common.util.tools.IteratorUtils;
import choco.kernel.common.util.tools.TaskUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.global.scheduling.AbstractTaskSConstraint;
import choco.kernel.solver.constraints.global.scheduling.IResource;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.IRMakespan;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractResourceSConstraint
extends AbstractTaskSConstraint
implements IResource<TaskVar> {
    public static final int TASK_MASK = 11;
    protected final IRTask[] rtasks;
    protected final RMakespan makespan;
    protected final String name;
    protected final BitMask flags;
    private final int nbRegularTasks;
    private final int nbOptionalTasks;
    private final boolean enableHeights;
    private final int indexUnit;
    protected final int indexUB;

    public AbstractResourceSConstraint(Solver solver, String name, TaskVar[] taskvars, IntDomainVar makespan) {
        this(solver, name, taskvars, 0, false, false, makespan);
    }

    public AbstractResourceSConstraint(Solver solver, String name, TaskVar[] taskvars, int nbOptionalTasks, boolean enableHeights, boolean enableHypotheticalDomain, IntDomainVar ... intvars) {
        super(taskvars, intvars, solver.createIntegerConstant("unit", 1));
        this.name = name;
        this.nbOptionalTasks = nbOptionalTasks;
        this.nbRegularTasks = taskvars.length - nbOptionalTasks;
        this.enableHeights = enableHeights;
        this.indexUnit = this.getNbVars() - 1;
        this.indexUB = this.indexUnit - 1;
        this.flags = new BitMask();
        this.rtasks = new RTask[this.getNbTasks()];
        IEnvironment env = solver.getEnvironment();
        if (enableHypotheticalDomain) {
            int i;
            for (i = 0; i < this.nbRegularTasks; ++i) {
                this.rtasks[i] = new RTask(this, i);
            }
            for (i = this.nbRegularTasks; i < this.rtasks.length; ++i) {
                this.rtasks[i] = TaskUtils.hasEnumeratedDomain(taskvars[i]) ? new EnumHRTask(env, this, i) : new BoundHRTask(env, this, i);
            }
        } else {
            for (int i = 0; i < this.rtasks.length; ++i) {
                this.rtasks[i] = new RTask(this, i);
            }
        }
        this.makespan = new RMakespan();
    }

    public abstract void readOptions(List<String> var1);

    public final int indexOf(TaskVar task) {
        for (int i = 0; i < this.getNbTasks(); ++i) {
            if (this.taskvars[i] != task) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int getNbRegularTasks() {
        return this.nbRegularTasks;
    }

    @Override
    public final int getNbOptionalTasks() {
        return this.nbOptionalTasks;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return idx < this.taskIntVarOffset || idx >= this.taskIntVarOffset + this.nbOptionalTasks ? 11 : 8;
    }

    @Override
    public final IRTask getRTask(int idx) {
        return this.rtasks[idx];
    }

    protected final int getUsageIndex(int taskIdx) {
        return taskIdx < this.nbRegularTasks ? this.indexUnit : this.taskIntVarOffset + taskIdx - this.nbRegularTasks;
    }

    protected final int getHeightIndex(int taskIdx) {
        return this.enableHeights ? this.taskIntVarOffset + this.nbOptionalTasks + taskIdx : this.indexUnit;
    }

    public final void enforceTaskConsistency() throws ContradictionException {
        for (IRTask rt : this.rtasks) {
            rt.checkConsistency();
        }
    }

    public final BitMask getFlags() {
        return this.flags;
    }

    @Override
    public void awake() throws ContradictionException {
        this.enforceTaskConsistency();
        super.awake();
    }

    public final boolean checkTask(int varIdx) throws ContradictionException {
        if (varIdx < this.taskIntVarOffset) {
            if (varIdx < this.startOffset) {
                this.rtasks[varIdx].checkConsistency();
            } else if (varIdx < this.endOffset) {
                this.rtasks[varIdx - this.startOffset].checkConsistency();
            } else {
                this.rtasks[varIdx - this.endOffset].checkConsistency();
            }
            return true;
        }
        return false;
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.checkTask(varIndex);
        super.awakeOnBounds(varIndex);
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
        this.checkTask(varIdx);
        super.awakeOnInf(varIdx);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (!this.checkTask(idx) && idx < this.taskIntVarOffset + this.nbOptionalTasks) {
            int tIdx = idx - this.taskIntVarOffset + this.nbRegularTasks;
            if (((IntDomainVar[])this.vars)[idx].isInstantiatedTo(0)) {
                this.fireTaskRemoval(this.rtasks[tIdx]);
            } else {
                this.rtasks[tIdx].assign();
            }
        }
        super.awakeOnInst(idx);
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
        this.checkTask(varIdx);
        super.awakeOnSup(varIdx);
    }

    public void fireTaskRemoval(IRTask rtask) {
        throw new UnsupportedOperationException();
    }

    protected final boolean isTaskSatisfied(int[] tuple, int tidx) {
        return tuple[tidx] + tuple[this.endOffset + tidx] == tuple[this.startOffset + tidx];
    }

    protected final boolean isRegular(int[] tuple, int tidx) {
        return tuple[this.getUsageIndex(tidx)] == 1;
    }

    protected final int getHeight(int[] tuple, int tidx) {
        return tuple[this.getHeightIndex(tidx)];
    }

    public final boolean isCumulativeSatisfied(int[] tuple, int consumption, int capacity) {
        if (capacity < consumption) {
            return false;
        }
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        int n = this.getNbTasks();
        for (int tidx = 0; tidx < n; ++tidx) {
            if (!this.isTaskSatisfied(tuple, tidx)) {
                return false;
            }
            start = Math.min(start, tuple[this.getStartIndex(tidx)]);
            end = Math.max(end, tuple[this.getEndIndex(tidx)]);
        }
        if (end > tuple[this.indexUB]) {
            return false;
        }
        if (start < end) {
            int[] load = new int[end - start];
            for (int tidx = 0; tidx < n; ++tidx) {
                if (!this.isRegular(tuple, tidx)) continue;
                for (int i = tuple[this.getStartIndex(tidx)]; i < tuple[this.getEndIndex(tidx)]; ++i) {
                    int n2 = i - start;
                    load[n2] = load[n2] + this.getHeight(tuple, tidx);
                }
            }
            for (int aLoad : load) {
                if (aLoad <= capacity && (aLoad == 0 || aLoad >= consumption)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String pretty() {
        return this.pretty(this.getRscName());
    }

    @Override
    public final String getRscName() {
        return this.name;
    }

    @Override
    public final List<TaskVar> asTaskList() {
        return Arrays.asList(this.taskvars);
    }

    @Override
    public List<IRTask> asRTaskList() {
        return Arrays.asList(this.rtasks);
    }

    @Override
    public final Iterator<TaskVar> getTaskIterator() {
        return IteratorUtils.iterator(this.taskvars);
    }

    @Override
    public final Iterator<IRTask> getRTaskIterator() {
        return IteratorUtils.iterator(this.rtasks);
    }

    private final class RMakespan
    implements IRMakespan {
        private RMakespan() {
        }

        @Override
        public IntDomainVar getMakespan() {
            return ((IntDomainVar[])AbstractResourceSConstraint.this.vars)[AbstractResourceSConstraint.this.indexUB];
        }

        @Override
        public void updateInf(int value) throws ContradictionException {
            ((IntDomainVar[])AbstractResourceSConstraint.this.vars)[AbstractResourceSConstraint.this.indexUB].updateInf(value, AbstractResourceSConstraint.this, false);
        }

        @Override
        public void updateSup(int value) throws ContradictionException {
            ((IntDomainVar[])AbstractResourceSConstraint.this.vars)[AbstractResourceSConstraint.this.indexUB].updateSup(value, AbstractResourceSConstraint.this, false);
        }
    }
}

