/*
 * Decompiled with CFR 0.152.
 */
package internal.text.base.api;

import internal.text.base.api.TxtParam;
import java.util.Locale;
import java.util.function.Function;
import jdplus.text.base.api.TxtBean;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.util.ObsGathering;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.HasDataDisplayName;
import jdplus.toolkit.base.tsp.util.DataSourcePreconditions;
import lombok.Generated;
import lombok.NonNull;

public final class TxtDataDisplayName
implements HasDataDisplayName {
    private final String providerName;
    private final TxtParam param;
    private final Function<DataSource, TsCollection> data;

    @NonNull
    public String getDisplayName(@NonNull DataSource dataSource) throws IllegalArgumentException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSource)dataSource);
        TxtBean bean = (TxtBean)this.param.get(dataSource);
        return bean.getFile().getPath() + TxtDataDisplayName.toString(bean.getGathering());
    }

    @NonNull
    public String getDisplayName(@NonNull DataSet dataSet) throws IllegalArgumentException {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSet)dataSet);
        Integer index = (Integer)this.param.getSeriesParam().get(dataSet);
        TsCollection data = this.data.apply(dataSet.getDataSource());
        return data != null ? data.get(index.intValue()).getName() : "Column " + index;
    }

    @NonNull
    public String getDisplayNodeName(@NonNull DataSet dataSet) {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        return this.getDisplayName(dataSet);
    }

    private static String toString(ObsGathering gathering) {
        return TsUnit.UNDEFINED.equals((Object)gathering.getUnit()) ? "" : String.format(Locale.ROOT, "(%s/%s)", gathering.getUnit(), gathering.getAggregationType());
    }

    @Generated
    private TxtDataDisplayName(String providerName, TxtParam param, Function<DataSource, TsCollection> data) {
        this.providerName = providerName;
        this.param = param;
        this.data = data;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull TxtDataDisplayName of(String providerName, TxtParam param, Function<DataSource, TsCollection> data) {
        return new TxtDataDisplayName(providerName, param, data);
    }
}

