/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.calendars;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import lombok.Generated;
import lombok.NonNull;

public final class CalendarUtility {
    private static final int[] MONTHDAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] CUMULATEDMONTHDAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final String[] SMALLMONTH = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final ThreadLocal<GregorianCalendar> CALENDAR_THREAD_LOCAL = ThreadLocal.withInitial(() -> new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault()));

    public static int[] daysCount(@NonNull TsDomain domain) {
        int i;
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        int n = domain.length();
        int[] rslt = new int[n];
        LocalDate[] start = new LocalDate[n + 1];
        for (i = 0; i < n; ++i) {
            start[i] = domain.get(i).start().toLocalDate();
        }
        start[n] = domain.getEndPeriod().start().toLocalDate();
        for (i = 0; i < n; ++i) {
            int ni;
            rslt[i] = ni = (int)start[i].until(start[i + 1], ChronoUnit.DAYS);
        }
        return rslt;
    }

    public static LocalDate firstWeekDay(DayOfWeek day, int year, int month) {
        int istart;
        TsPeriod m = TsPeriod.monthly(year, month - 1);
        LocalDate start = m.start().toLocalDate();
        int iday = day.getValue();
        int n = iday - (istart = start.getDayOfWeek().getValue());
        if (n < 0) {
            n += 7;
        }
        if (n != 0) {
            start = start.plusDays(n);
        }
        return start;
    }

    static int calc(int year, int month, int day) {
        boolean bLeapYear = CalendarUtility.isLeap(year);
        int nDate = year * 365 + year / 4 - year / 100 + year / 400 + CalendarUtility.getCumulatedMonthDays(month - 1) + day;
        if (month < 3 && bLeapYear) {
            --nDate;
        }
        return nDate - 719528;
    }

    static int calcDays(int year, int ndays) {
        int np;
        if (year < 0 || year > 3000) {
            throw new TsException("Invalid year");
        }
        if (year < 30) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        }
        boolean bLeapYear = CalendarUtility.isLeap(year);
        int n = np = bLeapYear ? 366 : 365;
        if (ndays < 0 || ndays >= np) {
            throw new TsException("Invalid day");
        }
        int rslt = year * 365 + year / 4 - year / 100 + year / 400 + ndays - 719527;
        if (bLeapYear) {
            return rslt - 1;
        }
        return rslt;
    }

    public static boolean isLeap(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static int getCumulatedMonthDays(int month) {
        return CUMULATEDMONTHDAYS[month];
    }

    public static int getNumberOfDaysByMonth(int month) {
        return MONTHDAYS[month - 1];
    }

    public static int getNumberOfDaysByMonth(int year, int month) {
        if (month == 2 && CalendarUtility.isLeap(year)) {
            return 29;
        }
        return MONTHDAYS[month - 1];
    }

    public static String formatPeriod(int freq, int pos) {
        if (freq == 12) {
            return Month.of(pos + 1).toString();
        }
        if (freq <= 1) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        switch (freq) {
            case 4: {
                builder.append('Q');
                break;
            }
            case 2: {
                builder.append('H');
                break;
            }
            default: {
                builder.append('P');
            }
        }
        builder.append(pos + 1);
        return builder.toString();
    }

    public static String formatShortPeriod(int freq, int pos) {
        if (freq == 12) {
            return SMALLMONTH[pos];
        }
        return CalendarUtility.formatPeriod(freq, pos);
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = CALENDAR_THREAD_LOCAL.get();
        cal.setTime(date);
        return LocalDate.of(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    public static Date toDate(LocalDate date) {
        if (date == null) {
            return null;
        }
        Calendar cal = CALENDAR_THREAD_LOCAL.get();
        cal.set(date.getYear(), date.getMonthValue() - 1, date.getDayOfMonth());
        return cal.getTime();
    }

    @Generated
    private CalendarUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

