/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.r;

import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.modelling.TransformationType;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.regsarima.regular.CheckLast;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaProcessor;
import jdplus.tramoseats.base.api.tramo.TramoSpec;
import jdplus.tramoseats.base.api.tramo.TransformSpec;
import jdplus.tramoseats.base.core.tramo.TramoKernel;
import lombok.Generated;

public final class Terror {
    public static Matrix process(TsData series, String defSpec, int nback) {
        TramoSpec spec = TramoSpec.fromString((String)defSpec);
        return Terror.process(series, spec, null, nback);
    }

    public static Matrix process(TsData series, TramoSpec spec, ModellingContext context, int nback) {
        TramoKernel kernel;
        CheckLast cl;
        series = series.cleanExtremities();
        int n = series.length();
        boolean needlevel = series.getValues().range(n - nback, n).anyMatch(x -> Double.isFinite(x) && x <= 0.0);
        if (needlevel && spec.getTransform().getFunction() != TransformationType.None) {
            spec = (TramoSpec)spec.toBuilder().transform((TransformSpec)spec.getTransform().toBuilder().function(TransformationType.None).build()).build();
        }
        if (!(cl = new CheckLast((RegSarimaProcessor)(kernel = TramoKernel.of((TramoSpec)spec, (ModellingContext)context)), nback)).check(series.cleanExtremities())) {
            return null;
        }
        FastMatrix R = FastMatrix.make((int)nback, (int)7);
        R.column(0).copy(cl.getActualValues());
        R.column(1).copy(cl.getForecastsValues());
        R.column(2).copy(cl.getAbsoluteErrors());
        R.column(3).copyFrom(cl.getScores(), 0);
        R.column(4).copy(cl.getRawValues());
        R.column(5).copyFrom(cl.getRawForecasts(), 0);
        R.column(6).copyFrom(cl.getRawForecastsStdev(), 0);
        return R;
    }

    @Generated
    private Terror() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

